/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey PostingKey}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PostingKeyField
 * PostingKeyField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PostingKeyLink
 * PostingKeyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey#POSTING_KEY_ID
 * POSTING_KEY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey#POSTING_KEY_TEXT
 * POSTING_KEY_TEXT}</li>
 * </ul>
 *
 */
public interface PostingKeySelectable extends EntitySelectable<PostingKey>
{

}
