/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc
 * PredecessorReferenceDoc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PredecessorReferenceDocField
 * PredecessorReferenceDocField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PredecessorReferenceDocLink
 * PredecessorReferenceDocLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc#PREDECESSOR_REFERENCE_DOC_TYPE_ID
 * PREDECESSOR_REFERENCE_DOC_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc#PREDECESSOR_REFERENCE_DOC_TYPE_TEXT
 * PREDECESSOR_REFERENCE_DOC_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface PredecessorReferenceDocSelectable extends EntitySelectable<PredecessorReferenceDoc>
{

}
