/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID ProjectExternalID}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ProjectExternalIDField
 * ProjectExternalIDField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ProjectExternalIDLink
 * ProjectExternalIDLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID#PROJECT_EXTERNAL_IDID
 * PROJECT_EXTERNAL_IDID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID#PROJECT_EXTERNAL_ID_TEXT
 * PROJECT_EXTERNAL_ID_TEXT}</li>
 * </ul>
 *
 */
public interface ProjectExternalIDSelectable extends EntitySelectable<ProjectExternalID>
{

}
