/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete QuantityIsIncomplete}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.QuantityIsIncompleteField
 * QuantityIsIncompleteField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.QuantityIsIncompleteLink
 * QuantityIsIncompleteLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete#QUANTITY_IS_INCOMPLETE_ID
 * QUANTITY_IS_INCOMPLETE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete#QUANTITY_IS_INCOMPLETE_TEXT
 * QUANTITY_IS_INCOMPLETE_TEXT}</li>
 * </ul>
 *
 */
public interface QuantityIsIncompleteSelectable extends EntitySelectable<QuantityIsIncomplete>
{

}
