/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument ReferenceDocument}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ReferenceDocumentField
 * ReferenceDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ReferenceDocumentLink
 * ReferenceDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument#REFERENCE_DOCUMENT_TYPE_ID
 * REFERENCE_DOCUMENT_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument#REFERENCE_DOCUMENT_TYPE_TEXT
 * REFERENCE_DOCUMENT_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface ReferenceDocumentSelectable extends EntitySelectable<ReferenceDocument>
{

}
