/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem SalesDocumentItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SalesDocumentItemField
 * SalesDocumentItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.SalesDocumentItemLink
 * SalesDocumentItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem#SALES_DOCUMENT_ITEM_ID
 * SALES_DOCUMENT_ITEM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem#SALES_DOCUMENT_ITEM_TEXT
 * SALES_DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * </ul>
 *
 */
public interface SalesDocumentItemSelectable extends EntitySelectable<SalesDocumentItem>
{

}
