/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup SoldProductGroup}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SoldProductGroupField
 * SoldProductGroupField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.SoldProductGroupLink
 * SoldProductGroupLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup#SOLD_PRODUCT_GROUP_ID
 * SOLD_PRODUCT_GROUP_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup#SOLD_PRODUCT_GROUP_TEXT
 * SOLD_PRODUCT_GROUP_TEXT}</li>
 * </ul>
 *
 */
public interface SoldProductGroupSelectable extends EntitySelectable<SoldProductGroup>
{

}
