/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode SpecialGLCode}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SpecialGLCodeField
 * SpecialGLCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.SpecialGLCodeLink SpecialGLCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode#SPECIAL_GL_CODE_ID
 * SPECIAL_GL_CODE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode#SPECIAL_GL_CODE_TEXT
 * SPECIAL_GL_CODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode#FINANCIAL_ACCOUNT_TYPE
 * FINANCIAL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode#FINANCIAL_ACCOUNT_TYPE_NAME
 * FINANCIAL_ACCOUNT_TYPE_NAME}</li>
 * </ul>
 *
 */
public interface SpecialGLCodeSelectable extends EntitySelectable<SpecialGLCode>
{

}
