/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters
 * TRIALBALANCEParameters}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.TRIALBALANCEParametersField
 * TRIALBALANCEParametersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.TRIALBALANCEParametersLink
 * TRIALBALANCEParametersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters#P_FROM_POSTING_DATE
 * P_FROM_POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters#P_FROM_POSTING_DATE_TEXT
 * P_FROM_POSTING_DATE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters#P_TO_POSTING_DATE
 * P_TO_POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters#P_TO_POSTING_DATE_TEXT
 * P_TO_POSTING_DATE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters#TO_RESULTS
 * TO_RESULTS}</li>
 * </ul>
 *
 */
public interface TRIALBALANCEParametersSelectable extends EntitySelectable<TRIALBALANCEParameters>
{

}
