/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult TRIALBALANCEResult}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.TRIALBALANCEResultField
 * TRIALBALANCEResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.TRIALBALANCEResultLink
 * TRIALBALANCEResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ID ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TOTALED_PROPERTIES
 * TOTALED_PROPERTIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GL_ACCOUNT_HIERARCHY_NAME
 * GL_ACCOUNT_HIERARCHY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY8
 * FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_COST_OBJECT
 * PARTNER_COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ASSET_VALUE_DATE
 * ASSET_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ASSET_VALUE_DATE_T
 * ASSET_VALUE_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#QUANTITY_IS_INCOMPLETE
 * QUANTITY_IS_INCOMPLETE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#IS_OPEN_ITEM_MANAGED
 * IS_OPEN_ITEM_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CORPORATE_GROUP_ACCOUNT
 * CORPORATE_GROUP_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CORPORATE_GROUP_ACCOUNT_T
 * CORPORATE_GROUP_ACCOUNT_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#BILLING_DOCUMENT_TYPE
 * BILLING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_QUARTER
 * FISCAL_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CORPORATE_GROUP_CHART_OF_ACCOUNTS
 * CORPORATE_GROUP_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CLEARING_DOC_FISCAL_YEAR
 * CLEARING_DOC_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_WBS_ELEMENT
 * PARTNER_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY2
 * FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_PROFIT_CENTER_NAME
 * PARTNER_PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_CONTROLLING_OBJECT_CLASS
 * PARTNER_CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GL_ACCOUNT_TYPE
 * GL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ACCOUNTING_DOCUMENT_CATEGORY
 * ACCOUNTING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#BUSINESS_TRANSACTION_TYPE
 * BUSINESS_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CALENDAR_MONTH
 * CALENDAR_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CALENDAR_QUARTER
 * CALENDAR_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CLEARING_ACCOUNTING_DOCUMENT
 * CLEARING_ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ACCOUNTING_DOCUMENT_TYPE
 * ACCOUNTING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ACCOUNTING_DOCUMENT_TYPE_NAME
 * ACCOUNTING_DOCUMENT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FINANCIAL_ACCOUNT_TYPE
 * FINANCIAL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FINANCIAL_ACCOUNT_TYPE_NAME
 * FINANCIAL_ACCOUNT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#BUSINESS_AREA_NAME
 * BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ORIGIN_COST_CTR_ACTIVITY_TYPE
 * ORIGIN_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CONTROLLING_OBJECT_CLASS
 * CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_COST_CENTER
 * PARTNER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SENDER_COST_CENTER_NAME
 * SENDER_COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_CREDIT_CODE_NAME
 * DEBIT_CREDIT_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#POSTING_DATE_T
 * POSTING_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FUNCTIONAL_AREA_NAME
 * FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CALENDAR_WEEK
 * CALENDAR_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CALENDAR_YEAR
 * CALENDAR_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CLEARING_DATE
 * CLEARING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CLEARING_DATE_T
 * CLEARING_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_WEEK
 * FISCAL_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#IS_REVERSAL
 * IS_REVERSAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#IS_REVERSED
 * IS_REVERSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#IS_SETTLED
 * IS_SETTLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#IS_SETTLEMENT
 * IS_SETTLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#JOINT_VENTURE
 * JOINT_VENTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_FUND
 * PARTNER_FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_GRANT
 * PARTNER_GRANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_ORDER
 * PARTNER_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SOLD_MATERIAL
 * SOLD_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SOLD_PRODUCT
 * SOLD_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVENTORY_SPECIAL_STOCK_VALN_TYPE
 * INVENTORY_SPECIAL_STOCK_VALN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#LEDGER LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#POSTING_KEY
 * POSTING_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#POSTING_KEY_NAME
 * POSTING_KEY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PROFIT_CENTER_NAME
 * PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SEGMENT SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SEGMENT_NAME
 * SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SPECIAL_GL_CODE
 * SPECIAL_GL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#JOINT_VENTURE_EQUITY_TYPE
 * JOINT_VENTURE_EQUITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ALTERNATIVE_GL_ACCOUNT
 * ALTERNATIVE_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ALTERNATIVE_GL_ACCOUNT_T
 * ALTERNATIVE_GL_ACCOUNT_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ORDER_CATEGORY
 * ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PRODUCT_GROUP
 * PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PROJECT PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CUSTOMER_GROUP_NAME
 * CUSTOMER_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVENTORY_SPCL_STK_SALES_DOCUMENT
 * INVENTORY_SPCL_STK_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVENTORY_SPCL_STK_SALES_DOC_ITM
 * INVENTORY_SPCL_STK_SALES_DOC_ITM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID
 * INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVENTORY_SPCL_STOCK_WBS_ELEMENT
 * INVENTORY_SPCL_STOCK_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CALENDAR_YEAR_MONTH
 * CALENDAR_YEAR_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CUSTOMER_NAME
 * CUSTOMER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SUPPLIER_NAME
 * SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#BALANCE_TRANSACTION_CURRENCY
 * BALANCE_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_PROJECT_NETWORK_ACTIVITY
 * PARTNER_PROJECT_NETWORK_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CALENDAR_YEAR_QUARTER
 * CALENDAR_YEAR_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#IS_BALANCE_SHEET_ACCOUNT
 * IS_BALANCE_SHEET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_ACCOUNT_ASSIGNMENT_TYPE
 * PARTNER_ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_YEAR_WEEK
 * FISCAL_YEAR_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#JOINT_VENTURE_EQUITY_GROUP
 * JOINT_VENTURE_EQUITY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SENDER_ACCOUNT_ASSIGNMENT
 * SENDER_ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_YEAR_QUARTER
 * FISCAL_YEAR_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GROUP_FIXED_ASSET
 * GROUP_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#REFERENCE_DOCUMENT_ITEM_GROUP
 * REFERENCE_DOCUMENT_ITEM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ASSET_DEPRECIATION_AREA
 * ASSET_DEPRECIATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_SEGMENT_NAME
 * PARTNER_SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CLEARING_JOURNAL_ENTRY
 * CLEARING_JOURNAL_ENTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#OPERATING_CONCERN
 * OPERATING_CONCERN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID
 * INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_PERIOD_END_DATE
 * FISCAL_PERIOD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_PERIOD_END_DATE_T
 * FISCAL_PERIOD_END_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COUNTRY_CHART_OF_ACCOUNTS
 * COUNTRY_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_PERIOD_START_DATE
 * FISCAL_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_PERIOD_START_DATE_T
 * FISCAL_PERIOD_START_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY6
 * FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ACCOUNT_ASSIGNMENT
 * ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_COST_CTR_ACTIVITY_TYPE
 * PARTNER_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_BUSINESS_PROCESS
 * PARTNER_BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#RELATED_NETWORK_ACTIVITY
 * RELATED_NETWORK_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY1
 * FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FISCAL_PERIOD_DATE
 * FISCAL_PERIOD_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY3
 * FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ASSET_TRANSACTION_TYPE
 * ASSET_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVTRY_SPECIAL_STOCK_VALN_TYPE_2
 * INVTRY_SPECIAL_STOCK_VALN_TYPE_2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ELIMINATION_PROFIT_CENTER
 * ELIMINATION_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ELIMINATION_PROFIT_CENTER_NAME
 * ELIMINATION_PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PREDECESSOR_REFERENCE_DOC_TYPE
 * PREDECESSOR_REFERENCE_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#LEDGER_FISCAL_YEAR
 * LEDGER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_SALES_DOCUMENT
 * PARTNER_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_ACCOUNT_ASSIGNMENT
 * PARTNER_ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#OFFSETTING_ACCOUNT
 * OFFSETTING_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_BUDGET_PERIOD
 * PARTNER_BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ACCOUNTING_DOC_CREATED_BY_USER
 * ACCOUNTING_DOC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY4
 * FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#LINE_ITEM_IS_COMPLETED
 * LINE_ITEM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_PROJECT_INTERNAL_ID
 * PARTNER_PROJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_PROJECT_EXTERNAL_ID
 * PARTNER_PROJECT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#JOINT_VENTURE_COST_RECOVERY_CODE
 * JOINT_VENTURE_COST_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVENTORY_SPECIAL_STOCK_SUPPLIER
 * INVENTORY_SPECIAL_STOCK_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVTRY_SPECIAL_STOCK_SUPPLIER_NAME
 * INVTRY_SPECIAL_STOCK_SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ACCOUNT_ASSIGNMENT_TYPE
 * ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SOLD_PRODUCT_GROUP
 * SOLD_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#MATERIAL_GROUP_NAME
 * MATERIAL_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_PROJECT
 * PARTNER_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CLEARING_JOURNAL_ENTRY_FISCAL_YEAR
 * CLEARING_JOURNAL_ENTRY_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#LOGICAL_SYSTEM
 * LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PERSONNEL_NUMBER
 * PERSONNEL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GROUP_MASTER_FIXED_ASSET
 * GROUP_MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_ORDER_CATEGORY
 * PARTNER_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_BUSINESS_AREA_NAME
 * PARTNER_BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_FUNCTIONAL_AREA_NAME
 * PARTNER_FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PROJECT_EXTERNAL_ID
 * PROJECT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ORIGIN_COST_CENTER
 * ORIGIN_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY5
 * FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ORIGIN_OBJECT_TYPE
 * ORIGIN_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CONTROLLING_OBJECT_DEBIT_TYPE
 * CONTROLLING_OBJECT_DEBIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_WBS_ELEMENT_INTERNAL_ID
 * PARTNER_WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_WBS_ELEMENT_EXTERNAL_ID
 * PARTNER_WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#GL_ACCOUNT_HIERARCHY
 * GL_ACCOUNT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CUSTOMER_SERVICE_NOTIFICATION
 * CUSTOMER_SERVICE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#FREE_DEFINED_CURRENCY7
 * FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ACCOUNT_ASSIGNMENT_NUMBER
 * ACCOUNT_ASSIGNMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TRANSACTION_TYPE_DETERMINATION
 * TRANSACTION_TYPE_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_PROJECT_NETWORK
 * PARTNER_PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_COMPANY_CODE
 * PARTNER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#OFFSETTING_ACCOUNT_TYPE
 * OFFSETTING_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CALENDAR_YEAR_WEEK
 * CALENDAR_YEAR_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SENDER_ACCOUNT_ASSIGNMENT_TYPE
 * SENDER_ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SENDER_GL_ACCOUNT
 * SENDER_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#PARTNER_SALES_DOCUMENT_ITEM
 * PARTNER_SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SETTLEMENT_REFERENCE_DATE
 * SETTLEMENT_REFERENCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#SETTLEMENT_REFERENCE_DATE_T
 * SETTLEMENT_REFERENCE_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_CO_CODE_CRCY
 * STARTING_BALANCE_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_CO_CODE_CRCY_F
 * STARTING_BALANCE_AMT_IN_CO_CODE_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_CO_CODE_CRCY_E
 * STARTING_BALANCE_AMT_IN_CO_CODE_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_CO_CODE_CRCY
 * DEBIT_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_CO_CODE_CRCY_F
 * DEBIT_AMOUNT_IN_CO_CODE_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_CO_CODE_CRCY_E
 * DEBIT_AMOUNT_IN_CO_CODE_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_CO_CODE_CRCY
 * CREDIT_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_CO_CODE_CRCY_F
 * CREDIT_AMOUNT_IN_CO_CODE_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_CO_CODE_CRCY_E
 * CREDIT_AMOUNT_IN_CO_CODE_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_CO_CODE_CRCY
 * ENDING_BALANCE_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_CO_CODE_CRCY_F
 * ENDING_BALANCE_AMT_IN_CO_CODE_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_CO_CODE_CRCY_E
 * ENDING_BALANCE_AMT_IN_CO_CODE_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_GLOBAL_CRCY
 * STARTING_BALANCE_AMT_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_GLOBAL_CRCY_F
 * STARTING_BALANCE_AMT_IN_GLOBAL_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_GLOBAL_CRCY_E
 * STARTING_BALANCE_AMT_IN_GLOBAL_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_GLOBAL_CRCY
 * DEBIT_AMOUNT_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_GLOBAL_CRCY_F
 * DEBIT_AMOUNT_IN_GLOBAL_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_GLOBAL_CRCY_E
 * DEBIT_AMOUNT_IN_GLOBAL_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_GLOBAL_CRCY
 * CREDIT_AMOUNT_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_GLOBAL_CRCY_F
 * CREDIT_AMOUNT_IN_GLOBAL_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_GLOBAL_CRCY_E
 * CREDIT_AMOUNT_IN_GLOBAL_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_GLOBAL_CRCY
 * ENDING_BALANCE_AMT_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_GLOBAL_CRCY_F
 * ENDING_BALANCE_AMT_IN_GLOBAL_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_GLOBAL_CRCY_E
 * ENDING_BALANCE_AMT_IN_GLOBAL_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY1
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY1_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY1_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY1_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY1_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY1
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY1_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY1_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY1_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY1_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY1
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY1_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY1_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY1_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY1_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY1
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY1_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY1_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY1_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY1_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY2
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY2_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY2_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY2_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY2_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY2
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY2_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY2_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY2_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY2_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY2
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY2_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY2_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY2_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY2_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY2
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY2_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY2_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY2_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY2_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY3
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY3_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY3_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY3_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY3_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY3
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY3_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY3_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY3_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY3_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY3
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY3_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY3_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY3_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY3_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY3
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY3_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY3_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY3_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY3_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY4
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY4_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY4_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY4_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY4_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY4
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY4_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY4_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY4_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY4_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY4
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY4_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY4_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY4_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY4_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY4
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY4_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY4_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY4_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY4_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY5
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY5_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY5_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY5_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY5_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY5
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY5_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY5_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY5_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY5_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY5
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY5_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY5_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY5_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY5_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY5
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY5_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY5_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY5_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY5_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY6
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY6_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY6_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY6_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY6_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY6
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY6_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY6_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY6_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY6_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY6
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY6_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY6_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY6_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY6_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY6
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY6_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY6_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY6_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY6_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY7
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY7_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY7_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY7_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY7_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY7
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY7_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY7_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY7_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY7_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY7
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY7_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY7_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY7_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY7_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY7
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY7_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY7_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY7_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY7_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY8
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY8_F
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY8_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STRTG_BAL_AMT_IN_FREE_DFND_CRCY8_E
 * STRTG_BAL_AMT_IN_FREE_DFND_CRCY8_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY8
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY8_F
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY8_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_FREE_DFND_CRCY8_E
 * DEBIT_AMOUNT_IN_FREE_DFND_CRCY8_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY8
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY8_F
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY8_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_FREE_DFND_CRCY8_E
 * CREDIT_AMOUNT_IN_FREE_DFND_CRCY8_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY8
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY8_F
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY8_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BAL_AMT_IN_FREE_DFND_CRCY8_E
 * ENDING_BAL_AMT_IN_FREE_DFND_CRCY8_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BAL_AMT_IN_BAL_TRANS_CRCY
 * STARTING_BAL_AMT_IN_BAL_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BAL_AMT_IN_BAL_TRANS_CRCY_F
 * STARTING_BAL_AMT_IN_BAL_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BAL_AMT_IN_BAL_TRANS_CRCY_E
 * STARTING_BAL_AMT_IN_BAL_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY
 * DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY_F
 * DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY_E
 * DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY
 * CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY_F
 * CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY_E
 * CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY
 * ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY_F
 * ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY_E
 * ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_TRANS_CRCY
 * STARTING_BALANCE_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_TRANS_CRCY_F
 * STARTING_BALANCE_AMT_IN_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#STARTING_BALANCE_AMT_IN_TRANS_CRCY_E
 * STARTING_BALANCE_AMT_IN_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_TRANS_CRCY
 * DEBIT_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_TRANS_CRCY_F
 * DEBIT_AMOUNT_IN_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#DEBIT_AMOUNT_IN_TRANS_CRCY_E
 * DEBIT_AMOUNT_IN_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_TRANS_CRCY
 * CREDIT_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_TRANS_CRCY_F
 * CREDIT_AMOUNT_IN_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#CREDIT_AMOUNT_IN_TRANS_CRCY_E
 * CREDIT_AMOUNT_IN_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_TRANS_CRCY
 * ENDING_BALANCE_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_TRANS_CRCY_F
 * ENDING_BALANCE_AMT_IN_TRANS_CRCY_F}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#ENDING_BALANCE_AMT_IN_TRANS_CRCY_E
 * ENDING_BALANCE_AMT_IN_TRANS_CRCY_E}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARAMETERS
 * TO_PARAMETERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_LEDGER_DETAILS
 * TO_LEDGER_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_COMPANY_CODE_DETAILS
 * TO_COMPANY_CODE_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_GL_ACCOUNT_DETAILS
 * TO_GL_ACCOUNT_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_ORDER_ID_DETAILS
 * TO_ORDER_ID_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PROJECT_NETWORK_DETAILS
 * TO_PROJECT_NETWORK_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PROJECT_DETAILS
 * TO_PROJECT_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_BUSINESS_PROCESS_DETAILS
 * TO_BUSINESS_PROCESS_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_BILLING_DOCUMENT_TYPE_DETAILS
 * TO_BILLING_DOCUMENT_TYPE_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_SALES_ORGANIZATION_DETAILS
 * TO_SALES_ORGANIZATION_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_DISTRIBUTION_CHANNEL_DETAILS
 * TO_DISTRIBUTION_CHANNEL_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_SOLD_PRODUCT_DETAILS
 * TO_SOLD_PRODUCT_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_COMPANY_DETAILS
 * TO_PARTNER_COMPANY_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_ORDER_DETAILS
 * TO_PARTNER_ORDER_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_WBS_ELEMENT_DETAILS
 * TO_PARTNER_WBS_ELEMENT_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_PROJECT_DETAILS
 * TO_PARTNER_PROJECT_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_SALES_DOCUMENT_DETAILS
 * TO_PARTNER_SALES_DOCUMENT_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_BUSINESS_PROCESS_DETAILS
 * TO_PARTNER_BUSINESS_PROCESS_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_FINANCIAL_MANAGEMENT_AREA_DETAILS
 * TO_FINANCIAL_MANAGEMENT_AREA_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_FUND_DETAILS
 * TO_FUND_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_GRANT_ID_DETAILS
 * TO_GRANT_ID_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_BUDGET_PERIOD_DETAILS
 * TO_BUDGET_PERIOD_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_FUND_DETAILS
 * TO_PARTNER_FUND_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_GRANT_DETAILS
 * TO_PARTNER_GRANT_DETAILS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult#TO_PARTNER_BUDGET_PERIOD_DETAILS
 * TO_PARTNER_BUDGET_PERIOD_DETAILS}</li>
 * </ul>
 *
 */
public interface TRIALBALANCEResultSelectable extends EntitySelectable<TRIALBALANCEResult>
{

}
