/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID WBSElementExternalID}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.WBSElementExternalIDField
 * WBSElementExternalIDField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.WBSElementExternalIDLink
 * WBSElementExternalIDLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID#WBS_ELEMENT_EXTERNAL_IDID
 * WBS_ELEMENT_EXTERNAL_IDID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID#WBS_ELEMENT_EXTERNAL_ID_TEXT
 * WBS_ELEMENT_EXTERNAL_ID_TEXT}</li>
 * </ul>
 *
 */
public interface WBSElementExternalIDSelectable extends EntitySelectable<WBSElementExternalID>
{

}
