/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.field.WarehouseField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.link.WarehouseLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.selectable.WarehouseSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WarehouseType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Warehouse extends VdmEntity<Warehouse>
{

    /**
     * Selector for all available fields of Warehouse.
     *
     */
    public final static WarehouseSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WarehouseField<String> WAREHOUSE = new WarehouseField<String>("Warehouse");
    /**
     * Navigation property <b>to_WarehouseStorageType</b> for <b>Warehouse</b> to multiple <b>WarehouseStorageType</b>.
     *
     */
    @SerializedName( "to_WarehouseStorageType" )
    @JsonProperty( "to_WarehouseStorageType" )
    @ODataField( odataName = "to_WarehouseStorageType" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WarehouseStorageType> toWarehouseStorageType;
    /**
     * Navigation property <b>to_WarehouseText</b> for <b>Warehouse</b> to multiple <b>WarehouseText</b>.
     *
     */
    @SerializedName( "to_WarehouseText" )
    @JsonProperty( "to_WarehouseText" )
    @ODataField( odataName = "to_WarehouseText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WarehouseText> toWarehouseText;
    /**
     * Use with available fluent helpers to apply the <b>to_WarehouseStorageType</b> navigation property to query
     * operations.
     *
     */
    public final static WarehouseLink<WarehouseStorageType> TO_WAREHOUSE_STORAGE_TYPE =
        new WarehouseLink<WarehouseStorageType>("to_WarehouseStorageType");
    /**
     * Use with available fluent helpers to apply the <b>to_WarehouseText</b> navigation property to query operations.
     *
     */
    public final static WarehouseLink<WarehouseText> TO_WAREHOUSE_TEXT =
        new WarehouseLink<WarehouseText>("to_WarehouseText");

    @Nonnull
    @Override
    public Class<Warehouse> getType()
    {
        return Warehouse.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Warehouse";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Warehouse", getWarehouse());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Warehouse", getWarehouse());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WarehouseStorageType") ) {
                final Object value = (values).remove("to_WarehouseStorageType");
                if( value instanceof Iterable ) {
                    if( toWarehouseStorageType == null ) {
                        toWarehouseStorageType = Lists.newArrayList();
                    } else {
                        toWarehouseStorageType = Lists.newArrayList(toWarehouseStorageType);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WarehouseStorageType entity;
                        if( toWarehouseStorageType.size() > i ) {
                            entity = toWarehouseStorageType.get(i);
                        } else {
                            entity = new WarehouseStorageType();
                            toWarehouseStorageType.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WarehouseText") ) {
                final Object value = (values).remove("to_WarehouseText");
                if( value instanceof Iterable ) {
                    if( toWarehouseText == null ) {
                        toWarehouseText = Lists.newArrayList();
                    } else {
                        toWarehouseText = Lists.newArrayList(toWarehouseText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WarehouseText entity;
                        if( toWarehouseText.size() > i ) {
                            entity = toWarehouseText.get(i);
                        } else {
                            entity = new WarehouseText();
                            toWarehouseText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WarehouseField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WarehouseField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WarehouseField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WarehouseField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWarehouseStorageType != null ) {
            (values).put("to_WarehouseStorageType", toWarehouseStorageType);
        }
        if( toWarehouseText != null ) {
            (values).put("to_WarehouseText", toWarehouseText);
        }
        return values;
    }

    /**
     * Fetches the <b>WarehouseStorageType</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WarehouseStorageType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WarehouseStorageType</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseStorageType> fetchWarehouseStorageType()
    {
        return fetchFieldAsList("to_WarehouseStorageType", WarehouseStorageType.class);
    }

    /**
     * Retrieval of associated <b>WarehouseStorageType</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WarehouseStorageType</b>.
     * <p>
     * If the navigation property <b>to_WarehouseStorageType</b> of a queried <b>Warehouse</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WarehouseStorageType</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseStorageType> getWarehouseStorageTypeOrFetch()
    {
        if( toWarehouseStorageType == null ) {
            toWarehouseStorageType = fetchWarehouseStorageType();
        }
        return toWarehouseStorageType;
    }

    /**
     * Retrieval of associated <b>WarehouseStorageType</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WarehouseStorageType</b>.
     * <p>
     * If the navigation property for an entity <b>Warehouse</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WarehouseStorageType</b> is already loaded, the result
     *         will contain the <b>WarehouseStorageType</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WarehouseStorageType>> getWarehouseStorageTypeIfPresent()
    {
        return Option.of(toWarehouseStorageType);
    }

    /**
     * Overwrites the list of associated <b>WarehouseStorageType</b> entities for the loaded navigation property
     * <b>to_WarehouseStorageType</b>.
     * <p>
     * If the navigation property <b>to_WarehouseStorageType</b> of a queried <b>Warehouse</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WarehouseStorageType</b> entities.
     */
    public void setWarehouseStorageType( @Nonnull final List<WarehouseStorageType> value )
    {
        if( toWarehouseStorageType == null ) {
            toWarehouseStorageType = Lists.newArrayList();
        }
        toWarehouseStorageType.clear();
        toWarehouseStorageType.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WarehouseStorageType</b> entities. This corresponds to the OData
     * navigation property <b>to_WarehouseStorageType</b>.
     * <p>
     * If the navigation property <b>to_WarehouseStorageType</b> of a queried <b>Warehouse</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WarehouseStorageType</b> entities.
     */
    public void addWarehouseStorageType( WarehouseStorageType... entity )
    {
        if( toWarehouseStorageType == null ) {
            toWarehouseStorageType = Lists.newArrayList();
        }
        toWarehouseStorageType.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WarehouseText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_WarehouseText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WarehouseText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseText> fetchWarehouseText()
    {
        return fetchFieldAsList("to_WarehouseText", WarehouseText.class);
    }

    /**
     * Retrieval of associated <b>WarehouseText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_WarehouseText</b>.
     * <p>
     * If the navigation property <b>to_WarehouseText</b> of a queried <b>Warehouse</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WarehouseText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseText> getWarehouseTextOrFetch()
    {
        if( toWarehouseText == null ) {
            toWarehouseText = fetchWarehouseText();
        }
        return toWarehouseText;
    }

    /**
     * Retrieval of associated <b>WarehouseText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_WarehouseText</b>.
     * <p>
     * If the navigation property for an entity <b>Warehouse</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WarehouseText</b> is already loaded, the result will
     *         contain the <b>WarehouseText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WarehouseText>> getWarehouseTextIfPresent()
    {
        return Option.of(toWarehouseText);
    }

    /**
     * Overwrites the list of associated <b>WarehouseText</b> entities for the loaded navigation property
     * <b>to_WarehouseText</b>.
     * <p>
     * If the navigation property <b>to_WarehouseText</b> of a queried <b>Warehouse</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WarehouseText</b> entities.
     */
    public void setWarehouseText( @Nonnull final List<WarehouseText> value )
    {
        if( toWarehouseText == null ) {
            toWarehouseText = Lists.newArrayList();
        }
        toWarehouseText.clear();
        toWarehouseText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WarehouseText</b> entities. This corresponds to the OData navigation
     * property <b>to_WarehouseText</b>.
     * <p>
     * If the navigation property <b>to_WarehouseText</b> of a queried <b>Warehouse</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WarehouseText</b> entities.
     */
    public void addWarehouseText( WarehouseText... entity )
    {
        if( toWarehouseText == null ) {
            toWarehouseText = Lists.newArrayList();
        }
        toWarehouseText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Warehouse instances.
     *
     */
    public final static class WarehouseBuilder
    {

        private List<WarehouseStorageType> toWarehouseStorageType = Lists.newArrayList();
        private List<WarehouseText> toWarehouseText = Lists.newArrayList();

        private Warehouse.WarehouseBuilder toWarehouseStorageType( final List<WarehouseStorageType> value )
        {
            toWarehouseStorageType.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WarehouseStorageType</b> for <b>Warehouse</b> to multiple
         * <b>WarehouseStorageType</b>.
         *
         * @param value
         *            The WarehouseStorageTypes to build this Warehouse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Warehouse.WarehouseBuilder warehouseStorageType( WarehouseStorageType... value )
        {
            return toWarehouseStorageType(Lists.newArrayList(value));
        }

        private Warehouse.WarehouseBuilder toWarehouseText( final List<WarehouseText> value )
        {
            toWarehouseText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WarehouseText</b> for <b>Warehouse</b> to multiple <b>WarehouseText</b>.
         *
         * @param value
         *            The WarehouseTexts to build this Warehouse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Warehouse.WarehouseBuilder warehouseText( WarehouseText... value )
        {
            return toWarehouseText(Lists.newArrayList(value));
        }

    }

}
