/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.field.WarehouseStorageTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.link.WarehouseStorageTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.selectable.WarehouseStorageTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Storage Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WarehouseStorageTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WarehouseStorageType extends VdmEntity<WarehouseStorageType>
{

    /**
     * Selector for all available fields of WarehouseStorageType.
     *
     */
    public final static WarehouseStorageTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WarehouseStorageTypeField<String> WAREHOUSE =
        new WarehouseStorageTypeField<String>("Warehouse");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @Key
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static WarehouseStorageTypeField<String> STORAGE_TYPE =
        new WarehouseStorageTypeField<String>("StorageType");
    /**
     * Navigation property <b>to_WarehouseStorageTypeText</b> for <b>WarehouseStorageType</b> to multiple
     * <b>WarehouseStorageTypeText</b>.
     *
     */
    @SerializedName( "to_WarehouseStorageTypeText" )
    @JsonProperty( "to_WarehouseStorageTypeText" )
    @ODataField( odataName = "to_WarehouseStorageTypeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WarehouseStorageTypeText> toWarehouseStorageTypeText;
    /**
     * Use with available fluent helpers to apply the <b>to_WarehouseStorageTypeText</b> navigation property to query
     * operations.
     *
     */
    public final static WarehouseStorageTypeLink<WarehouseStorageTypeText> TO_WAREHOUSE_STORAGE_TYPE_TEXT =
        new WarehouseStorageTypeLink<WarehouseStorageTypeText>("to_WarehouseStorageTypeText");

    @Nonnull
    @Override
    public Class<WarehouseStorageType> getType()
    {
        return WarehouseStorageType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WarehouseStorageType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Warehouse", getWarehouse());
        result.put("StorageType", getStorageType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Warehouse", getWarehouse());
        values.put("StorageType", getStorageType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WarehouseStorageTypeText") ) {
                final Object value = (values).remove("to_WarehouseStorageTypeText");
                if( value instanceof Iterable ) {
                    if( toWarehouseStorageTypeText == null ) {
                        toWarehouseStorageTypeText = Lists.newArrayList();
                    } else {
                        toWarehouseStorageTypeText = Lists.newArrayList(toWarehouseStorageTypeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WarehouseStorageTypeText entity;
                        if( toWarehouseStorageTypeText.size() > i ) {
                            entity = toWarehouseStorageTypeText.get(i);
                        } else {
                            entity = new WarehouseStorageTypeText();
                            toWarehouseStorageTypeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WarehouseStorageTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WarehouseStorageTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WarehouseStorageTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WarehouseStorageTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWarehouseStorageTypeText != null ) {
            (values).put("to_WarehouseStorageTypeText", toWarehouseStorageTypeText);
        }
        return values;
    }

    /**
     * Fetches the <b>WarehouseStorageTypeText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_WarehouseStorageTypeText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WarehouseStorageTypeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseStorageTypeText> fetchWarehouseStorageTypeText()
    {
        return fetchFieldAsList("to_WarehouseStorageTypeText", WarehouseStorageTypeText.class);
    }

    /**
     * Retrieval of associated <b>WarehouseStorageTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WarehouseStorageTypeText</b>.
     * <p>
     * If the navigation property <b>to_WarehouseStorageTypeText</b> of a queried <b>WarehouseStorageType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WarehouseStorageTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseStorageTypeText> getWarehouseStorageTypeTextOrFetch()
    {
        if( toWarehouseStorageTypeText == null ) {
            toWarehouseStorageTypeText = fetchWarehouseStorageTypeText();
        }
        return toWarehouseStorageTypeText;
    }

    /**
     * Retrieval of associated <b>WarehouseStorageTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WarehouseStorageTypeText</b>.
     * <p>
     * If the navigation property for an entity <b>WarehouseStorageType</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WarehouseStorageTypeText</b> is already loaded, the
     *         result will contain the <b>WarehouseStorageTypeText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WarehouseStorageTypeText>> getWarehouseStorageTypeTextIfPresent()
    {
        return Option.of(toWarehouseStorageTypeText);
    }

    /**
     * Overwrites the list of associated <b>WarehouseStorageTypeText</b> entities for the loaded navigation property
     * <b>to_WarehouseStorageTypeText</b>.
     * <p>
     * If the navigation property <b>to_WarehouseStorageTypeText</b> of a queried <b>WarehouseStorageType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WarehouseStorageTypeText</b> entities.
     */
    public void setWarehouseStorageTypeText( @Nonnull final List<WarehouseStorageTypeText> value )
    {
        if( toWarehouseStorageTypeText == null ) {
            toWarehouseStorageTypeText = Lists.newArrayList();
        }
        toWarehouseStorageTypeText.clear();
        toWarehouseStorageTypeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WarehouseStorageTypeText</b> entities. This corresponds to the OData
     * navigation property <b>to_WarehouseStorageTypeText</b>.
     * <p>
     * If the navigation property <b>to_WarehouseStorageTypeText</b> of a queried <b>WarehouseStorageType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WarehouseStorageTypeText</b> entities.
     */
    public void addWarehouseStorageTypeText( WarehouseStorageTypeText... entity )
    {
        if( toWarehouseStorageTypeText == null ) {
            toWarehouseStorageTypeText = Lists.newArrayList();
        }
        toWarehouseStorageTypeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WarehouseStorageType instances.
     *
     */
    public final static class WarehouseStorageTypeBuilder
    {

        private List<WarehouseStorageTypeText> toWarehouseStorageTypeText = Lists.newArrayList();

        private WarehouseStorageType.WarehouseStorageTypeBuilder toWarehouseStorageTypeText(
            final List<WarehouseStorageTypeText> value )
        {
            toWarehouseStorageTypeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WarehouseStorageTypeText</b> for <b>WarehouseStorageType</b> to multiple
         * <b>WarehouseStorageTypeText</b>.
         *
         * @param value
         *            The WarehouseStorageTypeTexts to build this WarehouseStorageType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseStorageType.WarehouseStorageTypeBuilder warehouseStorageTypeText(
            WarehouseStorageTypeText... value )
        {
            return toWarehouseStorageTypeText(Lists.newArrayList(value));
        }

    }

}
