/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WarehouseServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService WarehouseService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWarehouseServiceBatch
    extends
    BatchFluentHelperBasic<WarehouseServiceBatch, WarehouseServiceBatchChangeSet>
    implements
    WarehouseServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWarehouseServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWarehouseServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWarehouseServiceBatchChangeSet(this, service);
    }

}
