/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link WarehouseServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService WarehouseService}.
 *
 */
public class DefaultWarehouseServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WarehouseServiceBatch, WarehouseServiceBatchChangeSet>
    implements
    WarehouseServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService service;

    @SuppressWarnings( "deprecation" )
    DefaultWarehouseServiceBatchChangeSet(
        @Nonnull final DefaultWarehouseServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseServiceBatchChangeSet getThis()
    {
        return this;
    }

}
