/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse Warehouse}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.field.WarehouseField WarehouseField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.link.WarehouseLink WarehouseLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse#WAREHOUSE WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse#TO_WAREHOUSE_STORAGE_TYPE
 * TO_WAREHOUSE_STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse#TO_WAREHOUSE_TEXT
 * TO_WAREHOUSE_TEXT}</li>
 * </ul>
 *
 */
public interface WarehouseSelectable extends EntitySelectable<Warehouse>
{

}
