/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType WarehouseStorageType}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.field.WarehouseStorageTypeField
 * WarehouseStorageTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.link.WarehouseStorageTypeLink
 * WarehouseStorageTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType#TO_WAREHOUSE_STORAGE_TYPE_TEXT
 * TO_WAREHOUSE_STORAGE_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface WarehouseStorageTypeSelectable extends EntitySelectable<WarehouseStorageType>
{

}
