/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText WarehouseText}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.field.WarehouseTextField
 * WarehouseTextField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.link.WarehouseTextLink
 * WarehouseTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText#WAREHOUSE WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText#WAREHOUSE_NAME
 * WAREHOUSE_NAME}</li>
 * </ul>
 *
 */
public interface WarehouseTextSelectable extends EntitySelectable<WarehouseText>
{

}
