/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.field.WhseInbDelivItemSerialNumberField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.link.WhseInbDelivItemSerialNumberOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.selectable.WhseInbDelivItemSerialNumberSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Whse Inb Delivery Item Serial Number
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhseInbDelivItemSerialNumberType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhseInbDelivItemSerialNumber extends VdmEntity<WhseInbDelivItemSerialNumber>
{

    /**
     * Selector for all available fields of WhseInbDelivItemSerialNumber.
     *
     */
    public final static WhseInbDelivItemSerialNumberSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InboundDelivery</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "InboundDelivery" )
    @JsonProperty( "InboundDelivery" )
    @Nullable
    @ODataField( odataName = "InboundDelivery" )
    private String inboundDelivery;
    /**
     * Use with available fluent helpers to apply the <b>InboundDelivery</b> field to query operations.
     *
     */
    public final static WhseInbDelivItemSerialNumberField<String> INBOUND_DELIVERY =
        new WhseInbDelivItemSerialNumberField<String>("InboundDelivery");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InboundDeliveryItem</b>
     * </p>
     *
     * @return Item Number
     */
    @Key
    @SerializedName( "InboundDeliveryItem" )
    @JsonProperty( "InboundDeliveryItem" )
    @Nullable
    @ODataField( odataName = "InboundDeliveryItem" )
    private String inboundDeliveryItem;
    /**
     * Use with available fluent helpers to apply the <b>InboundDeliveryItem</b> field to query operations.
     *
     */
    public final static WhseInbDelivItemSerialNumberField<String> INBOUND_DELIVERY_ITEM =
        new WhseInbDelivItemSerialNumberField<String>("InboundDeliveryItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>EWMSerialNumber</b>
     * </p>
     *
     * @return The eWMSerialNumber contained in this entity.
     */
    @Key
    @SerializedName( "EWMSerialNumber" )
    @JsonProperty( "EWMSerialNumber" )
    @Nullable
    @ODataField( odataName = "EWMSerialNumber" )
    private String eWMSerialNumber;
    /**
     * Use with available fluent helpers to apply the <b>EWMSerialNumber</b> field to query operations.
     *
     */
    public final static WhseInbDelivItemSerialNumberField<String> EWM_SERIAL_NUMBER =
        new WhseInbDelivItemSerialNumberField<String>("EWMSerialNumber");
    /**
     * Navigation property <b>to_WhseInboundDeliveryItem</b> for <b>WhseInbDelivItemSerialNumber</b> to single
     * <b>WhseInboundDeliveryItem</b>.
     *
     */
    @SerializedName( "to_WhseInboundDeliveryItem" )
    @JsonProperty( "to_WhseInboundDeliveryItem" )
    @ODataField( odataName = "to_WhseInboundDeliveryItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhseInboundDeliveryItem toWhseInboundDeliveryItem;
    /**
     * Use with available fluent helpers to apply the <b>to_WhseInboundDeliveryItem</b> navigation property to query
     * operations.
     *
     */
    public final static WhseInbDelivItemSerialNumberOneToOneLink<WhseInboundDeliveryItem> TO_WHSE_INBOUND_DELIVERY_ITEM =
        new WhseInbDelivItemSerialNumberOneToOneLink<WhseInboundDeliveryItem>("to_WhseInboundDeliveryItem");

    @Nonnull
    @Override
    public Class<WhseInbDelivItemSerialNumber> getType()
    {
        return WhseInbDelivItemSerialNumber.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InboundDelivery</b>
     * </p>
     *
     * @param inboundDelivery
     *            Document Number
     */
    public void setInboundDelivery( @Nullable final String inboundDelivery )
    {
        rememberChangedField("InboundDelivery", this.inboundDelivery);
        this.inboundDelivery = inboundDelivery;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InboundDeliveryItem</b>
     * </p>
     *
     * @param inboundDeliveryItem
     *            Item Number
     */
    public void setInboundDeliveryItem( @Nullable final String inboundDeliveryItem )
    {
        rememberChangedField("InboundDeliveryItem", this.inboundDeliveryItem);
        this.inboundDeliveryItem = inboundDeliveryItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>EWMSerialNumber</b>
     * </p>
     *
     * @param eWMSerialNumber
     *            The eWMSerialNumber to set.
     */
    public void setEWMSerialNumber( @Nullable final String eWMSerialNumber )
    {
        rememberChangedField("EWMSerialNumber", this.eWMSerialNumber);
        this.eWMSerialNumber = eWMSerialNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhseInbDelivItemSerialNumber";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InboundDelivery", getInboundDelivery());
        result.put("InboundDeliveryItem", getInboundDeliveryItem());
        result.put("EWMSerialNumber", getEWMSerialNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InboundDelivery", getInboundDelivery());
        values.put("InboundDeliveryItem", getInboundDeliveryItem());
        values.put("EWMSerialNumber", getEWMSerialNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InboundDelivery") ) {
                final Object value = values.remove("InboundDelivery");
                if( (value == null) || (!value.equals(getInboundDelivery())) ) {
                    setInboundDelivery(((String) value));
                }
            }
            if( values.containsKey("InboundDeliveryItem") ) {
                final Object value = values.remove("InboundDeliveryItem");
                if( (value == null) || (!value.equals(getInboundDeliveryItem())) ) {
                    setInboundDeliveryItem(((String) value));
                }
            }
            if( values.containsKey("EWMSerialNumber") ) {
                final Object value = values.remove("EWMSerialNumber");
                if( (value == null) || (!value.equals(getEWMSerialNumber())) ) {
                    setEWMSerialNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhseInboundDeliveryItem") ) {
                final Object value = (values).remove("to_WhseInboundDeliveryItem");
                if( value instanceof Map ) {
                    if( toWhseInboundDeliveryItem == null ) {
                        toWhseInboundDeliveryItem = new WhseInboundDeliveryItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWhseInboundDeliveryItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WhseInbDelivItemSerialNumberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WhseInbDelivItemSerialNumberField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhseInbDelivItemSerialNumberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhseInbDelivItemSerialNumberField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhseInboundDeliveryItem != null ) {
            (values).put("to_WhseInboundDeliveryItem", toWhseInboundDeliveryItem);
        }
        return values;
    }

    /**
     * Fetches the <b>WhseInboundDeliveryItem</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhseInboundDeliveryItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseInboundDeliveryItem fetchWhseInboundDeliveryItem()
    {
        return fetchFieldAsSingle("to_WhseInboundDeliveryItem", WhseInboundDeliveryItem.class);
    }

    /**
     * Retrieval of associated <b>WhseInboundDeliveryItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * If the navigation property <b>to_WhseInboundDeliveryItem</b> of a queried <b>WhseInbDelivItemSerialNumber</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseInboundDeliveryItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseInboundDeliveryItem getWhseInboundDeliveryItemOrFetch()
    {
        if( toWhseInboundDeliveryItem == null ) {
            toWhseInboundDeliveryItem = fetchWhseInboundDeliveryItem();
        }
        return toWhseInboundDeliveryItem;
    }

    /**
     * Retrieval of associated <b>WhseInboundDeliveryItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * If the navigation property for an entity <b>WhseInbDelivItemSerialNumber</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseInboundDeliveryItem</b> is already loaded, the
     *         result will contain the <b>WhseInboundDeliveryItem</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhseInboundDeliveryItem> getWhseInboundDeliveryItemIfPresent()
    {
        return Option.of(toWhseInboundDeliveryItem);
    }

    /**
     * Overwrites the associated <b>WhseInboundDeliveryItem</b> entity for the loaded navigation property
     * <b>to_WhseInboundDeliveryItem</b>.
     *
     * @param value
     *            New <b>WhseInboundDeliveryItem</b> entity.
     */
    public void setWhseInboundDeliveryItem( final WhseInboundDeliveryItem value )
    {
        toWhseInboundDeliveryItem = value;
    }

    /**
     * Helper class to allow for fluent creation of WhseInbDelivItemSerialNumber instances.
     *
     */
    public final static class WhseInbDelivItemSerialNumberBuilder
    {

        private WhseInboundDeliveryItem toWhseInboundDeliveryItem;

        private WhseInbDelivItemSerialNumber.WhseInbDelivItemSerialNumberBuilder toWhseInboundDeliveryItem(
            final WhseInboundDeliveryItem value )
        {
            toWhseInboundDeliveryItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_WhseInboundDeliveryItem</b> for <b>WhseInbDelivItemSerialNumber</b> to single
         * <b>WhseInboundDeliveryItem</b>.
         *
         * @param value
         *            The WhseInboundDeliveryItem to build this WhseInbDelivItemSerialNumber with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseInbDelivItemSerialNumber.WhseInbDelivItemSerialNumberBuilder whseInboundDeliveryItem(
            final WhseInboundDeliveryItem value )
        {
            return toWhseInboundDeliveryItem(value);
        }

    }

}
