/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.selectable.WhseInbDelivItemSerialNumberSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber
 * WhseInbDelivItemSerialNumber} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class WhseInbDelivItemSerialNumberByKeyFluentHelper
    extends
    FluentHelperByKey<WhseInbDelivItemSerialNumberByKeyFluentHelper, WhseInbDelivItemSerialNumber, WhseInbDelivItemSerialNumberSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber
     * WhseInbDelivItemSerialNumber} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WhseInbDelivItemSerialNumber}
     * @param inboundDelivery
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param inboundDeliveryItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WhseInbDelivItemSerialNumber}
     * @param eWMSerialNumber
     *
     */
    public WhseInbDelivItemSerialNumberByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inboundDelivery,
        final String inboundDeliveryItem,
        final String eWMSerialNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("InboundDelivery", inboundDelivery);
        this.key.put("InboundDeliveryItem", inboundDeliveryItem);
        this.key.put("EWMSerialNumber", eWMSerialNumber);
    }

    @Override
    @Nonnull
    protected Class<WhseInbDelivItemSerialNumber> getEntityClass()
    {
        return WhseInbDelivItemSerialNumber.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
