/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.field.WhseInboundDeliveryHeadField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.link.WhseInboundDeliveryHeadLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.selectable.WhseInboundDeliveryHeadSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Inbound Delivery Head
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhseInboundDeliveryHeadType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhseInboundDeliveryHead extends VdmEntity<WhseInboundDeliveryHead>
{

    /**
     * Selector for all available fields of WhseInboundDeliveryHead.
     *
     */
    public final static WhseInboundDeliveryHeadSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InboundDelivery</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "InboundDelivery" )
    @JsonProperty( "InboundDelivery" )
    @Nullable
    @ODataField( odataName = "InboundDelivery" )
    private String inboundDelivery;
    /**
     * Use with available fluent helpers to apply the <b>InboundDelivery</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> INBOUND_DELIVERY =
        new WhseInboundDeliveryHeadField<String>("InboundDelivery");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> WAREHOUSE =
        new WhseInboundDeliveryHeadField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @return Document Category
     */
    @SerializedName( "DeliveryCategory" )
    @JsonProperty( "DeliveryCategory" )
    @Nullable
    @ODataField( odataName = "DeliveryCategory" )
    private String deliveryCategory;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryCategory</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> DELIVERY_CATEGORY =
        new WhseInboundDeliveryHeadField<String>("DeliveryCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DeliveryType" )
    @JsonProperty( "DeliveryType" )
    @Nullable
    @ODataField( odataName = "DeliveryType" )
    private String deliveryType;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryType</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> DELIVERY_TYPE =
        new WhseInboundDeliveryHeadField<String>("DeliveryType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipFromParty</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "ShipFromParty" )
    @JsonProperty( "ShipFromParty" )
    @Nullable
    @ODataField( odataName = "ShipFromParty" )
    private String shipFromParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipFromParty</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> SHIP_FROM_PARTY =
        new WhseInboundDeliveryHeadField<String>("ShipFromParty");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ShipFromPartyName</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "ShipFromPartyName" )
    @JsonProperty( "ShipFromPartyName" )
    @Nullable
    @ODataField( odataName = "ShipFromPartyName" )
    private String shipFromPartyName;
    /**
     * Use with available fluent helpers to apply the <b>ShipFromPartyName</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> SHIP_FROM_PARTY_NAME =
        new WhseInboundDeliveryHeadField<String>("ShipFromPartyName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Carrier</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "Carrier" )
    @JsonProperty( "Carrier" )
    @Nullable
    @ODataField( odataName = "Carrier" )
    private String carrier;
    /**
     * Use with available fluent helpers to apply the <b>Carrier</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> CARRIER =
        new WhseInboundDeliveryHeadField<String>("Carrier");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CarrierName</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "CarrierName" )
    @JsonProperty( "CarrierName" )
    @Nullable
    @ODataField( odataName = "CarrierName" )
    private String carrierName;
    /**
     * Use with available fluent helpers to apply the <b>CarrierName</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> CARRIER_NAME =
        new WhseInboundDeliveryHeadField<String>("CarrierName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>AdvancedShippingNotification</b>
     * </p>
     *
     * @return Document Number
     */
    @SerializedName( "AdvancedShippingNotification" )
    @JsonProperty( "AdvancedShippingNotification" )
    @Nullable
    @ODataField( odataName = "AdvancedShippingNotification" )
    private String advancedShippingNotification;
    /**
     * Use with available fluent helpers to apply the <b>AdvancedShippingNotification</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> ADVANCED_SHIPPING_NOTIFICATION =
        new WhseInboundDeliveryHeadField<String>("AdvancedShippingNotification");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryUTCDateTime</b>
     * </p>
     *
     * @return Creation Date/Time
     */
    @SerializedName( "PlannedDeliveryUTCDateTime" )
    @JsonProperty( "PlannedDeliveryUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedDeliveryUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedDeliveryUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryUTCDateTime</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<ZonedDateTime> PLANNED_DELIVERY_UTC_DATE_TIME =
        new WhseInboundDeliveryHeadField<ZonedDateTime>("PlannedDeliveryUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingOffice</b>
     * </p>
     *
     * @return Location Number
     */
    @SerializedName( "ReceivingOffice" )
    @JsonProperty( "ReceivingOffice" )
    @Nullable
    @ODataField( odataName = "ReceivingOffice" )
    private String receivingOffice;
    /**
     * Use with available fluent helpers to apply the <b>ReceivingOffice</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<String> RECEIVING_OFFICE =
        new WhseInboundDeliveryHeadField<String>("ReceivingOffice");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryHeadField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new WhseInboundDeliveryHeadField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_WhseInboundDeliveryItem</b> for <b>WhseInboundDeliveryHead</b> to multiple
     * <b>WhseInboundDeliveryItem</b>.
     *
     */
    @SerializedName( "to_WhseInboundDeliveryItem" )
    @JsonProperty( "to_WhseInboundDeliveryItem" )
    @ODataField( odataName = "to_WhseInboundDeliveryItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WhseInboundDeliveryItem> toWhseInboundDeliveryItem;
    /**
     * Use with available fluent helpers to apply the <b>to_WhseInboundDeliveryItem</b> navigation property to query
     * operations.
     *
     */
    public final static WhseInboundDeliveryHeadLink<WhseInboundDeliveryItem> TO_WHSE_INBOUND_DELIVERY_ITEM =
        new WhseInboundDeliveryHeadLink<WhseInboundDeliveryItem>("to_WhseInboundDeliveryItem");

    @Nonnull
    @Override
    public Class<WhseInboundDeliveryHead> getType()
    {
        return WhseInboundDeliveryHead.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InboundDelivery</b>
     * </p>
     *
     * @param inboundDelivery
     *            Document Number
     */
    public void setInboundDelivery( @Nullable final String inboundDelivery )
    {
        rememberChangedField("InboundDelivery", this.inboundDelivery);
        this.inboundDelivery = inboundDelivery;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @param deliveryCategory
     *            Document Category
     */
    public void setDeliveryCategory( @Nullable final String deliveryCategory )
    {
        rememberChangedField("DeliveryCategory", this.deliveryCategory);
        this.deliveryCategory = deliveryCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryType</b>
     * </p>
     *
     * @param deliveryType
     *            Document Type
     */
    public void setDeliveryType( @Nullable final String deliveryType )
    {
        rememberChangedField("DeliveryType", this.deliveryType);
        this.deliveryType = deliveryType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipFromParty</b>
     * </p>
     *
     * @param shipFromParty
     *            Business Partner Number
     */
    public void setShipFromParty( @Nullable final String shipFromParty )
    {
        rememberChangedField("ShipFromParty", this.shipFromParty);
        this.shipFromParty = shipFromParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ShipFromPartyName</b>
     * </p>
     *
     * @param shipFromPartyName
     *            Name 1 of organization
     */
    public void setShipFromPartyName( @Nullable final String shipFromPartyName )
    {
        rememberChangedField("ShipFromPartyName", this.shipFromPartyName);
        this.shipFromPartyName = shipFromPartyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Carrier</b>
     * </p>
     *
     * @param carrier
     *            Business Partner Number
     */
    public void setCarrier( @Nullable final String carrier )
    {
        rememberChangedField("Carrier", this.carrier);
        this.carrier = carrier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CarrierName</b>
     * </p>
     *
     * @param carrierName
     *            Name 1 of organization
     */
    public void setCarrierName( @Nullable final String carrierName )
    {
        rememberChangedField("CarrierName", this.carrierName);
        this.carrierName = carrierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>AdvancedShippingNotification</b>
     * </p>
     *
     * @param advancedShippingNotification
     *            Document Number
     */
    public void setAdvancedShippingNotification( @Nullable final String advancedShippingNotification )
    {
        rememberChangedField("AdvancedShippingNotification", this.advancedShippingNotification);
        this.advancedShippingNotification = advancedShippingNotification;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryUTCDateTime</b>
     * </p>
     *
     * @param plannedDeliveryUTCDateTime
     *            Creation Date/Time
     */
    public void setPlannedDeliveryUTCDateTime( @Nullable final ZonedDateTime plannedDeliveryUTCDateTime )
    {
        rememberChangedField("PlannedDeliveryUTCDateTime", this.plannedDeliveryUTCDateTime);
        this.plannedDeliveryUTCDateTime = plannedDeliveryUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingOffice</b>
     * </p>
     *
     * @param receivingOffice
     *            Location Number
     */
    public void setReceivingOffice( @Nullable final String receivingOffice )
    {
        rememberChangedField("ReceivingOffice", this.receivingOffice);
        this.receivingOffice = receivingOffice;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhseInboundDeliveryHead";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InboundDelivery", getInboundDelivery());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InboundDelivery", getInboundDelivery());
        values.put("Warehouse", getWarehouse());
        values.put("DeliveryCategory", getDeliveryCategory());
        values.put("DeliveryType", getDeliveryType());
        values.put("ShipFromParty", getShipFromParty());
        values.put("ShipFromPartyName", getShipFromPartyName());
        values.put("Carrier", getCarrier());
        values.put("CarrierName", getCarrierName());
        values.put("AdvancedShippingNotification", getAdvancedShippingNotification());
        values.put("PlannedDeliveryUTCDateTime", getPlannedDeliveryUTCDateTime());
        values.put("ReceivingOffice", getReceivingOffice());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InboundDelivery") ) {
                final Object value = values.remove("InboundDelivery");
                if( (value == null) || (!value.equals(getInboundDelivery())) ) {
                    setInboundDelivery(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("DeliveryCategory") ) {
                final Object value = values.remove("DeliveryCategory");
                if( (value == null) || (!value.equals(getDeliveryCategory())) ) {
                    setDeliveryCategory(((String) value));
                }
            }
            if( values.containsKey("DeliveryType") ) {
                final Object value = values.remove("DeliveryType");
                if( (value == null) || (!value.equals(getDeliveryType())) ) {
                    setDeliveryType(((String) value));
                }
            }
            if( values.containsKey("ShipFromParty") ) {
                final Object value = values.remove("ShipFromParty");
                if( (value == null) || (!value.equals(getShipFromParty())) ) {
                    setShipFromParty(((String) value));
                }
            }
            if( values.containsKey("ShipFromPartyName") ) {
                final Object value = values.remove("ShipFromPartyName");
                if( (value == null) || (!value.equals(getShipFromPartyName())) ) {
                    setShipFromPartyName(((String) value));
                }
            }
            if( values.containsKey("Carrier") ) {
                final Object value = values.remove("Carrier");
                if( (value == null) || (!value.equals(getCarrier())) ) {
                    setCarrier(((String) value));
                }
            }
            if( values.containsKey("CarrierName") ) {
                final Object value = values.remove("CarrierName");
                if( (value == null) || (!value.equals(getCarrierName())) ) {
                    setCarrierName(((String) value));
                }
            }
            if( values.containsKey("AdvancedShippingNotification") ) {
                final Object value = values.remove("AdvancedShippingNotification");
                if( (value == null) || (!value.equals(getAdvancedShippingNotification())) ) {
                    setAdvancedShippingNotification(((String) value));
                }
            }
            if( values.containsKey("PlannedDeliveryUTCDateTime") ) {
                final Object value = values.remove("PlannedDeliveryUTCDateTime");
                if( (value == null) || (!value.equals(getPlannedDeliveryUTCDateTime())) ) {
                    setPlannedDeliveryUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ReceivingOffice") ) {
                final Object value = values.remove("ReceivingOffice");
                if( (value == null) || (!value.equals(getReceivingOffice())) ) {
                    setReceivingOffice(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhseInboundDeliveryItem") ) {
                final Object value = (values).remove("to_WhseInboundDeliveryItem");
                if( value instanceof Iterable ) {
                    if( toWhseInboundDeliveryItem == null ) {
                        toWhseInboundDeliveryItem = Lists.newArrayList();
                    } else {
                        toWhseInboundDeliveryItem = Lists.newArrayList(toWhseInboundDeliveryItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WhseInboundDeliveryItem entity;
                        if( toWhseInboundDeliveryItem.size() > i ) {
                            entity = toWhseInboundDeliveryItem.get(i);
                        } else {
                            entity = new WhseInboundDeliveryItem();
                            toWhseInboundDeliveryItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WhseInboundDeliveryHeadField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WhseInboundDeliveryHeadField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhseInboundDeliveryHeadField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhseInboundDeliveryHeadField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhseInboundDeliveryItem != null ) {
            (values).put("to_WhseInboundDeliveryItem", toWhseInboundDeliveryItem);
        }
        return values;
    }

    /**
     * Fetches the <b>WhseInboundDeliveryItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WhseInboundDeliveryItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseInboundDeliveryItem> fetchWhseInboundDeliveryItem()
    {
        return fetchFieldAsList("to_WhseInboundDeliveryItem", WhseInboundDeliveryItem.class);
    }

    /**
     * Retrieval of associated <b>WhseInboundDeliveryItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * If the navigation property <b>to_WhseInboundDeliveryItem</b> of a queried <b>WhseInboundDeliveryHead</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseInboundDeliveryItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseInboundDeliveryItem> getWhseInboundDeliveryItemOrFetch()
    {
        if( toWhseInboundDeliveryItem == null ) {
            toWhseInboundDeliveryItem = fetchWhseInboundDeliveryItem();
        }
        return toWhseInboundDeliveryItem;
    }

    /**
     * Retrieval of associated <b>WhseInboundDeliveryItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * If the navigation property for an entity <b>WhseInboundDeliveryHead</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseInboundDeliveryItem</b> is already loaded, the
     *         result will contain the <b>WhseInboundDeliveryItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WhseInboundDeliveryItem>> getWhseInboundDeliveryItemIfPresent()
    {
        return Option.of(toWhseInboundDeliveryItem);
    }

    /**
     * Overwrites the list of associated <b>WhseInboundDeliveryItem</b> entities for the loaded navigation property
     * <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * If the navigation property <b>to_WhseInboundDeliveryItem</b> of a queried <b>WhseInboundDeliveryHead</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WhseInboundDeliveryItem</b> entities.
     */
    public void setWhseInboundDeliveryItem( @Nonnull final List<WhseInboundDeliveryItem> value )
    {
        if( toWhseInboundDeliveryItem == null ) {
            toWhseInboundDeliveryItem = Lists.newArrayList();
        }
        toWhseInboundDeliveryItem.clear();
        toWhseInboundDeliveryItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WhseInboundDeliveryItem</b> entities. This corresponds to the OData
     * navigation property <b>to_WhseInboundDeliveryItem</b>.
     * <p>
     * If the navigation property <b>to_WhseInboundDeliveryItem</b> of a queried <b>WhseInboundDeliveryHead</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WhseInboundDeliveryItem</b> entities.
     */
    public void addWhseInboundDeliveryItem( WhseInboundDeliveryItem... entity )
    {
        if( toWhseInboundDeliveryItem == null ) {
            toWhseInboundDeliveryItem = Lists.newArrayList();
        }
        toWhseInboundDeliveryItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WhseInboundDeliveryHead instances.
     *
     */
    public final static class WhseInboundDeliveryHeadBuilder
    {

        private List<WhseInboundDeliveryItem> toWhseInboundDeliveryItem = Lists.newArrayList();

        private WhseInboundDeliveryHead.WhseInboundDeliveryHeadBuilder toWhseInboundDeliveryItem(
            final List<WhseInboundDeliveryItem> value )
        {
            toWhseInboundDeliveryItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WhseInboundDeliveryItem</b> for <b>WhseInboundDeliveryHead</b> to multiple
         * <b>WhseInboundDeliveryItem</b>.
         *
         * @param value
         *            The WhseInboundDeliveryItems to build this WhseInboundDeliveryHead with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseInboundDeliveryHead.WhseInboundDeliveryHeadBuilder whseInboundDeliveryItem(
            WhseInboundDeliveryItem... value )
        {
            return toWhseInboundDeliveryItem(Lists.newArrayList(value));
        }

    }

}
