/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.field.WhseInboundDeliveryItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.link.WhseInboundDeliveryItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.link.WhseInboundDeliveryItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.selectable.WhseInboundDeliveryItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Inbound Delivery Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhseInboundDeliveryItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhseInboundDeliveryItem extends VdmEntity<WhseInboundDeliveryItem>
{

    /**
     * Selector for all available fields of WhseInboundDeliveryItem.
     *
     */
    public final static WhseInboundDeliveryItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InboundDelivery</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "InboundDelivery" )
    @JsonProperty( "InboundDelivery" )
    @Nullable
    @ODataField( odataName = "InboundDelivery" )
    private String inboundDelivery;
    /**
     * Use with available fluent helpers to apply the <b>InboundDelivery</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> INBOUND_DELIVERY =
        new WhseInboundDeliveryItemField<String>("InboundDelivery");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InboundDeliveryItem</b>
     * </p>
     *
     * @return Item Number
     */
    @Key
    @SerializedName( "InboundDeliveryItem" )
    @JsonProperty( "InboundDeliveryItem" )
    @Nullable
    @ODataField( odataName = "InboundDeliveryItem" )
    private String inboundDeliveryItem;
    /**
     * Use with available fluent helpers to apply the <b>InboundDeliveryItem</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> INBOUND_DELIVERY_ITEM =
        new WhseInboundDeliveryItemField<String>("InboundDeliveryItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> WAREHOUSE =
        new WhseInboundDeliveryItemField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @return Document Category
     */
    @SerializedName( "DeliveryCategory" )
    @JsonProperty( "DeliveryCategory" )
    @Nullable
    @ODataField( odataName = "DeliveryCategory" )
    private String deliveryCategory;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryCategory</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> DELIVERY_CATEGORY =
        new WhseInboundDeliveryItemField<String>("DeliveryCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItemCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "DeliveryItemCategory" )
    @JsonProperty( "DeliveryItemCategory" )
    @Nullable
    @ODataField( odataName = "DeliveryItemCategory" )
    private String deliveryItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryItemCategory</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> DELIVERY_ITEM_CATEGORY =
        new WhseInboundDeliveryItemField<String>("DeliveryItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InboundDeliveryItemType</b>
     * </p>
     *
     * @return Item Type
     */
    @SerializedName( "InboundDeliveryItemType" )
    @JsonProperty( "InboundDeliveryItemType" )
    @Nullable
    @ODataField( odataName = "InboundDeliveryItemType" )
    private String inboundDeliveryItemType;
    /**
     * Use with available fluent helpers to apply the <b>InboundDeliveryItemType</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> INBOUND_DELIVERY_ITEM_TYPE =
        new WhseInboundDeliveryItemField<String>("InboundDeliveryItemType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Character field of length 40
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PRODUCT =
        new WhseInboundDeliveryItemField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductExternalID</b>
     * </p>
     *
     * @return Character field of length 40
     */
    @SerializedName( "ProductExternalID" )
    @JsonProperty( "ProductExternalID" )
    @Nullable
    @ODataField( odataName = "ProductExternalID" )
    private String productExternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProductExternalID</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PRODUCT_EXTERNAL_ID =
        new WhseInboundDeliveryItemField<String>("ProductExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "ProductBatch" )
    @JsonProperty( "ProductBatch" )
    @Nullable
    @ODataField( odataName = "ProductBatch" )
    private String productBatch;
    /**
     * Use with available fluent helpers to apply the <b>ProductBatch</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PRODUCT_BATCH =
        new WhseInboundDeliveryItemField<String>("ProductBatch");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @return Country/Region of Origin
     */
    @SerializedName( "CountryOfOrigin" )
    @JsonProperty( "CountryOfOrigin" )
    @Nullable
    @ODataField( odataName = "CountryOfOrigin" )
    private String countryOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CountryOfOrigin</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> COUNTRY_OF_ORIGIN =
        new WhseInboundDeliveryItemField<String>("CountryOfOrigin");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ProductQuantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "ProductQuantity" )
    @JsonProperty( "ProductQuantity" )
    @Nullable
    @ODataField( odataName = "ProductQuantity" )
    private BigDecimal productQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProductQuantity</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<BigDecimal> PRODUCT_QUANTITY =
        new WhseInboundDeliveryItemField<BigDecimal>("ProductQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> QUANTITY_UNIT =
        new WhseInboundDeliveryItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingAreaGroup</b>
     * </p>
     *
     * @return Staging Area Group
     */
    @SerializedName( "StagingAreaGroup" )
    @JsonProperty( "StagingAreaGroup" )
    @Nullable
    @ODataField( odataName = "StagingAreaGroup" )
    private String stagingAreaGroup;
    /**
     * Use with available fluent helpers to apply the <b>StagingAreaGroup</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STAGING_AREA_GROUP =
        new WhseInboundDeliveryItemField<String>("StagingAreaGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingArea</b>
     * </p>
     *
     * @return Staging Area
     */
    @SerializedName( "StagingArea" )
    @JsonProperty( "StagingArea" )
    @Nullable
    @ODataField( odataName = "StagingArea" )
    private String stagingArea;
    /**
     * Use with available fluent helpers to apply the <b>StagingArea</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STAGING_AREA =
        new WhseInboundDeliveryItemField<String>("StagingArea");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StagingBay</b>
     * </p>
     *
     * @return Staging Bay
     */
    @SerializedName( "StagingBay" )
    @JsonProperty( "StagingBay" )
    @Nullable
    @ODataField( odataName = "StagingBay" )
    private String stagingBay;
    /**
     * Use with available fluent helpers to apply the <b>StagingBay</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STAGING_BAY =
        new WhseInboundDeliveryItemField<String>("StagingBay");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "GoodsReceiptStatus" )
    @JsonProperty( "GoodsReceiptStatus" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptStatus" )
    private String goodsReceiptStatus;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptStatus</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> GOODS_RECEIPT_STATUS =
        new WhseInboundDeliveryItemField<String>("GoodsReceiptStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlanningPutawayStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "PlanningPutawayStatus" )
    @JsonProperty( "PlanningPutawayStatus" )
    @Nullable
    @ODataField( odataName = "PlanningPutawayStatus" )
    private String planningPutawayStatus;
    /**
     * Use with available fluent helpers to apply the <b>PlanningPutawayStatus</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PLANNING_PUTAWAY_STATUS =
        new WhseInboundDeliveryItemField<String>("PlanningPutawayStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PutawayStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "PutawayStatus" )
    @JsonProperty( "PutawayStatus" )
    @Nullable
    @ODataField( odataName = "PutawayStatus" )
    private String putawayStatus;
    /**
     * Use with available fluent helpers to apply the <b>PutawayStatus</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PUTAWAY_STATUS =
        new WhseInboundDeliveryItemField<String>("PutawayStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CompletionStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "CompletionStatus" )
    @JsonProperty( "CompletionStatus" )
    @Nullable
    @ODataField( odataName = "CompletionStatus" )
    private String completionStatus;
    /**
     * Use with available fluent helpers to apply the <b>CompletionStatus</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> COMPLETION_STATUS =
        new WhseInboundDeliveryItemField<String>("CompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @return Warehouse Process Type
     */
    @SerializedName( "WarehouseProcessType" )
    @JsonProperty( "WarehouseProcessType" )
    @Nullable
    @ODataField( odataName = "WarehouseProcessType" )
    private String warehouseProcessType;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseProcessType</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> WAREHOUSE_PROCESS_TYPE =
        new WhseInboundDeliveryItemField<String>("WarehouseProcessType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementBin</b>
     * </p>
     *
     * @return Storage Bin of Goods Movement Posting
     */
    @SerializedName( "GoodsMovementBin" )
    @JsonProperty( "GoodsMovementBin" )
    @Nullable
    @ODataField( odataName = "GoodsMovementBin" )
    private String goodsMovementBin;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementBin</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> GOODS_MOVEMENT_BIN =
        new WhseInboundDeliveryItemField<String>("GoodsMovementBin");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area (PSA)
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PRODUCTION_SUPPLY_AREA =
        new WhseInboundDeliveryItemField<String>("ProductionSupplyArea");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new WhseInboundDeliveryItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @return Party Entitled to Dispose
     */
    @SerializedName( "EntitledToDisposeParty" )
    @JsonProperty( "EntitledToDisposeParty" )
    @Nullable
    @ODataField( odataName = "EntitledToDisposeParty" )
    private String entitledToDisposeParty;
    /**
     * Use with available fluent helpers to apply the <b>EntitledToDisposeParty</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> ENTITLED_TO_DISPOSE_PARTY =
        new WhseInboundDeliveryItemField<String>("EntitledToDisposeParty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @return Stock Usage
     */
    @SerializedName( "StockUsage" )
    @JsonProperty( "StockUsage" )
    @Nullable
    @ODataField( odataName = "StockUsage" )
    private String stockUsage;
    /**
     * Use with available fluent helpers to apply the <b>StockUsage</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STOCK_USAGE =
        new WhseInboundDeliveryItemField<String>("StockUsage");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStockCategory</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "WarehouseStockCategory" )
    @JsonProperty( "WarehouseStockCategory" )
    @Nullable
    @ODataField( odataName = "WarehouseStockCategory" )
    private String warehouseStockCategory;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStockCategory</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> WAREHOUSE_STOCK_CATEGORY =
        new WhseInboundDeliveryItemField<String>("WarehouseStockCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @return Character Field with Length 10
     */
    @SerializedName( "StockOwner" )
    @JsonProperty( "StockOwner" )
    @Nullable
    @ODataField( odataName = "StockOwner" )
    private String stockOwner;
    /**
     * Use with available fluent helpers to apply the <b>StockOwner</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STOCK_OWNER =
        new WhseInboundDeliveryItemField<String>("StockOwner");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItemStockTypeDetnCode</b>
     * </p>
     *
     * @return Value Determination Indicator
     */
    @SerializedName( "DeliveryItemStockTypeDetnCode" )
    @JsonProperty( "DeliveryItemStockTypeDetnCode" )
    @Nullable
    @ODataField( odataName = "DeliveryItemStockTypeDetnCode" )
    private String deliveryItemStockTypeDetnCode;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryItemStockTypeDetnCode</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> DELIVERY_ITEM_STOCK_TYPE_DETN_CODE =
        new WhseInboundDeliveryItemField<String>("DeliveryItemStockTypeDetnCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @return Special Reference Stock Type
     */
    @SerializedName( "StockDocumentCategory" )
    @JsonProperty( "StockDocumentCategory" )
    @Nullable
    @ODataField( odataName = "StockDocumentCategory" )
    private String stockDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentCategory</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STOCK_DOCUMENT_CATEGORY =
        new WhseInboundDeliveryItemField<String>("StockDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @return Reference Document for Special Reference Stock
     */
    @SerializedName( "StockDocumentNumber" )
    @JsonProperty( "StockDocumentNumber" )
    @Nullable
    @ODataField( odataName = "StockDocumentNumber" )
    private String stockDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentNumber</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STOCK_DOCUMENT_NUMBER =
        new WhseInboundDeliveryItemField<String>("StockDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @return Sales Order Item for Sales Order Stock
     */
    @SerializedName( "StockItemNumber" )
    @JsonProperty( "StockItemNumber" )
    @Nullable
    @ODataField( odataName = "StockItemNumber" )
    private String stockItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockItemNumber</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> STOCK_ITEM_NUMBER =
        new WhseInboundDeliveryItemField<String>("StockItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> WBS_ELEMENT_INTERNAL_ID =
        new WhseInboundDeliveryItemField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new WhseInboundDeliveryItemField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @return The specialStockIdfgSalesOrder contained in this entity.
     */
    @SerializedName( "SpecialStockIdfgSalesOrder" )
    @JsonProperty( "SpecialStockIdfgSalesOrder" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrder" )
    private String specialStockIdfgSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrder</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> SPECIAL_STOCK_IDFG_SALES_ORDER =
        new WhseInboundDeliveryItemField<String>("SpecialStockIdfgSalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @return The specialStockIdfgSalesOrderItem contained in this entity.
     */
    @SerializedName( "SpecialStockIdfgSalesOrderItem" )
    @JsonProperty( "SpecialStockIdfgSalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrderItem" )
    private String specialStockIdfgSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrderItem</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM =
        new WhseInboundDeliveryItemField<String>("SpecialStockIdfgSalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PURCHASING_DOCUMENT =
        new WhseInboundDeliveryItemField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Reference Item Number
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> PURCHASING_DOCUMENT_ITEM =
        new WhseInboundDeliveryItemField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static WhseInboundDeliveryItemField<String> MANUFACTURING_ORDER =
        new WhseInboundDeliveryItemField<String>("ManufacturingOrder");
    /**
     * Navigation property <b>to_WhseInboundDeliveryHead</b> for <b>WhseInboundDeliveryItem</b> to single
     * <b>WhseInboundDeliveryHead</b>.
     *
     */
    @SerializedName( "to_WhseInboundDeliveryHead" )
    @JsonProperty( "to_WhseInboundDeliveryHead" )
    @ODataField( odataName = "to_WhseInboundDeliveryHead" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhseInboundDeliveryHead toWhseInboundDeliveryHead;
    /**
     * Navigation property <b>to_WhseInbDeliveryItemSerialNo</b> for <b>WhseInboundDeliveryItem</b> to multiple
     * <b>WhseInbDelivItemSerialNumber</b>.
     *
     */
    @SerializedName( "to_WhseInbDeliveryItemSerialNo" )
    @JsonProperty( "to_WhseInbDeliveryItemSerialNo" )
    @ODataField( odataName = "to_WhseInbDeliveryItemSerialNo" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WhseInbDelivItemSerialNumber> toWhseInbDeliveryItemSerialNo;
    /**
     * Use with available fluent helpers to apply the <b>to_WhseInboundDeliveryHead</b> navigation property to query
     * operations.
     *
     */
    public final static WhseInboundDeliveryItemOneToOneLink<WhseInboundDeliveryHead> TO_WHSE_INBOUND_DELIVERY_HEAD =
        new WhseInboundDeliveryItemOneToOneLink<WhseInboundDeliveryHead>("to_WhseInboundDeliveryHead");
    /**
     * Use with available fluent helpers to apply the <b>to_WhseInbDeliveryItemSerialNo</b> navigation property to query
     * operations.
     *
     */
    public final static WhseInboundDeliveryItemLink<WhseInbDelivItemSerialNumber> TO_WHSE_INB_DELIVERY_ITEM_SERIAL_NO =
        new WhseInboundDeliveryItemLink<WhseInbDelivItemSerialNumber>("to_WhseInbDeliveryItemSerialNo");

    @Nonnull
    @Override
    public Class<WhseInboundDeliveryItem> getType()
    {
        return WhseInboundDeliveryItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InboundDelivery</b>
     * </p>
     *
     * @param inboundDelivery
     *            Document Number
     */
    public void setInboundDelivery( @Nullable final String inboundDelivery )
    {
        rememberChangedField("InboundDelivery", this.inboundDelivery);
        this.inboundDelivery = inboundDelivery;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InboundDeliveryItem</b>
     * </p>
     *
     * @param inboundDeliveryItem
     *            Item Number
     */
    public void setInboundDeliveryItem( @Nullable final String inboundDeliveryItem )
    {
        rememberChangedField("InboundDeliveryItem", this.inboundDeliveryItem);
        this.inboundDeliveryItem = inboundDeliveryItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @param deliveryCategory
     *            Document Category
     */
    public void setDeliveryCategory( @Nullable final String deliveryCategory )
    {
        rememberChangedField("DeliveryCategory", this.deliveryCategory);
        this.deliveryCategory = deliveryCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItemCategory</b>
     * </p>
     *
     * @param deliveryItemCategory
     *            Item Category
     */
    public void setDeliveryItemCategory( @Nullable final String deliveryItemCategory )
    {
        rememberChangedField("DeliveryItemCategory", this.deliveryItemCategory);
        this.deliveryItemCategory = deliveryItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InboundDeliveryItemType</b>
     * </p>
     *
     * @param inboundDeliveryItemType
     *            Item Type
     */
    public void setInboundDeliveryItemType( @Nullable final String inboundDeliveryItemType )
    {
        rememberChangedField("InboundDeliveryItemType", this.inboundDeliveryItemType);
        this.inboundDeliveryItemType = inboundDeliveryItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Character field of length 40
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductExternalID</b>
     * </p>
     *
     * @param productExternalID
     *            Character field of length 40
     */
    public void setProductExternalID( @Nullable final String productExternalID )
    {
        rememberChangedField("ProductExternalID", this.productExternalID);
        this.productExternalID = productExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatch</b>
     * </p>
     *
     * @param productBatch
     *            Batch Number
     */
    public void setProductBatch( @Nullable final String productBatch )
    {
        rememberChangedField("ProductBatch", this.productBatch);
        this.productBatch = productBatch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @param countryOfOrigin
     *            Country/Region of Origin
     */
    public void setCountryOfOrigin( @Nullable final String countryOfOrigin )
    {
        rememberChangedField("CountryOfOrigin", this.countryOfOrigin);
        this.countryOfOrigin = countryOfOrigin;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ProductQuantity</b>
     * </p>
     *
     * @param productQuantity
     *            Quantity
     */
    public void setProductQuantity( @Nullable final BigDecimal productQuantity )
    {
        rememberChangedField("ProductQuantity", this.productQuantity);
        this.productQuantity = productQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Base Unit of Measure
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingAreaGroup</b>
     * </p>
     *
     * @param stagingAreaGroup
     *            Staging Area Group
     */
    public void setStagingAreaGroup( @Nullable final String stagingAreaGroup )
    {
        rememberChangedField("StagingAreaGroup", this.stagingAreaGroup);
        this.stagingAreaGroup = stagingAreaGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingArea</b>
     * </p>
     *
     * @param stagingArea
     *            Staging Area
     */
    public void setStagingArea( @Nullable final String stagingArea )
    {
        rememberChangedField("StagingArea", this.stagingArea);
        this.stagingArea = stagingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StagingBay</b>
     * </p>
     *
     * @param stagingBay
     *            Staging Bay
     */
    public void setStagingBay( @Nullable final String stagingBay )
    {
        rememberChangedField("StagingBay", this.stagingBay);
        this.stagingBay = stagingBay;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptStatus</b>
     * </p>
     *
     * @param goodsReceiptStatus
     *            Status Value
     */
    public void setGoodsReceiptStatus( @Nullable final String goodsReceiptStatus )
    {
        rememberChangedField("GoodsReceiptStatus", this.goodsReceiptStatus);
        this.goodsReceiptStatus = goodsReceiptStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlanningPutawayStatus</b>
     * </p>
     *
     * @param planningPutawayStatus
     *            Status Value
     */
    public void setPlanningPutawayStatus( @Nullable final String planningPutawayStatus )
    {
        rememberChangedField("PlanningPutawayStatus", this.planningPutawayStatus);
        this.planningPutawayStatus = planningPutawayStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PutawayStatus</b>
     * </p>
     *
     * @param putawayStatus
     *            Status Value
     */
    public void setPutawayStatus( @Nullable final String putawayStatus )
    {
        rememberChangedField("PutawayStatus", this.putawayStatus);
        this.putawayStatus = putawayStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CompletionStatus</b>
     * </p>
     *
     * @param completionStatus
     *            Status Value
     */
    public void setCompletionStatus( @Nullable final String completionStatus )
    {
        rememberChangedField("CompletionStatus", this.completionStatus);
        this.completionStatus = completionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @param warehouseProcessType
     *            Warehouse Process Type
     */
    public void setWarehouseProcessType( @Nullable final String warehouseProcessType )
    {
        rememberChangedField("WarehouseProcessType", this.warehouseProcessType);
        this.warehouseProcessType = warehouseProcessType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementBin</b>
     * </p>
     *
     * @param goodsMovementBin
     *            Storage Bin of Goods Movement Posting
     */
    public void setGoodsMovementBin( @Nullable final String goodsMovementBin )
    {
        rememberChangedField("GoodsMovementBin", this.goodsMovementBin);
        this.goodsMovementBin = goodsMovementBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area (PSA)
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @param entitledToDisposeParty
     *            Party Entitled to Dispose
     */
    public void setEntitledToDisposeParty( @Nullable final String entitledToDisposeParty )
    {
        rememberChangedField("EntitledToDisposeParty", this.entitledToDisposeParty);
        this.entitledToDisposeParty = entitledToDisposeParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @param stockUsage
     *            Stock Usage
     */
    public void setStockUsage( @Nullable final String stockUsage )
    {
        rememberChangedField("StockUsage", this.stockUsage);
        this.stockUsage = stockUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStockCategory</b>
     * </p>
     *
     * @param warehouseStockCategory
     *            Stock Type
     */
    public void setWarehouseStockCategory( @Nullable final String warehouseStockCategory )
    {
        rememberChangedField("WarehouseStockCategory", this.warehouseStockCategory);
        this.warehouseStockCategory = warehouseStockCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @param stockOwner
     *            Character Field with Length 10
     */
    public void setStockOwner( @Nullable final String stockOwner )
    {
        rememberChangedField("StockOwner", this.stockOwner);
        this.stockOwner = stockOwner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItemStockTypeDetnCode</b>
     * </p>
     *
     * @param deliveryItemStockTypeDetnCode
     *            Value Determination Indicator
     */
    public void setDeliveryItemStockTypeDetnCode( @Nullable final String deliveryItemStockTypeDetnCode )
    {
        rememberChangedField("DeliveryItemStockTypeDetnCode", this.deliveryItemStockTypeDetnCode);
        this.deliveryItemStockTypeDetnCode = deliveryItemStockTypeDetnCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @param stockDocumentCategory
     *            Special Reference Stock Type
     */
    public void setStockDocumentCategory( @Nullable final String stockDocumentCategory )
    {
        rememberChangedField("StockDocumentCategory", this.stockDocumentCategory);
        this.stockDocumentCategory = stockDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @param stockDocumentNumber
     *            Reference Document for Special Reference Stock
     */
    public void setStockDocumentNumber( @Nullable final String stockDocumentNumber )
    {
        rememberChangedField("StockDocumentNumber", this.stockDocumentNumber);
        this.stockDocumentNumber = stockDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @param stockItemNumber
     *            Sales Order Item for Sales Order Stock
     */
    public void setStockItemNumber( @Nullable final String stockItemNumber )
    {
        rememberChangedField("StockItemNumber", this.stockItemNumber);
        this.stockItemNumber = stockItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrder
     *            The specialStockIdfgSalesOrder to set.
     */
    public void setSpecialStockIdfgSalesOrder( @Nullable final String specialStockIdfgSalesOrder )
    {
        rememberChangedField("SpecialStockIdfgSalesOrder", this.specialStockIdfgSalesOrder);
        this.specialStockIdfgSalesOrder = specialStockIdfgSalesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrderItem
     *            The specialStockIdfgSalesOrderItem to set.
     */
    public void setSpecialStockIdfgSalesOrderItem( @Nullable final String specialStockIdfgSalesOrderItem )
    {
        rememberChangedField("SpecialStockIdfgSalesOrderItem", this.specialStockIdfgSalesOrderItem);
        this.specialStockIdfgSalesOrderItem = specialStockIdfgSalesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Reference Document Number
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Reference Item Number
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Reference Document Number
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhseInboundDeliveryItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InboundDelivery", getInboundDelivery());
        result.put("InboundDeliveryItem", getInboundDeliveryItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InboundDelivery", getInboundDelivery());
        values.put("InboundDeliveryItem", getInboundDeliveryItem());
        values.put("Warehouse", getWarehouse());
        values.put("DeliveryCategory", getDeliveryCategory());
        values.put("DeliveryItemCategory", getDeliveryItemCategory());
        values.put("InboundDeliveryItemType", getInboundDeliveryItemType());
        values.put("Product", getProduct());
        values.put("ProductExternalID", getProductExternalID());
        values.put("ProductBatch", getProductBatch());
        values.put("CountryOfOrigin", getCountryOfOrigin());
        values.put("ProductQuantity", getProductQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("StagingAreaGroup", getStagingAreaGroup());
        values.put("StagingArea", getStagingArea());
        values.put("StagingBay", getStagingBay());
        values.put("GoodsReceiptStatus", getGoodsReceiptStatus());
        values.put("PlanningPutawayStatus", getPlanningPutawayStatus());
        values.put("PutawayStatus", getPutawayStatus());
        values.put("CompletionStatus", getCompletionStatus());
        values.put("WarehouseProcessType", getWarehouseProcessType());
        values.put("GoodsMovementBin", getGoodsMovementBin());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("EntitledToDisposeParty", getEntitledToDisposeParty());
        values.put("StockUsage", getStockUsage());
        values.put("WarehouseStockCategory", getWarehouseStockCategory());
        values.put("StockOwner", getStockOwner());
        values.put("DeliveryItemStockTypeDetnCode", getDeliveryItemStockTypeDetnCode());
        values.put("StockDocumentCategory", getStockDocumentCategory());
        values.put("StockDocumentNumber", getStockDocumentNumber());
        values.put("StockItemNumber", getStockItemNumber());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("SpecialStockIdfgSalesOrder", getSpecialStockIdfgSalesOrder());
        values.put("SpecialStockIdfgSalesOrderItem", getSpecialStockIdfgSalesOrderItem());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("ManufacturingOrder", getManufacturingOrder());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InboundDelivery") ) {
                final Object value = values.remove("InboundDelivery");
                if( (value == null) || (!value.equals(getInboundDelivery())) ) {
                    setInboundDelivery(((String) value));
                }
            }
            if( values.containsKey("InboundDeliveryItem") ) {
                final Object value = values.remove("InboundDeliveryItem");
                if( (value == null) || (!value.equals(getInboundDeliveryItem())) ) {
                    setInboundDeliveryItem(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("DeliveryCategory") ) {
                final Object value = values.remove("DeliveryCategory");
                if( (value == null) || (!value.equals(getDeliveryCategory())) ) {
                    setDeliveryCategory(((String) value));
                }
            }
            if( values.containsKey("DeliveryItemCategory") ) {
                final Object value = values.remove("DeliveryItemCategory");
                if( (value == null) || (!value.equals(getDeliveryItemCategory())) ) {
                    setDeliveryItemCategory(((String) value));
                }
            }
            if( values.containsKey("InboundDeliveryItemType") ) {
                final Object value = values.remove("InboundDeliveryItemType");
                if( (value == null) || (!value.equals(getInboundDeliveryItemType())) ) {
                    setInboundDeliveryItemType(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ProductExternalID") ) {
                final Object value = values.remove("ProductExternalID");
                if( (value == null) || (!value.equals(getProductExternalID())) ) {
                    setProductExternalID(((String) value));
                }
            }
            if( values.containsKey("ProductBatch") ) {
                final Object value = values.remove("ProductBatch");
                if( (value == null) || (!value.equals(getProductBatch())) ) {
                    setProductBatch(((String) value));
                }
            }
            if( values.containsKey("CountryOfOrigin") ) {
                final Object value = values.remove("CountryOfOrigin");
                if( (value == null) || (!value.equals(getCountryOfOrigin())) ) {
                    setCountryOfOrigin(((String) value));
                }
            }
            if( values.containsKey("ProductQuantity") ) {
                final Object value = values.remove("ProductQuantity");
                if( (value == null) || (!value.equals(getProductQuantity())) ) {
                    setProductQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("StagingAreaGroup") ) {
                final Object value = values.remove("StagingAreaGroup");
                if( (value == null) || (!value.equals(getStagingAreaGroup())) ) {
                    setStagingAreaGroup(((String) value));
                }
            }
            if( values.containsKey("StagingArea") ) {
                final Object value = values.remove("StagingArea");
                if( (value == null) || (!value.equals(getStagingArea())) ) {
                    setStagingArea(((String) value));
                }
            }
            if( values.containsKey("StagingBay") ) {
                final Object value = values.remove("StagingBay");
                if( (value == null) || (!value.equals(getStagingBay())) ) {
                    setStagingBay(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptStatus") ) {
                final Object value = values.remove("GoodsReceiptStatus");
                if( (value == null) || (!value.equals(getGoodsReceiptStatus())) ) {
                    setGoodsReceiptStatus(((String) value));
                }
            }
            if( values.containsKey("PlanningPutawayStatus") ) {
                final Object value = values.remove("PlanningPutawayStatus");
                if( (value == null) || (!value.equals(getPlanningPutawayStatus())) ) {
                    setPlanningPutawayStatus(((String) value));
                }
            }
            if( values.containsKey("PutawayStatus") ) {
                final Object value = values.remove("PutawayStatus");
                if( (value == null) || (!value.equals(getPutawayStatus())) ) {
                    setPutawayStatus(((String) value));
                }
            }
            if( values.containsKey("CompletionStatus") ) {
                final Object value = values.remove("CompletionStatus");
                if( (value == null) || (!value.equals(getCompletionStatus())) ) {
                    setCompletionStatus(((String) value));
                }
            }
            if( values.containsKey("WarehouseProcessType") ) {
                final Object value = values.remove("WarehouseProcessType");
                if( (value == null) || (!value.equals(getWarehouseProcessType())) ) {
                    setWarehouseProcessType(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementBin") ) {
                final Object value = values.remove("GoodsMovementBin");
                if( (value == null) || (!value.equals(getGoodsMovementBin())) ) {
                    setGoodsMovementBin(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("EntitledToDisposeParty") ) {
                final Object value = values.remove("EntitledToDisposeParty");
                if( (value == null) || (!value.equals(getEntitledToDisposeParty())) ) {
                    setEntitledToDisposeParty(((String) value));
                }
            }
            if( values.containsKey("StockUsage") ) {
                final Object value = values.remove("StockUsage");
                if( (value == null) || (!value.equals(getStockUsage())) ) {
                    setStockUsage(((String) value));
                }
            }
            if( values.containsKey("WarehouseStockCategory") ) {
                final Object value = values.remove("WarehouseStockCategory");
                if( (value == null) || (!value.equals(getWarehouseStockCategory())) ) {
                    setWarehouseStockCategory(((String) value));
                }
            }
            if( values.containsKey("StockOwner") ) {
                final Object value = values.remove("StockOwner");
                if( (value == null) || (!value.equals(getStockOwner())) ) {
                    setStockOwner(((String) value));
                }
            }
            if( values.containsKey("DeliveryItemStockTypeDetnCode") ) {
                final Object value = values.remove("DeliveryItemStockTypeDetnCode");
                if( (value == null) || (!value.equals(getDeliveryItemStockTypeDetnCode())) ) {
                    setDeliveryItemStockTypeDetnCode(((String) value));
                }
            }
            if( values.containsKey("StockDocumentCategory") ) {
                final Object value = values.remove("StockDocumentCategory");
                if( (value == null) || (!value.equals(getStockDocumentCategory())) ) {
                    setStockDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("StockDocumentNumber") ) {
                final Object value = values.remove("StockDocumentNumber");
                if( (value == null) || (!value.equals(getStockDocumentNumber())) ) {
                    setStockDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("StockItemNumber") ) {
                final Object value = values.remove("StockItemNumber");
                if( (value == null) || (!value.equals(getStockItemNumber())) ) {
                    setStockItemNumber(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrder") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrder");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrder())) ) {
                    setSpecialStockIdfgSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrderItem") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrderItem");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrderItem())) ) {
                    setSpecialStockIdfgSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhseInboundDeliveryHead") ) {
                final Object value = (values).remove("to_WhseInboundDeliveryHead");
                if( value instanceof Map ) {
                    if( toWhseInboundDeliveryHead == null ) {
                        toWhseInboundDeliveryHead = new WhseInboundDeliveryHead();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWhseInboundDeliveryHead.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_WhseInbDeliveryItemSerialNo") ) {
                final Object value = (values).remove("to_WhseInbDeliveryItemSerialNo");
                if( value instanceof Iterable ) {
                    if( toWhseInbDeliveryItemSerialNo == null ) {
                        toWhseInbDeliveryItemSerialNo = Lists.newArrayList();
                    } else {
                        toWhseInbDeliveryItemSerialNo = Lists.newArrayList(toWhseInbDeliveryItemSerialNo);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WhseInbDelivItemSerialNumber entity;
                        if( toWhseInbDeliveryItemSerialNo.size() > i ) {
                            entity = toWhseInbDeliveryItemSerialNo.get(i);
                        } else {
                            entity = new WhseInbDelivItemSerialNumber();
                            toWhseInbDeliveryItemSerialNo.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WhseInboundDeliveryItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WhseInboundDeliveryItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhseInboundDeliveryItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhseInboundDeliveryItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhseInboundDeliveryHead != null ) {
            (values).put("to_WhseInboundDeliveryHead", toWhseInboundDeliveryHead);
        }
        if( toWhseInbDeliveryItemSerialNo != null ) {
            (values).put("to_WhseInbDeliveryItemSerialNo", toWhseInbDeliveryItemSerialNo);
        }
        return values;
    }

    /**
     * Fetches the <b>WhseInboundDeliveryHead</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WhseInboundDeliveryHead</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhseInboundDeliveryHead</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseInboundDeliveryHead fetchWhseInboundDeliveryHead()
    {
        return fetchFieldAsSingle("to_WhseInboundDeliveryHead", WhseInboundDeliveryHead.class);
    }

    /**
     * Retrieval of associated <b>WhseInboundDeliveryHead</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseInboundDeliveryHead</b>.
     * <p>
     * If the navigation property <b>to_WhseInboundDeliveryHead</b> of a queried <b>WhseInboundDeliveryItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseInboundDeliveryHead</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseInboundDeliveryHead getWhseInboundDeliveryHeadOrFetch()
    {
        if( toWhseInboundDeliveryHead == null ) {
            toWhseInboundDeliveryHead = fetchWhseInboundDeliveryHead();
        }
        return toWhseInboundDeliveryHead;
    }

    /**
     * Retrieval of associated <b>WhseInboundDeliveryHead</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseInboundDeliveryHead</b>.
     * <p>
     * If the navigation property for an entity <b>WhseInboundDeliveryItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseInboundDeliveryHead</b> is already loaded, the
     *         result will contain the <b>WhseInboundDeliveryHead</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhseInboundDeliveryHead> getWhseInboundDeliveryHeadIfPresent()
    {
        return Option.of(toWhseInboundDeliveryHead);
    }

    /**
     * Overwrites the associated <b>WhseInboundDeliveryHead</b> entity for the loaded navigation property
     * <b>to_WhseInboundDeliveryHead</b>.
     *
     * @param value
     *            New <b>WhseInboundDeliveryHead</b> entity.
     */
    public void setWhseInboundDeliveryHead( final WhseInboundDeliveryHead value )
    {
        toWhseInboundDeliveryHead = value;
    }

    /**
     * Fetches the <b>WhseInbDelivItemSerialNumber</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhseInbDeliveryItemSerialNo</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WhseInbDelivItemSerialNumber</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseInbDelivItemSerialNumber> fetchWhseInbDeliveryItemSerialNo()
    {
        return fetchFieldAsList("to_WhseInbDeliveryItemSerialNo", WhseInbDelivItemSerialNumber.class);
    }

    /**
     * Retrieval of associated <b>WhseInbDelivItemSerialNumber</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WhseInbDeliveryItemSerialNo</b>.
     * <p>
     * If the navigation property <b>to_WhseInbDeliveryItemSerialNo</b> of a queried <b>WhseInboundDeliveryItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseInbDelivItemSerialNumber</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseInbDelivItemSerialNumber> getWhseInbDeliveryItemSerialNoOrFetch()
    {
        if( toWhseInbDeliveryItemSerialNo == null ) {
            toWhseInbDeliveryItemSerialNo = fetchWhseInbDeliveryItemSerialNo();
        }
        return toWhseInbDeliveryItemSerialNo;
    }

    /**
     * Retrieval of associated <b>WhseInbDelivItemSerialNumber</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WhseInbDeliveryItemSerialNo</b>.
     * <p>
     * If the navigation property for an entity <b>WhseInboundDeliveryItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseInbDeliveryItemSerialNo</b> is already loaded, the
     *         result will contain the <b>WhseInbDelivItemSerialNumber</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WhseInbDelivItemSerialNumber>> getWhseInbDeliveryItemSerialNoIfPresent()
    {
        return Option.of(toWhseInbDeliveryItemSerialNo);
    }

    /**
     * Overwrites the list of associated <b>WhseInbDelivItemSerialNumber</b> entities for the loaded navigation property
     * <b>to_WhseInbDeliveryItemSerialNo</b>.
     * <p>
     * If the navigation property <b>to_WhseInbDeliveryItemSerialNo</b> of a queried <b>WhseInboundDeliveryItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WhseInbDelivItemSerialNumber</b> entities.
     */
    public void setWhseInbDeliveryItemSerialNo( @Nonnull final List<WhseInbDelivItemSerialNumber> value )
    {
        if( toWhseInbDeliveryItemSerialNo == null ) {
            toWhseInbDeliveryItemSerialNo = Lists.newArrayList();
        }
        toWhseInbDeliveryItemSerialNo.clear();
        toWhseInbDeliveryItemSerialNo.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WhseInbDelivItemSerialNumber</b> entities. This corresponds to the
     * OData navigation property <b>to_WhseInbDeliveryItemSerialNo</b>.
     * <p>
     * If the navigation property <b>to_WhseInbDeliveryItemSerialNo</b> of a queried <b>WhseInboundDeliveryItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WhseInbDelivItemSerialNumber</b> entities.
     */
    public void addWhseInbDeliveryItemSerialNo( WhseInbDelivItemSerialNumber... entity )
    {
        if( toWhseInbDeliveryItemSerialNo == null ) {
            toWhseInbDeliveryItemSerialNo = Lists.newArrayList();
        }
        toWhseInbDeliveryItemSerialNo.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WhseInboundDeliveryItem instances.
     *
     */
    public final static class WhseInboundDeliveryItemBuilder
    {

        private WhseInboundDeliveryHead toWhseInboundDeliveryHead;
        private List<WhseInbDelivItemSerialNumber> toWhseInbDeliveryItemSerialNo = Lists.newArrayList();

        private WhseInboundDeliveryItem.WhseInboundDeliveryItemBuilder toWhseInboundDeliveryHead(
            final WhseInboundDeliveryHead value )
        {
            toWhseInboundDeliveryHead = value;
            return this;
        }

        /**
         * Navigation property <b>to_WhseInboundDeliveryHead</b> for <b>WhseInboundDeliveryItem</b> to single
         * <b>WhseInboundDeliveryHead</b>.
         *
         * @param value
         *            The WhseInboundDeliveryHead to build this WhseInboundDeliveryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseInboundDeliveryItem.WhseInboundDeliveryItemBuilder whseInboundDeliveryHead(
            final WhseInboundDeliveryHead value )
        {
            return toWhseInboundDeliveryHead(value);
        }

        private WhseInboundDeliveryItem.WhseInboundDeliveryItemBuilder toWhseInbDeliveryItemSerialNo(
            final List<WhseInbDelivItemSerialNumber> value )
        {
            toWhseInbDeliveryItemSerialNo.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WhseInbDeliveryItemSerialNo</b> for <b>WhseInboundDeliveryItem</b> to multiple
         * <b>WhseInbDelivItemSerialNumber</b>.
         *
         * @param value
         *            The WhseInbDelivItemSerialNumbers to build this WhseInboundDeliveryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseInboundDeliveryItem.WhseInboundDeliveryItemBuilder whseInbDeliveryItemSerialNo(
            WhseInbDelivItemSerialNumber... value )
        {
            return toWhseInbDeliveryItemSerialNo(Lists.newArrayList(value));
        }

    }

}
