/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WarehouseInboundDeliveryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService
 * WarehouseInboundDeliveryService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWarehouseInboundDeliveryServiceBatch
    extends
    BatchFluentHelperBasic<WarehouseInboundDeliveryServiceBatch, WarehouseInboundDeliveryServiceBatchChangeSet>
    implements
    WarehouseInboundDeliveryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWarehouseInboundDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseInboundDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWarehouseInboundDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseInboundDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseInboundDeliveryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseInboundDeliveryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWarehouseInboundDeliveryServiceBatchChangeSet(this, service);
    }

}
