/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem;

/**
 * Implementation of the {@link WarehouseInboundDeliveryServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService
 * WarehouseInboundDeliveryService}.
 *
 */
public class DefaultWarehouseInboundDeliveryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WarehouseInboundDeliveryServiceBatch, WarehouseInboundDeliveryServiceBatchChangeSet>
    implements
    WarehouseInboundDeliveryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService service;

    @SuppressWarnings( "deprecation" )
    DefaultWarehouseInboundDeliveryServiceBatchChangeSet(
        @Nonnull final DefaultWarehouseInboundDeliveryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseInboundDeliveryServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseInboundDeliveryServiceBatchChangeSet updateWhseInboundDeliveryHead(
        @Nonnull final WhseInboundDeliveryHead whseInboundDeliveryHead )
    {
        return addRequestUpdate(service::updateWhseInboundDeliveryHead, whseInboundDeliveryHead);
    }

    @Nonnull
    @Override
    public WarehouseInboundDeliveryServiceBatchChangeSet updateWhseInboundDeliveryItem(
        @Nonnull final WhseInboundDeliveryItem whseInboundDeliveryItem )
    {
        return addRequestUpdate(service::updateWhseInboundDeliveryItem, whseInboundDeliveryItem);
    }

}
