/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseInboundDeliveryService
 * WarehouseInboundDeliveryService}.
 *
 */
public interface WarehouseInboundDeliveryServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<WarehouseInboundDeliveryServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<WarehouseInboundDeliveryServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     * WhseInboundDeliveryHead} entity and save it to the S/4HANA system.
     *
     * @param whseInboundDeliveryHead
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     *            WhseInboundDeliveryHead} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehouseInboundDeliveryServiceBatchChangeSet
        updateWhseInboundDeliveryHead( @Nonnull final WhseInboundDeliveryHead whseInboundDeliveryHead );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     * WhseInboundDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param whseInboundDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     *            WhseInboundDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehouseInboundDeliveryServiceBatchChangeSet
        updateWhseInboundDeliveryItem( @Nonnull final WhseInboundDeliveryItem whseInboundDeliveryItem );

}
