/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber
 * WhseInbDelivItemSerialNumber}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.field.WhseInbDelivItemSerialNumberField
 * WhseInbDelivItemSerialNumberField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.link.WhseInbDelivItemSerialNumberLink
 * WhseInbDelivItemSerialNumberLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber#INBOUND_DELIVERY
 * INBOUND_DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber#INBOUND_DELIVERY_ITEM
 * INBOUND_DELIVERY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber#EWM_SERIAL_NUMBER
 * EWM_SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber#TO_WHSE_INBOUND_DELIVERY_ITEM
 * TO_WHSE_INBOUND_DELIVERY_ITEM}</li>
 * </ul>
 *
 */
public interface WhseInbDelivItemSerialNumberSelectable extends EntitySelectable<WhseInbDelivItemSerialNumber>
{

}
