/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
 * WhseInboundDeliveryHead}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.field.WhseInboundDeliveryHeadField
 * WhseInboundDeliveryHeadField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.link.WhseInboundDeliveryHeadLink
 * WhseInboundDeliveryHeadLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#INBOUND_DELIVERY
 * INBOUND_DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#DELIVERY_CATEGORY
 * DELIVERY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#DELIVERY_TYPE
 * DELIVERY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#SHIP_FROM_PARTY
 * SHIP_FROM_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#SHIP_FROM_PARTY_NAME
 * SHIP_FROM_PARTY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#CARRIER
 * CARRIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#CARRIER_NAME
 * CARRIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#ADVANCED_SHIPPING_NOTIFICATION
 * ADVANCED_SHIPPING_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#PLANNED_DELIVERY_UTC_DATE_TIME
 * PLANNED_DELIVERY_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#RECEIVING_OFFICE
 * RECEIVING_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead#TO_WHSE_INBOUND_DELIVERY_ITEM
 * TO_WHSE_INBOUND_DELIVERY_ITEM}</li>
 * </ul>
 *
 */
public interface WhseInboundDeliveryHeadSelectable extends EntitySelectable<WhseInboundDeliveryHead>
{

}
