/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
 * WhseInboundDeliveryItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.field.WhseInboundDeliveryItemField
 * WhseInboundDeliveryItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.link.WhseInboundDeliveryItemLink
 * WhseInboundDeliveryItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#INBOUND_DELIVERY
 * INBOUND_DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#INBOUND_DELIVERY_ITEM
 * INBOUND_DELIVERY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#DELIVERY_CATEGORY
 * DELIVERY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#DELIVERY_ITEM_CATEGORY
 * DELIVERY_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#INBOUND_DELIVERY_ITEM_TYPE
 * INBOUND_DELIVERY_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PRODUCT_EXTERNAL_ID
 * PRODUCT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PRODUCT_BATCH
 * PRODUCT_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PRODUCT_QUANTITY
 * PRODUCT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STAGING_AREA_GROUP
 * STAGING_AREA_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STAGING_AREA
 * STAGING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STAGING_BAY
 * STAGING_BAY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#GOODS_RECEIPT_STATUS
 * GOODS_RECEIPT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PLANNING_PUTAWAY_STATUS
 * PLANNING_PUTAWAY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PUTAWAY_STATUS
 * PUTAWAY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#COMPLETION_STATUS
 * COMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#WAREHOUSE_PROCESS_TYPE
 * WAREHOUSE_PROCESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#GOODS_MOVEMENT_BIN
 * GOODS_MOVEMENT_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#ENTITLED_TO_DISPOSE_PARTY
 * ENTITLED_TO_DISPOSE_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STOCK_USAGE
 * STOCK_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#WAREHOUSE_STOCK_CATEGORY
 * WAREHOUSE_STOCK_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STOCK_OWNER
 * STOCK_OWNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#DELIVERY_ITEM_STOCK_TYPE_DETN_CODE
 * DELIVERY_ITEM_STOCK_TYPE_DETN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STOCK_DOCUMENT_CATEGORY
 * STOCK_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STOCK_DOCUMENT_NUMBER
 * STOCK_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#STOCK_ITEM_NUMBER
 * STOCK_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#SPECIAL_STOCK_IDFG_SALES_ORDER
 * SPECIAL_STOCK_IDFG_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM
 * SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#TO_WHSE_INBOUND_DELIVERY_HEAD
 * TO_WHSE_INBOUND_DELIVERY_HEAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem#TO_WHSE_INB_DELIVERY_ITEM_SERIAL_NO
 * TO_WHSE_INB_DELIVERY_ITEM_SERIAL_NO}</li>
 * </ul>
 *
 */
public interface WhseInboundDeliveryItemSelectable extends EntitySelectable<WhseInboundDeliveryItem>
{

}
