/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseDeliveryDocumentAddressField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseDeliveryDocumentAddressOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseDeliveryDocumentAddressSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Delivery Document Address
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhseDeliveryDocumentAddressType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhseDeliveryDocumentAddress extends VdmEntity<WhseDeliveryDocumentAddress>
{

    /**
     * Selector for all available fields of WhseDeliveryDocumentAddress.
     *
     */
    public final static WhseDeliveryDocumentAddressSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "OutboundDeliveryOrder" )
    @JsonProperty( "OutboundDeliveryOrder" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrder" )
    private String outboundDeliveryOrder;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrder</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> OUTBOUND_DELIVERY_ORDER =
        new WhseDeliveryDocumentAddressField<String>("OutboundDeliveryOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItem</b>
     * </p>
     *
     * @return Item Number
     */
    @Key
    @SerializedName( "OutboundDeliveryOrderItem" )
    @JsonProperty( "OutboundDeliveryOrderItem" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrderItem" )
    private String outboundDeliveryOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrderItem</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> OUTBOUND_DELIVERY_ORDER_ITEM =
        new WhseDeliveryDocumentAddressField<String>("OutboundDeliveryOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerRole</b>
     * </p>
     *
     * @return Partner Role
     */
    @Key
    @SerializedName( "BusinessPartnerRole" )
    @JsonProperty( "BusinessPartnerRole" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerRole" )
    private String businessPartnerRole;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerRole</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> BUSINESS_PARTNER_ROLE =
        new WhseDeliveryDocumentAddressField<String>("BusinessPartnerRole");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BusinessPartnerName1" )
    @JsonProperty( "BusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName1" )
    private String businessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName1</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> BUSINESS_PARTNER_NAME1 =
        new WhseDeliveryDocumentAddressField<String>("BusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BusinessPartnerName2" )
    @JsonProperty( "BusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName2" )
    private String businessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName2</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> BUSINESS_PARTNER_NAME2 =
        new WhseDeliveryDocumentAddressField<String>("BusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @return Street 2
     */
    @SerializedName( "StreetPrefixName" )
    @JsonProperty( "StreetPrefixName" )
    @Nullable
    @ODataField( odataName = "StreetPrefixName" )
    private String streetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetPrefixName</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> STREET_PREFIX_NAME =
        new WhseDeliveryDocumentAddressField<String>("StreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @return Street 3
     */
    @SerializedName( "AdditionalStreetPrefixName" )
    @JsonProperty( "AdditionalStreetPrefixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetPrefixName" )
    private String additionalStreetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetPrefixName</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> ADDITIONAL_STREET_PREFIX_NAME =
        new WhseDeliveryDocumentAddressField<String>("AdditionalStreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> STREET_NAME =
        new WhseDeliveryDocumentAddressField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @return Street 4
     */
    @SerializedName( "StreetSuffixName" )
    @JsonProperty( "StreetSuffixName" )
    @Nullable
    @ODataField( odataName = "StreetSuffixName" )
    private String streetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetSuffixName</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> STREET_SUFFIX_NAME =
        new WhseDeliveryDocumentAddressField<String>("StreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @return Street 5
     */
    @SerializedName( "AdditionalStreetSuffixName" )
    @JsonProperty( "AdditionalStreetSuffixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetSuffixName" )
    private String additionalStreetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetSuffixName</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> ADDITIONAL_STREET_SUFFIX_NAME =
        new WhseDeliveryDocumentAddressField<String>("AdditionalStreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "HouseNumber" )
    @JsonProperty( "HouseNumber" )
    @Nullable
    @ODataField( odataName = "HouseNumber" )
    private String houseNumber;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumber</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> HOUSE_NUMBER =
        new WhseDeliveryDocumentAddressField<String>("HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> POSTAL_CODE =
        new WhseDeliveryDocumentAddressField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> CITY_NAME =
        new WhseDeliveryDocumentAddressField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> REGION =
        new WhseDeliveryDocumentAddressField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> COUNTRY =
        new WhseDeliveryDocumentAddressField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return First Telephone No.: Dialing Code + Number
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> PHONE_NUMBER =
        new WhseDeliveryDocumentAddressField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @return Email Address
     */
    @SerializedName( "EmailAddress" )
    @JsonProperty( "EmailAddress" )
    @Nullable
    @ODataField( odataName = "EmailAddress" )
    private String emailAddress;
    /**
     * Use with available fluent helpers to apply the <b>EmailAddress</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> EMAIL_ADDRESS =
        new WhseDeliveryDocumentAddressField<String>("EmailAddress");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @return Business Purpose Completed Flag
     */
    @SerializedName( "IsBusinessPurposeCompleted" )
    @JsonProperty( "IsBusinessPurposeCompleted" )
    @Nullable
    @ODataField( odataName = "IsBusinessPurposeCompleted" )
    private String isBusinessPurposeCompleted;
    /**
     * Use with available fluent helpers to apply the <b>IsBusinessPurposeCompleted</b> field to query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressField<String> IS_BUSINESS_PURPOSE_COMPLETED =
        new WhseDeliveryDocumentAddressField<String>("IsBusinessPurposeCompleted");
    /**
     * Navigation property <b>to_WhseOutboundDeliveryOrderHead</b> for <b>WhseDeliveryDocumentAddress</b> to single
     * <b>WhseOutboundDeliveryOrderHead</b>.
     *
     */
    @SerializedName( "to_WhseOutboundDeliveryOrderHead" )
    @JsonProperty( "to_WhseOutboundDeliveryOrderHead" )
    @ODataField( odataName = "to_WhseOutboundDeliveryOrderHead" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhseOutboundDeliveryOrderHead toWhseOutboundDeliveryOrderHead;
    /**
     * Navigation property <b>to_WhseOutboundDeliveryOrderItem</b> for <b>WhseDeliveryDocumentAddress</b> to single
     * <b>WhseOutboundDeliveryOrderItem</b>.
     *
     */
    @SerializedName( "to_WhseOutboundDeliveryOrderItem" )
    @JsonProperty( "to_WhseOutboundDeliveryOrderItem" )
    @ODataField( odataName = "to_WhseOutboundDeliveryOrderItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhseOutboundDeliveryOrderItem toWhseOutboundDeliveryOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>to_WhseOutboundDeliveryOrderHead</b> navigation property to
     * query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressOneToOneLink<WhseOutboundDeliveryOrderHead> TO_WHSE_OUTBOUND_DELIVERY_ORDER_HEAD =
        new WhseDeliveryDocumentAddressOneToOneLink<WhseOutboundDeliveryOrderHead>("to_WhseOutboundDeliveryOrderHead");
    /**
     * Use with available fluent helpers to apply the <b>to_WhseOutboundDeliveryOrderItem</b> navigation property to
     * query operations.
     *
     */
    public final static WhseDeliveryDocumentAddressOneToOneLink<WhseOutboundDeliveryOrderItem> TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM =
        new WhseDeliveryDocumentAddressOneToOneLink<WhseOutboundDeliveryOrderItem>("to_WhseOutboundDeliveryOrderItem");

    @Nonnull
    @Override
    public Class<WhseDeliveryDocumentAddress> getType()
    {
        return WhseDeliveryDocumentAddress.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     */
    public void setOutboundDeliveryOrder( @Nullable final String outboundDeliveryOrder )
    {
        rememberChangedField("OutboundDeliveryOrder", this.outboundDeliveryOrder);
        this.outboundDeliveryOrder = outboundDeliveryOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItem</b>
     * </p>
     *
     * @param outboundDeliveryOrderItem
     *            Item Number
     */
    public void setOutboundDeliveryOrderItem( @Nullable final String outboundDeliveryOrderItem )
    {
        rememberChangedField("OutboundDeliveryOrderItem", this.outboundDeliveryOrderItem);
        this.outboundDeliveryOrderItem = outboundDeliveryOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerRole</b>
     * </p>
     *
     * @param businessPartnerRole
     *            Partner Role
     */
    public void setBusinessPartnerRole( @Nullable final String businessPartnerRole )
    {
        rememberChangedField("BusinessPartnerRole", this.businessPartnerRole);
        this.businessPartnerRole = businessPartnerRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @param businessPartnerName1
     *            Name 1
     */
    public void setBusinessPartnerName1( @Nullable final String businessPartnerName1 )
    {
        rememberChangedField("BusinessPartnerName1", this.businessPartnerName1);
        this.businessPartnerName1 = businessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @param businessPartnerName2
     *            Name 2
     */
    public void setBusinessPartnerName2( @Nullable final String businessPartnerName2 )
    {
        rememberChangedField("BusinessPartnerName2", this.businessPartnerName2);
        this.businessPartnerName2 = businessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @param streetPrefixName
     *            Street 2
     */
    public void setStreetPrefixName( @Nullable final String streetPrefixName )
    {
        rememberChangedField("StreetPrefixName", this.streetPrefixName);
        this.streetPrefixName = streetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @param additionalStreetPrefixName
     *            Street 3
     */
    public void setAdditionalStreetPrefixName( @Nullable final String additionalStreetPrefixName )
    {
        rememberChangedField("AdditionalStreetPrefixName", this.additionalStreetPrefixName);
        this.additionalStreetPrefixName = additionalStreetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @param streetSuffixName
     *            Street 4
     */
    public void setStreetSuffixName( @Nullable final String streetSuffixName )
    {
        rememberChangedField("StreetSuffixName", this.streetSuffixName);
        this.streetSuffixName = streetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @param additionalStreetSuffixName
     *            Street 5
     */
    public void setAdditionalStreetSuffixName( @Nullable final String additionalStreetSuffixName )
    {
        rememberChangedField("AdditionalStreetSuffixName", this.additionalStreetSuffixName);
        this.additionalStreetSuffixName = additionalStreetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            First Telephone No.: Dialing Code + Number
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @param emailAddress
     *            Email Address
     */
    public void setEmailAddress( @Nullable final String emailAddress )
    {
        rememberChangedField("EmailAddress", this.emailAddress);
        this.emailAddress = emailAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @param isBusinessPurposeCompleted
     *            Business Purpose Completed Flag
     */
    public void setIsBusinessPurposeCompleted( @Nullable final String isBusinessPurposeCompleted )
    {
        rememberChangedField("IsBusinessPurposeCompleted", this.isBusinessPurposeCompleted);
        this.isBusinessPurposeCompleted = isBusinessPurposeCompleted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhseDeliveryDocumentAddress";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        result.put("OutboundDeliveryOrderItem", getOutboundDeliveryOrderItem());
        result.put("BusinessPartnerRole", getBusinessPartnerRole());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        values.put("OutboundDeliveryOrderItem", getOutboundDeliveryOrderItem());
        values.put("BusinessPartnerRole", getBusinessPartnerRole());
        values.put("BusinessPartnerName1", getBusinessPartnerName1());
        values.put("BusinessPartnerName2", getBusinessPartnerName2());
        values.put("StreetPrefixName", getStreetPrefixName());
        values.put("AdditionalStreetPrefixName", getAdditionalStreetPrefixName());
        values.put("StreetName", getStreetName());
        values.put("StreetSuffixName", getStreetSuffixName());
        values.put("AdditionalStreetSuffixName", getAdditionalStreetSuffixName());
        values.put("HouseNumber", getHouseNumber());
        values.put("PostalCode", getPostalCode());
        values.put("CityName", getCityName());
        values.put("Region", getRegion());
        values.put("Country", getCountry());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("EmailAddress", getEmailAddress());
        values.put("IsBusinessPurposeCompleted", getIsBusinessPurposeCompleted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OutboundDeliveryOrder") ) {
                final Object value = values.remove("OutboundDeliveryOrder");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrder())) ) {
                    setOutboundDeliveryOrder(((String) value));
                }
            }
            if( values.containsKey("OutboundDeliveryOrderItem") ) {
                final Object value = values.remove("OutboundDeliveryOrderItem");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrderItem())) ) {
                    setOutboundDeliveryOrderItem(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerRole") ) {
                final Object value = values.remove("BusinessPartnerRole");
                if( (value == null) || (!value.equals(getBusinessPartnerRole())) ) {
                    setBusinessPartnerRole(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName1") ) {
                final Object value = values.remove("BusinessPartnerName1");
                if( (value == null) || (!value.equals(getBusinessPartnerName1())) ) {
                    setBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName2") ) {
                final Object value = values.remove("BusinessPartnerName2");
                if( (value == null) || (!value.equals(getBusinessPartnerName2())) ) {
                    setBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("StreetPrefixName") ) {
                final Object value = values.remove("StreetPrefixName");
                if( (value == null) || (!value.equals(getStreetPrefixName())) ) {
                    setStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetPrefixName") ) {
                final Object value = values.remove("AdditionalStreetPrefixName");
                if( (value == null) || (!value.equals(getAdditionalStreetPrefixName())) ) {
                    setAdditionalStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("StreetSuffixName") ) {
                final Object value = values.remove("StreetSuffixName");
                if( (value == null) || (!value.equals(getStreetSuffixName())) ) {
                    setStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetSuffixName") ) {
                final Object value = values.remove("AdditionalStreetSuffixName");
                if( (value == null) || (!value.equals(getAdditionalStreetSuffixName())) ) {
                    setAdditionalStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("EmailAddress") ) {
                final Object value = values.remove("EmailAddress");
                if( (value == null) || (!value.equals(getEmailAddress())) ) {
                    setEmailAddress(((String) value));
                }
            }
            if( values.containsKey("IsBusinessPurposeCompleted") ) {
                final Object value = values.remove("IsBusinessPurposeCompleted");
                if( (value == null) || (!value.equals(getIsBusinessPurposeCompleted())) ) {
                    setIsBusinessPurposeCompleted(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhseOutboundDeliveryOrderHead") ) {
                final Object value = (values).remove("to_WhseOutboundDeliveryOrderHead");
                if( value instanceof Map ) {
                    if( toWhseOutboundDeliveryOrderHead == null ) {
                        toWhseOutboundDeliveryOrderHead = new WhseOutboundDeliveryOrderHead();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWhseOutboundDeliveryOrderHead.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_WhseOutboundDeliveryOrderItem") ) {
                final Object value = (values).remove("to_WhseOutboundDeliveryOrderItem");
                if( value instanceof Map ) {
                    if( toWhseOutboundDeliveryOrderItem == null ) {
                        toWhseOutboundDeliveryOrderItem = new WhseOutboundDeliveryOrderItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWhseOutboundDeliveryOrderItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WhseDeliveryDocumentAddressField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WhseDeliveryDocumentAddressField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhseDeliveryDocumentAddressField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhseDeliveryDocumentAddressField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhseOutboundDeliveryOrderHead != null ) {
            (values).put("to_WhseOutboundDeliveryOrderHead", toWhseOutboundDeliveryOrderHead);
        }
        if( toWhseOutboundDeliveryOrderItem != null ) {
            (values).put("to_WhseOutboundDeliveryOrderItem", toWhseOutboundDeliveryOrderItem);
        }
        return values;
    }

    /**
     * Fetches the <b>WhseOutboundDeliveryOrderHead</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhseOutboundDeliveryOrderHead</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhseOutboundDeliveryOrderHead</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderHead fetchWhseOutboundDeliveryOrderHead()
    {
        return fetchFieldAsSingle("to_WhseOutboundDeliveryOrderHead", WhseOutboundDeliveryOrderHead.class);
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderHead</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderHead</b>.
     * <p>
     * If the navigation property <b>to_WhseOutboundDeliveryOrderHead</b> of a queried
     * <b>WhseDeliveryDocumentAddress</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an OData
     * query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseOutboundDeliveryOrderHead</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderHead getWhseOutboundDeliveryOrderHeadOrFetch()
    {
        if( toWhseOutboundDeliveryOrderHead == null ) {
            toWhseOutboundDeliveryOrderHead = fetchWhseOutboundDeliveryOrderHead();
        }
        return toWhseOutboundDeliveryOrderHead;
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderHead</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderHead</b>.
     * <p>
     * If the navigation property for an entity <b>WhseDeliveryDocumentAddress</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseOutboundDeliveryOrderHead</b> is already loaded, the
     *         result will contain the <b>WhseOutboundDeliveryOrderHead</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhseOutboundDeliveryOrderHead> getWhseOutboundDeliveryOrderHeadIfPresent()
    {
        return Option.of(toWhseOutboundDeliveryOrderHead);
    }

    /**
     * Overwrites the associated <b>WhseOutboundDeliveryOrderHead</b> entity for the loaded navigation property
     * <b>to_WhseOutboundDeliveryOrderHead</b>.
     *
     * @param value
     *            New <b>WhseOutboundDeliveryOrderHead</b> entity.
     */
    public void setWhseOutboundDeliveryOrderHead( final WhseOutboundDeliveryOrderHead value )
    {
        toWhseOutboundDeliveryOrderHead = value;
    }

    /**
     * Fetches the <b>WhseOutboundDeliveryOrderItem</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhseOutboundDeliveryOrderItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderItem fetchWhseOutboundDeliveryOrderItem()
    {
        return fetchFieldAsSingle("to_WhseOutboundDeliveryOrderItem", WhseOutboundDeliveryOrderItem.class);
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property <b>to_WhseOutboundDeliveryOrderItem</b> of a queried
     * <b>WhseDeliveryDocumentAddress</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an OData
     * query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseOutboundDeliveryOrderItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderItem getWhseOutboundDeliveryOrderItemOrFetch()
    {
        if( toWhseOutboundDeliveryOrderItem == null ) {
            toWhseOutboundDeliveryOrderItem = fetchWhseOutboundDeliveryOrderItem();
        }
        return toWhseOutboundDeliveryOrderItem;
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>WhseDeliveryDocumentAddress</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseOutboundDeliveryOrderItem</b> is already loaded, the
     *         result will contain the <b>WhseOutboundDeliveryOrderItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhseOutboundDeliveryOrderItem> getWhseOutboundDeliveryOrderItemIfPresent()
    {
        return Option.of(toWhseOutboundDeliveryOrderItem);
    }

    /**
     * Overwrites the associated <b>WhseOutboundDeliveryOrderItem</b> entity for the loaded navigation property
     * <b>to_WhseOutboundDeliveryOrderItem</b>.
     *
     * @param value
     *            New <b>WhseOutboundDeliveryOrderItem</b> entity.
     */
    public void setWhseOutboundDeliveryOrderItem( final WhseOutboundDeliveryOrderItem value )
    {
        toWhseOutboundDeliveryOrderItem = value;
    }

    /**
     * Helper class to allow for fluent creation of WhseDeliveryDocumentAddress instances.
     *
     */
    public final static class WhseDeliveryDocumentAddressBuilder
    {

        private WhseOutboundDeliveryOrderHead toWhseOutboundDeliveryOrderHead;
        private WhseOutboundDeliveryOrderItem toWhseOutboundDeliveryOrderItem;

        private WhseDeliveryDocumentAddress.WhseDeliveryDocumentAddressBuilder toWhseOutboundDeliveryOrderHead(
            final WhseOutboundDeliveryOrderHead value )
        {
            toWhseOutboundDeliveryOrderHead = value;
            return this;
        }

        /**
         * Navigation property <b>to_WhseOutboundDeliveryOrderHead</b> for <b>WhseDeliveryDocumentAddress</b> to single
         * <b>WhseOutboundDeliveryOrderHead</b>.
         *
         * @param value
         *            The WhseOutboundDeliveryOrderHead to build this WhseDeliveryDocumentAddress with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseDeliveryDocumentAddress.WhseDeliveryDocumentAddressBuilder whseOutboundDeliveryOrderHead(
            final WhseOutboundDeliveryOrderHead value )
        {
            return toWhseOutboundDeliveryOrderHead(value);
        }

        private WhseDeliveryDocumentAddress.WhseDeliveryDocumentAddressBuilder toWhseOutboundDeliveryOrderItem(
            final WhseOutboundDeliveryOrderItem value )
        {
            toWhseOutboundDeliveryOrderItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_WhseOutboundDeliveryOrderItem</b> for <b>WhseDeliveryDocumentAddress</b> to single
         * <b>WhseOutboundDeliveryOrderItem</b>.
         *
         * @param value
         *            The WhseOutboundDeliveryOrderItem to build this WhseDeliveryDocumentAddress with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseDeliveryDocumentAddress.WhseDeliveryDocumentAddressBuilder whseOutboundDeliveryOrderItem(
            final WhseOutboundDeliveryOrderItem value )
        {
            return toWhseOutboundDeliveryOrderItem(value);
        }

    }

}
