/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseOutbDelivOrderItemSerialNoField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseOutbDelivOrderItemSerialNoOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseOutbDelivOrderItemSerialNoSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Whse OutbDeliv Order Item Serial Number
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhseOutbDelivOrderItemSerialNoType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhseOutbDelivOrderItemSerialNo extends VdmEntity<WhseOutbDelivOrderItemSerialNo>
{

    /**
     * Selector for all available fields of WhseOutbDelivOrderItemSerialNo.
     *
     */
    public final static WhseOutbDelivOrderItemSerialNoSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "OutboundDeliveryOrder" )
    @JsonProperty( "OutboundDeliveryOrder" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrder" )
    private String outboundDeliveryOrder;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrder</b> field to query operations.
     *
     */
    public final static WhseOutbDelivOrderItemSerialNoField<String> OUTBOUND_DELIVERY_ORDER =
        new WhseOutbDelivOrderItemSerialNoField<String>("OutboundDeliveryOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItem</b>
     * </p>
     *
     * @return Item Number
     */
    @Key
    @SerializedName( "OutboundDeliveryOrderItem" )
    @JsonProperty( "OutboundDeliveryOrderItem" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrderItem" )
    private String outboundDeliveryOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrderItem</b> field to query operations.
     *
     */
    public final static WhseOutbDelivOrderItemSerialNoField<String> OUTBOUND_DELIVERY_ORDER_ITEM =
        new WhseOutbDelivOrderItemSerialNoField<String>("OutboundDeliveryOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>EWMSerialNumber</b>
     * </p>
     *
     * @return The eWMSerialNumber contained in this entity.
     */
    @Key
    @SerializedName( "EWMSerialNumber" )
    @JsonProperty( "EWMSerialNumber" )
    @Nullable
    @ODataField( odataName = "EWMSerialNumber" )
    private String eWMSerialNumber;
    /**
     * Use with available fluent helpers to apply the <b>EWMSerialNumber</b> field to query operations.
     *
     */
    public final static WhseOutbDelivOrderItemSerialNoField<String> EWM_SERIAL_NUMBER =
        new WhseOutbDelivOrderItemSerialNoField<String>("EWMSerialNumber");
    /**
     * Navigation property <b>to_WhseOutboundDeliveryOrderItem</b> for <b>WhseOutbDelivOrderItemSerialNo</b> to single
     * <b>WhseOutboundDeliveryOrderItem</b>.
     *
     */
    @SerializedName( "to_WhseOutboundDeliveryOrderItem" )
    @JsonProperty( "to_WhseOutboundDeliveryOrderItem" )
    @ODataField( odataName = "to_WhseOutboundDeliveryOrderItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhseOutboundDeliveryOrderItem toWhseOutboundDeliveryOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>to_WhseOutboundDeliveryOrderItem</b> navigation property to
     * query operations.
     *
     */
    public final static WhseOutbDelivOrderItemSerialNoOneToOneLink<WhseOutboundDeliveryOrderItem> TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM =
        new WhseOutbDelivOrderItemSerialNoOneToOneLink<WhseOutboundDeliveryOrderItem>(
            "to_WhseOutboundDeliveryOrderItem");

    @Nonnull
    @Override
    public Class<WhseOutbDelivOrderItemSerialNo> getType()
    {
        return WhseOutbDelivOrderItemSerialNo.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     */
    public void setOutboundDeliveryOrder( @Nullable final String outboundDeliveryOrder )
    {
        rememberChangedField("OutboundDeliveryOrder", this.outboundDeliveryOrder);
        this.outboundDeliveryOrder = outboundDeliveryOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItem</b>
     * </p>
     *
     * @param outboundDeliveryOrderItem
     *            Item Number
     */
    public void setOutboundDeliveryOrderItem( @Nullable final String outboundDeliveryOrderItem )
    {
        rememberChangedField("OutboundDeliveryOrderItem", this.outboundDeliveryOrderItem);
        this.outboundDeliveryOrderItem = outboundDeliveryOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>EWMSerialNumber</b>
     * </p>
     *
     * @param eWMSerialNumber
     *            The eWMSerialNumber to set.
     */
    public void setEWMSerialNumber( @Nullable final String eWMSerialNumber )
    {
        rememberChangedField("EWMSerialNumber", this.eWMSerialNumber);
        this.eWMSerialNumber = eWMSerialNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhseOutbDelivOrderItemSerialNo";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        result.put("OutboundDeliveryOrderItem", getOutboundDeliveryOrderItem());
        result.put("EWMSerialNumber", getEWMSerialNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        values.put("OutboundDeliveryOrderItem", getOutboundDeliveryOrderItem());
        values.put("EWMSerialNumber", getEWMSerialNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OutboundDeliveryOrder") ) {
                final Object value = values.remove("OutboundDeliveryOrder");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrder())) ) {
                    setOutboundDeliveryOrder(((String) value));
                }
            }
            if( values.containsKey("OutboundDeliveryOrderItem") ) {
                final Object value = values.remove("OutboundDeliveryOrderItem");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrderItem())) ) {
                    setOutboundDeliveryOrderItem(((String) value));
                }
            }
            if( values.containsKey("EWMSerialNumber") ) {
                final Object value = values.remove("EWMSerialNumber");
                if( (value == null) || (!value.equals(getEWMSerialNumber())) ) {
                    setEWMSerialNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhseOutboundDeliveryOrderItem") ) {
                final Object value = (values).remove("to_WhseOutboundDeliveryOrderItem");
                if( value instanceof Map ) {
                    if( toWhseOutboundDeliveryOrderItem == null ) {
                        toWhseOutboundDeliveryOrderItem = new WhseOutboundDeliveryOrderItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWhseOutboundDeliveryOrderItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WhseOutbDelivOrderItemSerialNoField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WhseOutbDelivOrderItemSerialNoField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhseOutbDelivOrderItemSerialNoField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhseOutbDelivOrderItemSerialNoField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhseOutboundDeliveryOrderItem != null ) {
            (values).put("to_WhseOutboundDeliveryOrderItem", toWhseOutboundDeliveryOrderItem);
        }
        return values;
    }

    /**
     * Fetches the <b>WhseOutboundDeliveryOrderItem</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhseOutboundDeliveryOrderItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderItem fetchWhseOutboundDeliveryOrderItem()
    {
        return fetchFieldAsSingle("to_WhseOutboundDeliveryOrderItem", WhseOutboundDeliveryOrderItem.class);
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property <b>to_WhseOutboundDeliveryOrderItem</b> of a queried
     * <b>WhseOutbDelivOrderItemSerialNo</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseOutboundDeliveryOrderItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderItem getWhseOutboundDeliveryOrderItemOrFetch()
    {
        if( toWhseOutboundDeliveryOrderItem == null ) {
            toWhseOutboundDeliveryOrderItem = fetchWhseOutboundDeliveryOrderItem();
        }
        return toWhseOutboundDeliveryOrderItem;
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>WhseOutbDelivOrderItemSerialNo</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseOutboundDeliveryOrderItem</b> is already loaded, the
     *         result will contain the <b>WhseOutboundDeliveryOrderItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhseOutboundDeliveryOrderItem> getWhseOutboundDeliveryOrderItemIfPresent()
    {
        return Option.of(toWhseOutboundDeliveryOrderItem);
    }

    /**
     * Overwrites the associated <b>WhseOutboundDeliveryOrderItem</b> entity for the loaded navigation property
     * <b>to_WhseOutboundDeliveryOrderItem</b>.
     *
     * @param value
     *            New <b>WhseOutboundDeliveryOrderItem</b> entity.
     */
    public void setWhseOutboundDeliveryOrderItem( final WhseOutboundDeliveryOrderItem value )
    {
        toWhseOutboundDeliveryOrderItem = value;
    }

    /**
     * Helper class to allow for fluent creation of WhseOutbDelivOrderItemSerialNo instances.
     *
     */
    public final static class WhseOutbDelivOrderItemSerialNoBuilder
    {

        private WhseOutboundDeliveryOrderItem toWhseOutboundDeliveryOrderItem;

        private WhseOutbDelivOrderItemSerialNo.WhseOutbDelivOrderItemSerialNoBuilder toWhseOutboundDeliveryOrderItem(
            final WhseOutboundDeliveryOrderItem value )
        {
            toWhseOutboundDeliveryOrderItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_WhseOutboundDeliveryOrderItem</b> for <b>WhseOutbDelivOrderItemSerialNo</b> to
         * single <b>WhseOutboundDeliveryOrderItem</b>.
         *
         * @param value
         *            The WhseOutboundDeliveryOrderItem to build this WhseOutbDelivOrderItemSerialNo with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseOutbDelivOrderItemSerialNo.WhseOutbDelivOrderItemSerialNoBuilder whseOutboundDeliveryOrderItem(
            final WhseOutboundDeliveryOrderItem value )
        {
            return toWhseOutboundDeliveryOrderItem(value);
        }

    }

}
