/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseOutbDelivOrderItemSerialNoSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo
 * WhseOutbDelivOrderItemSerialNo} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class WhseOutbDelivOrderItemSerialNoByKeyFluentHelper
    extends
    FluentHelperByKey<WhseOutbDelivOrderItemSerialNoByKeyFluentHelper, WhseOutbDelivOrderItemSerialNo, WhseOutbDelivOrderItemSerialNoSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo
     * WhseOutbDelivOrderItemSerialNo} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WhseOutbDelivOrderItemSerialNo}
     * @param servicePath
     *            Service path to be used to fetch a single {@code WhseOutbDelivOrderItemSerialNo}
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param eWMSerialNumber
     *
     * @param outboundDeliveryOrderItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public WhseOutbDelivOrderItemSerialNoByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem,
        final String eWMSerialNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("OutboundDeliveryOrder", outboundDeliveryOrder);
        this.key.put("OutboundDeliveryOrderItem", outboundDeliveryOrderItem);
        this.key.put("EWMSerialNumber", eWMSerialNumber);
    }

    @Override
    @Nonnull
    protected Class<WhseOutbDelivOrderItemSerialNo> getEntityClass()
    {
        return WhseOutbDelivOrderItemSerialNo.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
