/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseOutboundDeliveryOrderHeadField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseOutboundDeliveryOrderHeadLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseOutboundDeliveryOrderHeadSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Outbound Delivery Order Head
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhseOutboundDeliveryOrderHeadType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhseOutboundDeliveryOrderHead extends VdmEntity<WhseOutboundDeliveryOrderHead>
{

    /**
     * Selector for all available fields of WhseOutboundDeliveryOrderHead.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "OutboundDeliveryOrder" )
    @JsonProperty( "OutboundDeliveryOrder" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrder" )
    private String outboundDeliveryOrder;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrder</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> OUTBOUND_DELIVERY_ORDER =
        new WhseOutboundDeliveryOrderHeadField<String>("OutboundDeliveryOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> WAREHOUSE =
        new WhseOutboundDeliveryOrderHeadField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @return Document Category
     */
    @SerializedName( "DeliveryCategory" )
    @JsonProperty( "DeliveryCategory" )
    @Nullable
    @ODataField( odataName = "DeliveryCategory" )
    private String deliveryCategory;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryCategory</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> DELIVERY_CATEGORY =
        new WhseOutboundDeliveryOrderHeadField<String>("DeliveryCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DeliveryType" )
    @JsonProperty( "DeliveryType" )
    @Nullable
    @ODataField( odataName = "DeliveryType" )
    private String deliveryType;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryType</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> DELIVERY_TYPE =
        new WhseOutboundDeliveryOrderHeadField<String>("DeliveryType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> SHIP_TO_PARTY =
        new WhseOutboundDeliveryOrderHeadField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ShipToPartyName</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "ShipToPartyName" )
    @JsonProperty( "ShipToPartyName" )
    @Nullable
    @ODataField( odataName = "ShipToPartyName" )
    private String shipToPartyName;
    /**
     * Use with available fluent helpers to apply the <b>ShipToPartyName</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> SHIP_TO_PARTY_NAME =
        new WhseOutboundDeliveryOrderHeadField<String>("ShipToPartyName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Carrier</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "Carrier" )
    @JsonProperty( "Carrier" )
    @Nullable
    @ODataField( odataName = "Carrier" )
    private String carrier;
    /**
     * Use with available fluent helpers to apply the <b>Carrier</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> CARRIER =
        new WhseOutboundDeliveryOrderHeadField<String>("Carrier");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CarrierName</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "CarrierName" )
    @JsonProperty( "CarrierName" )
    @Nullable
    @ODataField( odataName = "CarrierName" )
    private String carrierName;
    /**
     * Use with available fluent helpers to apply the <b>CarrierName</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> CARRIER_NAME =
        new WhseOutboundDeliveryOrderHeadField<String>("CarrierName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryUTCDateTime</b>
     * </p>
     *
     * @return Creation Date/Time
     */
    @SerializedName( "PlannedDeliveryUTCDateTime" )
    @JsonProperty( "PlannedDeliveryUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedDeliveryUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedDeliveryUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryUTCDateTime</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<ZonedDateTime> PLANNED_DELIVERY_UTC_DATE_TIME =
        new WhseOutboundDeliveryOrderHeadField<ZonedDateTime>("PlannedDeliveryUTCDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOutOfYardUTCDateTime</b>
     * </p>
     *
     * @return Creation Date/Time
     */
    @SerializedName( "PlannedOutOfYardUTCDateTime" )
    @JsonProperty( "PlannedOutOfYardUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedOutOfYardUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedOutOfYardUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOutOfYardUTCDateTime</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<ZonedDateTime> PLANNED_OUT_OF_YARD_UTC_DATE_TIME =
        new WhseOutboundDeliveryOrderHeadField<ZonedDateTime>("PlannedOutOfYardUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart1</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsPart1" )
    @JsonProperty( "IncotermsPart1" )
    @Nullable
    @ODataField( odataName = "IncotermsPart1" )
    private String incotermsPart1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsPart1</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> INCOTERMS_PART1 =
        new WhseOutboundDeliveryOrderHeadField<String>("IncotermsPart1");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart2</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsPart2" )
    @JsonProperty( "IncotermsPart2" )
    @Nullable
    @ODataField( odataName = "IncotermsPart2" )
    private String incotermsPart2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsPart2</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> INCOTERMS_PART2 =
        new WhseOutboundDeliveryOrderHeadField<String>("IncotermsPart2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Route</b>
     * </p>
     *
     * @return Route Name (Identification)
     */
    @SerializedName( "Route" )
    @JsonProperty( "Route" )
    @Nullable
    @ODataField( odataName = "Route" )
    private String route;
    /**
     * Use with available fluent helpers to apply the <b>Route</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> ROUTE =
        new WhseOutboundDeliveryOrderHeadField<String>("Route");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> SALES_ORGANIZATION =
        new WhseOutboundDeliveryOrderHeadField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ShippingOffice</b>
     * </p>
     *
     * @return Location Number
     */
    @SerializedName( "ShippingOffice" )
    @JsonProperty( "ShippingOffice" )
    @Nullable
    @ODataField( odataName = "ShippingOffice" )
    private String shippingOffice;
    /**
     * Use with available fluent helpers to apply the <b>ShippingOffice</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<String> SHIPPING_OFFICE =
        new WhseOutboundDeliveryOrderHeadField<String>("ShippingOffice");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new WhseOutboundDeliveryOrderHeadField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_ShipToPartyDocumentAddress</b> for <b>WhseOutboundDeliveryOrderHead</b> to multiple
     * <b>WhseDeliveryDocumentAddress</b>.
     *
     */
    @SerializedName( "to_ShipToPartyDocumentAddress" )
    @JsonProperty( "to_ShipToPartyDocumentAddress" )
    @ODataField( odataName = "to_ShipToPartyDocumentAddress" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WhseDeliveryDocumentAddress> toShipToPartyDocumentAddress;
    /**
     * Navigation property <b>to_WhseOutboundDeliveryOrderItem</b> for <b>WhseOutboundDeliveryOrderHead</b> to multiple
     * <b>WhseOutboundDeliveryOrderItem</b>.
     *
     */
    @SerializedName( "to_WhseOutboundDeliveryOrderItem" )
    @JsonProperty( "to_WhseOutboundDeliveryOrderItem" )
    @ODataField( odataName = "to_WhseOutboundDeliveryOrderItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WhseOutboundDeliveryOrderItem> toWhseOutboundDeliveryOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>to_ShipToPartyDocumentAddress</b> navigation property to query
     * operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadLink<WhseDeliveryDocumentAddress> TO_SHIP_TO_PARTY_DOCUMENT_ADDRESS =
        new WhseOutboundDeliveryOrderHeadLink<WhseDeliveryDocumentAddress>("to_ShipToPartyDocumentAddress");
    /**
     * Use with available fluent helpers to apply the <b>to_WhseOutboundDeliveryOrderItem</b> navigation property to
     * query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderHeadLink<WhseOutboundDeliveryOrderItem> TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM =
        new WhseOutboundDeliveryOrderHeadLink<WhseOutboundDeliveryOrderItem>("to_WhseOutboundDeliveryOrderItem");

    @Nonnull
    @Override
    public Class<WhseOutboundDeliveryOrderHead> getType()
    {
        return WhseOutboundDeliveryOrderHead.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     */
    public void setOutboundDeliveryOrder( @Nullable final String outboundDeliveryOrder )
    {
        rememberChangedField("OutboundDeliveryOrder", this.outboundDeliveryOrder);
        this.outboundDeliveryOrder = outboundDeliveryOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @param deliveryCategory
     *            Document Category
     */
    public void setDeliveryCategory( @Nullable final String deliveryCategory )
    {
        rememberChangedField("DeliveryCategory", this.deliveryCategory);
        this.deliveryCategory = deliveryCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryType</b>
     * </p>
     *
     * @param deliveryType
     *            Document Type
     */
    public void setDeliveryType( @Nullable final String deliveryType )
    {
        rememberChangedField("DeliveryType", this.deliveryType);
        this.deliveryType = deliveryType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Business Partner Number
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ShipToPartyName</b>
     * </p>
     *
     * @param shipToPartyName
     *            Name 1 of organization
     */
    public void setShipToPartyName( @Nullable final String shipToPartyName )
    {
        rememberChangedField("ShipToPartyName", this.shipToPartyName);
        this.shipToPartyName = shipToPartyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Carrier</b>
     * </p>
     *
     * @param carrier
     *            Business Partner Number
     */
    public void setCarrier( @Nullable final String carrier )
    {
        rememberChangedField("Carrier", this.carrier);
        this.carrier = carrier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CarrierName</b>
     * </p>
     *
     * @param carrierName
     *            Name 1 of organization
     */
    public void setCarrierName( @Nullable final String carrierName )
    {
        rememberChangedField("CarrierName", this.carrierName);
        this.carrierName = carrierName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryUTCDateTime</b>
     * </p>
     *
     * @param plannedDeliveryUTCDateTime
     *            Creation Date/Time
     */
    public void setPlannedDeliveryUTCDateTime( @Nullable final ZonedDateTime plannedDeliveryUTCDateTime )
    {
        rememberChangedField("PlannedDeliveryUTCDateTime", this.plannedDeliveryUTCDateTime);
        this.plannedDeliveryUTCDateTime = plannedDeliveryUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOutOfYardUTCDateTime</b>
     * </p>
     *
     * @param plannedOutOfYardUTCDateTime
     *            Creation Date/Time
     */
    public void setPlannedOutOfYardUTCDateTime( @Nullable final ZonedDateTime plannedOutOfYardUTCDateTime )
    {
        rememberChangedField("PlannedOutOfYardUTCDateTime", this.plannedOutOfYardUTCDateTime);
        this.plannedOutOfYardUTCDateTime = plannedOutOfYardUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart1</b>
     * </p>
     *
     * @param incotermsPart1
     *            Incoterms (Part 1)
     */
    public void setIncotermsPart1( @Nullable final String incotermsPart1 )
    {
        rememberChangedField("IncotermsPart1", this.incotermsPart1);
        this.incotermsPart1 = incotermsPart1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart2</b>
     * </p>
     *
     * @param incotermsPart2
     *            Incoterms (Part 2)
     */
    public void setIncotermsPart2( @Nullable final String incotermsPart2 )
    {
        rememberChangedField("IncotermsPart2", this.incotermsPart2);
        this.incotermsPart2 = incotermsPart2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Route</b>
     * </p>
     *
     * @param route
     *            Route Name (Identification)
     */
    public void setRoute( @Nullable final String route )
    {
        rememberChangedField("Route", this.route);
        this.route = route;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ShippingOffice</b>
     * </p>
     *
     * @param shippingOffice
     *            Location Number
     */
    public void setShippingOffice( @Nullable final String shippingOffice )
    {
        rememberChangedField("ShippingOffice", this.shippingOffice);
        this.shippingOffice = shippingOffice;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhseOutboundDeliveryOrderHead";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        values.put("Warehouse", getWarehouse());
        values.put("DeliveryCategory", getDeliveryCategory());
        values.put("DeliveryType", getDeliveryType());
        values.put("ShipToParty", getShipToParty());
        values.put("ShipToPartyName", getShipToPartyName());
        values.put("Carrier", getCarrier());
        values.put("CarrierName", getCarrierName());
        values.put("PlannedDeliveryUTCDateTime", getPlannedDeliveryUTCDateTime());
        values.put("PlannedOutOfYardUTCDateTime", getPlannedOutOfYardUTCDateTime());
        values.put("IncotermsPart1", getIncotermsPart1());
        values.put("IncotermsPart2", getIncotermsPart2());
        values.put("Route", getRoute());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("ShippingOffice", getShippingOffice());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OutboundDeliveryOrder") ) {
                final Object value = values.remove("OutboundDeliveryOrder");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrder())) ) {
                    setOutboundDeliveryOrder(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("DeliveryCategory") ) {
                final Object value = values.remove("DeliveryCategory");
                if( (value == null) || (!value.equals(getDeliveryCategory())) ) {
                    setDeliveryCategory(((String) value));
                }
            }
            if( values.containsKey("DeliveryType") ) {
                final Object value = values.remove("DeliveryType");
                if( (value == null) || (!value.equals(getDeliveryType())) ) {
                    setDeliveryType(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToPartyName") ) {
                final Object value = values.remove("ShipToPartyName");
                if( (value == null) || (!value.equals(getShipToPartyName())) ) {
                    setShipToPartyName(((String) value));
                }
            }
            if( values.containsKey("Carrier") ) {
                final Object value = values.remove("Carrier");
                if( (value == null) || (!value.equals(getCarrier())) ) {
                    setCarrier(((String) value));
                }
            }
            if( values.containsKey("CarrierName") ) {
                final Object value = values.remove("CarrierName");
                if( (value == null) || (!value.equals(getCarrierName())) ) {
                    setCarrierName(((String) value));
                }
            }
            if( values.containsKey("PlannedDeliveryUTCDateTime") ) {
                final Object value = values.remove("PlannedDeliveryUTCDateTime");
                if( (value == null) || (!value.equals(getPlannedDeliveryUTCDateTime())) ) {
                    setPlannedDeliveryUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlannedOutOfYardUTCDateTime") ) {
                final Object value = values.remove("PlannedOutOfYardUTCDateTime");
                if( (value == null) || (!value.equals(getPlannedOutOfYardUTCDateTime())) ) {
                    setPlannedOutOfYardUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("IncotermsPart1") ) {
                final Object value = values.remove("IncotermsPart1");
                if( (value == null) || (!value.equals(getIncotermsPart1())) ) {
                    setIncotermsPart1(((String) value));
                }
            }
            if( values.containsKey("IncotermsPart2") ) {
                final Object value = values.remove("IncotermsPart2");
                if( (value == null) || (!value.equals(getIncotermsPart2())) ) {
                    setIncotermsPart2(((String) value));
                }
            }
            if( values.containsKey("Route") ) {
                final Object value = values.remove("Route");
                if( (value == null) || (!value.equals(getRoute())) ) {
                    setRoute(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("ShippingOffice") ) {
                final Object value = values.remove("ShippingOffice");
                if( (value == null) || (!value.equals(getShippingOffice())) ) {
                    setShippingOffice(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ShipToPartyDocumentAddress") ) {
                final Object value = (values).remove("to_ShipToPartyDocumentAddress");
                if( value instanceof Iterable ) {
                    if( toShipToPartyDocumentAddress == null ) {
                        toShipToPartyDocumentAddress = Lists.newArrayList();
                    } else {
                        toShipToPartyDocumentAddress = Lists.newArrayList(toShipToPartyDocumentAddress);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WhseDeliveryDocumentAddress entity;
                        if( toShipToPartyDocumentAddress.size() > i ) {
                            entity = toShipToPartyDocumentAddress.get(i);
                        } else {
                            entity = new WhseDeliveryDocumentAddress();
                            toShipToPartyDocumentAddress.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WhseOutboundDeliveryOrderItem") ) {
                final Object value = (values).remove("to_WhseOutboundDeliveryOrderItem");
                if( value instanceof Iterable ) {
                    if( toWhseOutboundDeliveryOrderItem == null ) {
                        toWhseOutboundDeliveryOrderItem = Lists.newArrayList();
                    } else {
                        toWhseOutboundDeliveryOrderItem = Lists.newArrayList(toWhseOutboundDeliveryOrderItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WhseOutboundDeliveryOrderItem entity;
                        if( toWhseOutboundDeliveryOrderItem.size() > i ) {
                            entity = toWhseOutboundDeliveryOrderItem.get(i);
                        } else {
                            entity = new WhseOutboundDeliveryOrderItem();
                            toWhseOutboundDeliveryOrderItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WhseOutboundDeliveryOrderHeadField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WhseOutboundDeliveryOrderHeadField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhseOutboundDeliveryOrderHeadField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhseOutboundDeliveryOrderHeadField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toShipToPartyDocumentAddress != null ) {
            (values).put("to_ShipToPartyDocumentAddress", toShipToPartyDocumentAddress);
        }
        if( toWhseOutboundDeliveryOrderItem != null ) {
            (values).put("to_WhseOutboundDeliveryOrderItem", toWhseOutboundDeliveryOrderItem);
        }
        return values;
    }

    /**
     * Fetches the <b>WhseDeliveryDocumentAddress</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ShipToPartyDocumentAddress</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WhseDeliveryDocumentAddress</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseDeliveryDocumentAddress> fetchShipToPartyDocumentAddress()
    {
        return fetchFieldAsList("to_ShipToPartyDocumentAddress", WhseDeliveryDocumentAddress.class);
    }

    /**
     * Retrieval of associated <b>WhseDeliveryDocumentAddress</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ShipToPartyDocumentAddress</b>.
     * <p>
     * If the navigation property <b>to_ShipToPartyDocumentAddress</b> of a queried <b>WhseOutboundDeliveryOrderHead</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseDeliveryDocumentAddress</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseDeliveryDocumentAddress> getShipToPartyDocumentAddressOrFetch()
    {
        if( toShipToPartyDocumentAddress == null ) {
            toShipToPartyDocumentAddress = fetchShipToPartyDocumentAddress();
        }
        return toShipToPartyDocumentAddress;
    }

    /**
     * Retrieval of associated <b>WhseDeliveryDocumentAddress</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ShipToPartyDocumentAddress</b>.
     * <p>
     * If the navigation property for an entity <b>WhseOutboundDeliveryOrderHead</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ShipToPartyDocumentAddress</b> is already loaded, the
     *         result will contain the <b>WhseDeliveryDocumentAddress</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WhseDeliveryDocumentAddress>> getShipToPartyDocumentAddressIfPresent()
    {
        return Option.of(toShipToPartyDocumentAddress);
    }

    /**
     * Overwrites the list of associated <b>WhseDeliveryDocumentAddress</b> entities for the loaded navigation property
     * <b>to_ShipToPartyDocumentAddress</b>.
     * <p>
     * If the navigation property <b>to_ShipToPartyDocumentAddress</b> of a queried <b>WhseOutboundDeliveryOrderHead</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WhseDeliveryDocumentAddress</b> entities.
     */
    public void setShipToPartyDocumentAddress( @Nonnull final List<WhseDeliveryDocumentAddress> value )
    {
        if( toShipToPartyDocumentAddress == null ) {
            toShipToPartyDocumentAddress = Lists.newArrayList();
        }
        toShipToPartyDocumentAddress.clear();
        toShipToPartyDocumentAddress.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WhseDeliveryDocumentAddress</b> entities. This corresponds to the
     * OData navigation property <b>to_ShipToPartyDocumentAddress</b>.
     * <p>
     * If the navigation property <b>to_ShipToPartyDocumentAddress</b> of a queried <b>WhseOutboundDeliveryOrderHead</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WhseDeliveryDocumentAddress</b> entities.
     */
    public void addShipToPartyDocumentAddress( WhseDeliveryDocumentAddress... entity )
    {
        if( toShipToPartyDocumentAddress == null ) {
            toShipToPartyDocumentAddress = Lists.newArrayList();
        }
        toShipToPartyDocumentAddress.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WhseOutboundDeliveryOrderItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WhseOutboundDeliveryOrderItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseOutboundDeliveryOrderItem> fetchWhseOutboundDeliveryOrderItem()
    {
        return fetchFieldAsList("to_WhseOutboundDeliveryOrderItem", WhseOutboundDeliveryOrderItem.class);
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderItem</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property <b>to_WhseOutboundDeliveryOrderItem</b> of a queried
     * <b>WhseOutboundDeliveryOrderHead</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseOutboundDeliveryOrderItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseOutboundDeliveryOrderItem> getWhseOutboundDeliveryOrderItemOrFetch()
    {
        if( toWhseOutboundDeliveryOrderItem == null ) {
            toWhseOutboundDeliveryOrderItem = fetchWhseOutboundDeliveryOrderItem();
        }
        return toWhseOutboundDeliveryOrderItem;
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderItem</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>WhseOutboundDeliveryOrderHead</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseOutboundDeliveryOrderItem</b> is already loaded, the
     *         result will contain the <b>WhseOutboundDeliveryOrderItem</b> entities. If not, an <code>Option</code>
     *         with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WhseOutboundDeliveryOrderItem>> getWhseOutboundDeliveryOrderItemIfPresent()
    {
        return Option.of(toWhseOutboundDeliveryOrderItem);
    }

    /**
     * Overwrites the list of associated <b>WhseOutboundDeliveryOrderItem</b> entities for the loaded navigation
     * property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property <b>to_WhseOutboundDeliveryOrderItem</b> of a queried
     * <b>WhseOutboundDeliveryOrderHead</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WhseOutboundDeliveryOrderItem</b> entities.
     */
    public void setWhseOutboundDeliveryOrderItem( @Nonnull final List<WhseOutboundDeliveryOrderItem> value )
    {
        if( toWhseOutboundDeliveryOrderItem == null ) {
            toWhseOutboundDeliveryOrderItem = Lists.newArrayList();
        }
        toWhseOutboundDeliveryOrderItem.clear();
        toWhseOutboundDeliveryOrderItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WhseOutboundDeliveryOrderItem</b> entities. This corresponds to the
     * OData navigation property <b>to_WhseOutboundDeliveryOrderItem</b>.
     * <p>
     * If the navigation property <b>to_WhseOutboundDeliveryOrderItem</b> of a queried
     * <b>WhseOutboundDeliveryOrderHead</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WhseOutboundDeliveryOrderItem</b> entities.
     */
    public void addWhseOutboundDeliveryOrderItem( WhseOutboundDeliveryOrderItem... entity )
    {
        if( toWhseOutboundDeliveryOrderItem == null ) {
            toWhseOutboundDeliveryOrderItem = Lists.newArrayList();
        }
        toWhseOutboundDeliveryOrderItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WhseOutboundDeliveryOrderHead instances.
     *
     */
    public final static class WhseOutboundDeliveryOrderHeadBuilder
    {

        private List<WhseDeliveryDocumentAddress> toShipToPartyDocumentAddress = Lists.newArrayList();
        private List<WhseOutboundDeliveryOrderItem> toWhseOutboundDeliveryOrderItem = Lists.newArrayList();

        private WhseOutboundDeliveryOrderHead.WhseOutboundDeliveryOrderHeadBuilder toShipToPartyDocumentAddress(
            final List<WhseDeliveryDocumentAddress> value )
        {
            toShipToPartyDocumentAddress.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ShipToPartyDocumentAddress</b> for <b>WhseOutboundDeliveryOrderHead</b> to multiple
         * <b>WhseDeliveryDocumentAddress</b>.
         *
         * @param value
         *            The WhseDeliveryDocumentAddresss to build this WhseOutboundDeliveryOrderHead with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseOutboundDeliveryOrderHead.WhseOutboundDeliveryOrderHeadBuilder shipToPartyDocumentAddress(
            WhseDeliveryDocumentAddress... value )
        {
            return toShipToPartyDocumentAddress(Lists.newArrayList(value));
        }

        private WhseOutboundDeliveryOrderHead.WhseOutboundDeliveryOrderHeadBuilder toWhseOutboundDeliveryOrderItem(
            final List<WhseOutboundDeliveryOrderItem> value )
        {
            toWhseOutboundDeliveryOrderItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WhseOutboundDeliveryOrderItem</b> for <b>WhseOutboundDeliveryOrderHead</b> to
         * multiple <b>WhseOutboundDeliveryOrderItem</b>.
         *
         * @param value
         *            The WhseOutboundDeliveryOrderItems to build this WhseOutboundDeliveryOrderHead with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseOutboundDeliveryOrderHead.WhseOutboundDeliveryOrderHeadBuilder whseOutboundDeliveryOrderItem(
            WhseOutboundDeliveryOrderItem... value )
        {
            return toWhseOutboundDeliveryOrderItem(Lists.newArrayList(value));
        }

    }

}
