/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseOutboundDeliveryOrderHeadSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
 * WhseOutboundDeliveryOrderHead} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class WhseOutboundDeliveryOrderHeadByKeyFluentHelper
    extends
    FluentHelperByKey<WhseOutboundDeliveryOrderHeadByKeyFluentHelper, WhseOutboundDeliveryOrderHead, WhseOutboundDeliveryOrderHeadSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     * WhseOutboundDeliveryOrderHead} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WhseOutboundDeliveryOrderHead}
     * @param servicePath
     *            Service path to be used to fetch a single {@code WhseOutboundDeliveryOrderHead}
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     */
    public WhseOutboundDeliveryOrderHeadByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String outboundDeliveryOrder )
    {
        super(servicePath, entityCollection);
        this.key.put("OutboundDeliveryOrder", outboundDeliveryOrder);
    }

    @Override
    @Nonnull
    protected Class<WhseOutboundDeliveryOrderHead> getEntityClass()
    {
        return WhseOutboundDeliveryOrderHead.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
