/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseOutboundDeliveryOrderItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseOutboundDeliveryOrderItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseOutboundDeliveryOrderItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseOutboundDeliveryOrderItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Outbound Delivery Order Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhseOutboundDeliveryOrderItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhseOutboundDeliveryOrderItem extends VdmEntity<WhseOutboundDeliveryOrderItem>
{

    /**
     * Selector for all available fields of WhseOutboundDeliveryOrderItem.
     *
     */
    public final static WhseOutboundDeliveryOrderItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "OutboundDeliveryOrder" )
    @JsonProperty( "OutboundDeliveryOrder" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrder" )
    private String outboundDeliveryOrder;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrder</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> OUTBOUND_DELIVERY_ORDER =
        new WhseOutboundDeliveryOrderItemField<String>("OutboundDeliveryOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItem</b>
     * </p>
     *
     * @return Item Number
     */
    @Key
    @SerializedName( "OutboundDeliveryOrderItem" )
    @JsonProperty( "OutboundDeliveryOrderItem" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrderItem" )
    private String outboundDeliveryOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrderItem</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> OUTBOUND_DELIVERY_ORDER_ITEM =
        new WhseOutboundDeliveryOrderItemField<String>("OutboundDeliveryOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> WAREHOUSE =
        new WhseOutboundDeliveryOrderItemField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @return Document Category
     */
    @SerializedName( "DeliveryCategory" )
    @JsonProperty( "DeliveryCategory" )
    @Nullable
    @ODataField( odataName = "DeliveryCategory" )
    private String deliveryCategory;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryCategory</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> DELIVERY_CATEGORY =
        new WhseOutboundDeliveryOrderItemField<String>("DeliveryCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OutbDeliveryOrderItemCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "OutbDeliveryOrderItemCategory" )
    @JsonProperty( "OutbDeliveryOrderItemCategory" )
    @Nullable
    @ODataField( odataName = "OutbDeliveryOrderItemCategory" )
    private String outbDeliveryOrderItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>OutbDeliveryOrderItemCategory</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> OUTB_DELIVERY_ORDER_ITEM_CATEGORY =
        new WhseOutboundDeliveryOrderItemField<String>("OutbDeliveryOrderItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItemType</b>
     * </p>
     *
     * @return Item Type
     */
    @SerializedName( "OutboundDeliveryOrderItemType" )
    @JsonProperty( "OutboundDeliveryOrderItemType" )
    @Nullable
    @ODataField( odataName = "OutboundDeliveryOrderItemType" )
    private String outboundDeliveryOrderItemType;
    /**
     * Use with available fluent helpers to apply the <b>OutboundDeliveryOrderItemType</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> OUTBOUND_DELIVERY_ORDER_ITEM_TYPE =
        new WhseOutboundDeliveryOrderItemField<String>("OutboundDeliveryOrderItemType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Character field of length 40
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> PRODUCT =
        new WhseOutboundDeliveryOrderItemField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductExternalID</b>
     * </p>
     *
     * @return Character field of length 40
     */
    @SerializedName( "ProductExternalID" )
    @JsonProperty( "ProductExternalID" )
    @Nullable
    @ODataField( odataName = "ProductExternalID" )
    private String productExternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProductExternalID</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> PRODUCT_EXTERNAL_ID =
        new WhseOutboundDeliveryOrderItemField<String>("ProductExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "ProductBatch" )
    @JsonProperty( "ProductBatch" )
    @Nullable
    @ODataField( odataName = "ProductBatch" )
    private String productBatch;
    /**
     * Use with available fluent helpers to apply the <b>ProductBatch</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> PRODUCT_BATCH =
        new WhseOutboundDeliveryOrderItemField<String>("ProductBatch");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ProductQuantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "ProductQuantity" )
    @JsonProperty( "ProductQuantity" )
    @Nullable
    @ODataField( odataName = "ProductQuantity" )
    private BigDecimal productQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProductQuantity</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<BigDecimal> PRODUCT_QUANTITY =
        new WhseOutboundDeliveryOrderItemField<BigDecimal>("ProductQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> QUANTITY_UNIT =
        new WhseOutboundDeliveryOrderItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingArea</b>
     * </p>
     *
     * @return Staging Area
     */
    @SerializedName( "StagingArea" )
    @JsonProperty( "StagingArea" )
    @Nullable
    @ODataField( odataName = "StagingArea" )
    private String stagingArea;
    /**
     * Use with available fluent helpers to apply the <b>StagingArea</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STAGING_AREA =
        new WhseOutboundDeliveryOrderItemField<String>("StagingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingAreaGroup</b>
     * </p>
     *
     * @return Staging Area Group
     */
    @SerializedName( "StagingAreaGroup" )
    @JsonProperty( "StagingAreaGroup" )
    @Nullable
    @ODataField( odataName = "StagingAreaGroup" )
    private String stagingAreaGroup;
    /**
     * Use with available fluent helpers to apply the <b>StagingAreaGroup</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STAGING_AREA_GROUP =
        new WhseOutboundDeliveryOrderItemField<String>("StagingAreaGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StagingBay</b>
     * </p>
     *
     * @return Staging Bay
     */
    @SerializedName( "StagingBay" )
    @JsonProperty( "StagingBay" )
    @Nullable
    @ODataField( odataName = "StagingBay" )
    private String stagingBay;
    /**
     * Use with available fluent helpers to apply the <b>StagingBay</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STAGING_BAY =
        new WhseOutboundDeliveryOrderItemField<String>("StagingBay");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "GoodsIssueStatus" )
    @JsonProperty( "GoodsIssueStatus" )
    @Nullable
    @ODataField( odataName = "GoodsIssueStatus" )
    private String goodsIssueStatus;
    /**
     * Use with available fluent helpers to apply the <b>GoodsIssueStatus</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> GOODS_ISSUE_STATUS =
        new WhseOutboundDeliveryOrderItemField<String>("GoodsIssueStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPickingStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "PlannedPickingStatus" )
    @JsonProperty( "PlannedPickingStatus" )
    @Nullable
    @ODataField( odataName = "PlannedPickingStatus" )
    private String plannedPickingStatus;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPickingStatus</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> PLANNED_PICKING_STATUS =
        new WhseOutboundDeliveryOrderItemField<String>("PlannedPickingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "PickingStatus" )
    @JsonProperty( "PickingStatus" )
    @Nullable
    @ODataField( odataName = "PickingStatus" )
    private String pickingStatus;
    /**
     * Use with available fluent helpers to apply the <b>PickingStatus</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> PICKING_STATUS =
        new WhseOutboundDeliveryOrderItemField<String>("PickingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CompletionStatus</b>
     * </p>
     *
     * @return Status Value
     */
    @SerializedName( "CompletionStatus" )
    @JsonProperty( "CompletionStatus" )
    @Nullable
    @ODataField( odataName = "CompletionStatus" )
    private String completionStatus;
    /**
     * Use with available fluent helpers to apply the <b>CompletionStatus</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> COMPLETION_STATUS =
        new WhseOutboundDeliveryOrderItemField<String>("CompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @return Warehouse Process Type
     */
    @SerializedName( "WarehouseProcessType" )
    @JsonProperty( "WarehouseProcessType" )
    @Nullable
    @ODataField( odataName = "WarehouseProcessType" )
    private String warehouseProcessType;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseProcessType</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> WAREHOUSE_PROCESS_TYPE =
        new WhseOutboundDeliveryOrderItemField<String>("WarehouseProcessType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Condition
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> SHIPPING_CONDITION =
        new WhseOutboundDeliveryOrderItemField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementBin</b>
     * </p>
     *
     * @return Storage Bin of Goods Movement Posting
     */
    @SerializedName( "GoodsMovementBin" )
    @JsonProperty( "GoodsMovementBin" )
    @Nullable
    @ODataField( odataName = "GoodsMovementBin" )
    private String goodsMovementBin;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementBin</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> GOODS_MOVEMENT_BIN =
        new WhseOutboundDeliveryOrderItemField<String>("GoodsMovementBin");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area (PSA)
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> PRODUCTION_SUPPLY_AREA =
        new WhseOutboundDeliveryOrderItemField<String>("ProductionSupplyArea");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new WhseOutboundDeliveryOrderItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STORAGE_TYPE =
        new WhseOutboundDeliveryOrderItemField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageSection</b>
     * </p>
     *
     * @return Storage Section
     */
    @SerializedName( "StorageSection" )
    @JsonProperty( "StorageSection" )
    @Nullable
    @ODataField( odataName = "StorageSection" )
    private String storageSection;
    /**
     * Use with available fluent helpers to apply the <b>StorageSection</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STORAGE_SECTION =
        new WhseOutboundDeliveryOrderItemField<String>("StorageSection");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndGoodsIssueStartUTCDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "PlndGoodsIssueStartUTCDateTime" )
    @JsonProperty( "PlndGoodsIssueStartUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlndGoodsIssueStartUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plndGoodsIssueStartUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlndGoodsIssueStartUTCDateTime</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<ZonedDateTime> PLND_GOODS_ISSUE_START_UTC_DATE_TIME =
        new WhseOutboundDeliveryOrderItemField<ZonedDateTime>("PlndGoodsIssueStartUTCDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActlGoodsIssueStartUTCDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ActlGoodsIssueStartUTCDateTime" )
    @JsonProperty( "ActlGoodsIssueStartUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ActlGoodsIssueStartUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime actlGoodsIssueStartUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ActlGoodsIssueStartUTCDateTime</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<ZonedDateTime> ACTL_GOODS_ISSUE_START_UTC_DATE_TIME =
        new WhseOutboundDeliveryOrderItemField<ZonedDateTime>("ActlGoodsIssueStartUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RouteSchedule</b>
     * </p>
     *
     * @return Departure Calendar/Route Schedule
     */
    @SerializedName( "RouteSchedule" )
    @JsonProperty( "RouteSchedule" )
    @Nullable
    @ODataField( odataName = "RouteSchedule" )
    private String routeSchedule;
    /**
     * Use with available fluent helpers to apply the <b>RouteSchedule</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> ROUTE_SCHEDULE =
        new WhseOutboundDeliveryOrderItemField<String>("RouteSchedule");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @return Party Entitled to Dispose
     */
    @SerializedName( "EntitledToDisposeParty" )
    @JsonProperty( "EntitledToDisposeParty" )
    @Nullable
    @ODataField( odataName = "EntitledToDisposeParty" )
    private String entitledToDisposeParty;
    /**
     * Use with available fluent helpers to apply the <b>EntitledToDisposeParty</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> ENTITLED_TO_DISPOSE_PARTY =
        new WhseOutboundDeliveryOrderItemField<String>("EntitledToDisposeParty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @return Stock Usage
     */
    @SerializedName( "StockUsage" )
    @JsonProperty( "StockUsage" )
    @Nullable
    @ODataField( odataName = "StockUsage" )
    private String stockUsage;
    /**
     * Use with available fluent helpers to apply the <b>StockUsage</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STOCK_USAGE =
        new WhseOutboundDeliveryOrderItemField<String>("StockUsage");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStockCategory</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "WarehouseStockCategory" )
    @JsonProperty( "WarehouseStockCategory" )
    @Nullable
    @ODataField( odataName = "WarehouseStockCategory" )
    private String warehouseStockCategory;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStockCategory</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> WAREHOUSE_STOCK_CATEGORY =
        new WhseOutboundDeliveryOrderItemField<String>("WarehouseStockCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @return Character Field with Length 10
     */
    @SerializedName( "StockOwner" )
    @JsonProperty( "StockOwner" )
    @Nullable
    @ODataField( odataName = "StockOwner" )
    private String stockOwner;
    /**
     * Use with available fluent helpers to apply the <b>StockOwner</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STOCK_OWNER =
        new WhseOutboundDeliveryOrderItemField<String>("StockOwner");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItemStockTypeDetnCode</b>
     * </p>
     *
     * @return Value Determination Indicator
     */
    @SerializedName( "DeliveryItemStockTypeDetnCode" )
    @JsonProperty( "DeliveryItemStockTypeDetnCode" )
    @Nullable
    @ODataField( odataName = "DeliveryItemStockTypeDetnCode" )
    private String deliveryItemStockTypeDetnCode;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryItemStockTypeDetnCode</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> DELIVERY_ITEM_STOCK_TYPE_DETN_CODE =
        new WhseOutboundDeliveryOrderItemField<String>("DeliveryItemStockTypeDetnCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @return Special Reference Stock Type
     */
    @SerializedName( "StockDocumentCategory" )
    @JsonProperty( "StockDocumentCategory" )
    @Nullable
    @ODataField( odataName = "StockDocumentCategory" )
    private String stockDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentCategory</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STOCK_DOCUMENT_CATEGORY =
        new WhseOutboundDeliveryOrderItemField<String>("StockDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @return Reference Document for Special Reference Stock
     */
    @SerializedName( "StockDocumentNumber" )
    @JsonProperty( "StockDocumentNumber" )
    @Nullable
    @ODataField( odataName = "StockDocumentNumber" )
    private String stockDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentNumber</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STOCK_DOCUMENT_NUMBER =
        new WhseOutboundDeliveryOrderItemField<String>("StockDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @return Sales Order Item for Sales Order Stock
     */
    @SerializedName( "StockItemNumber" )
    @JsonProperty( "StockItemNumber" )
    @Nullable
    @ODataField( odataName = "StockItemNumber" )
    private String stockItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockItemNumber</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> STOCK_ITEM_NUMBER =
        new WhseOutboundDeliveryOrderItemField<String>("StockItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @return Country/Region of Origin
     */
    @SerializedName( "CountryOfOrigin" )
    @JsonProperty( "CountryOfOrigin" )
    @Nullable
    @ODataField( odataName = "CountryOfOrigin" )
    private String countryOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CountryOfOrigin</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> COUNTRY_OF_ORIGIN =
        new WhseOutboundDeliveryOrderItemField<String>("CountryOfOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> WBS_ELEMENT_INTERNAL_ID =
        new WhseOutboundDeliveryOrderItemField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new WhseOutboundDeliveryOrderItemField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "SpecialStockIdfgSalesOrder" )
    @JsonProperty( "SpecialStockIdfgSalesOrder" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrder" )
    private String specialStockIdfgSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrder</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> SPECIAL_STOCK_IDFG_SALES_ORDER =
        new WhseOutboundDeliveryOrderItemField<String>("SpecialStockIdfgSalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @return The specialStockIdfgSalesOrderItem contained in this entity.
     */
    @SerializedName( "SpecialStockIdfgSalesOrderItem" )
    @JsonProperty( "SpecialStockIdfgSalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrderItem" )
    private String specialStockIdfgSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrderItem</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM =
        new WhseOutboundDeliveryOrderItemField<String>("SpecialStockIdfgSalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> SALES_ORDER =
        new WhseOutboundDeliveryOrderItemField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Reference Item Number
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> SALES_ORDER_ITEM =
        new WhseOutboundDeliveryOrderItemField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemField<String> MANUFACTURING_ORDER =
        new WhseOutboundDeliveryOrderItemField<String>("ManufacturingOrder");
    /**
     * Navigation property <b>to_WhseOutboundDeliveryOrderHead</b> for <b>WhseOutboundDeliveryOrderItem</b> to single
     * <b>WhseOutboundDeliveryOrderHead</b>.
     *
     */
    @SerializedName( "to_WhseOutboundDeliveryOrderHead" )
    @JsonProperty( "to_WhseOutboundDeliveryOrderHead" )
    @ODataField( odataName = "to_WhseOutboundDeliveryOrderHead" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhseOutboundDeliveryOrderHead toWhseOutboundDeliveryOrderHead;
    /**
     * Navigation property <b>to_SoldToPartyDocumentAddress</b> for <b>WhseOutboundDeliveryOrderItem</b> to single
     * <b>WhseDeliveryDocumentAddress</b>.
     *
     */
    @SerializedName( "to_SoldToPartyDocumentAddress" )
    @JsonProperty( "to_SoldToPartyDocumentAddress" )
    @ODataField( odataName = "to_SoldToPartyDocumentAddress" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhseDeliveryDocumentAddress toSoldToPartyDocumentAddress;
    /**
     * Navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b> for <b>WhseOutboundDeliveryOrderItem</b> to multiple
     * <b>WhseOutbDelivOrderItemSerialNo</b>.
     *
     */
    @SerializedName( "to_WhseOutbDelivOrdItemSerialNo" )
    @JsonProperty( "to_WhseOutbDelivOrdItemSerialNo" )
    @ODataField( odataName = "to_WhseOutbDelivOrdItemSerialNo" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WhseOutbDelivOrderItemSerialNo> toWhseOutbDelivOrdItemSerialNo;
    /**
     * Use with available fluent helpers to apply the <b>to_WhseOutboundDeliveryOrderHead</b> navigation property to
     * query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemOneToOneLink<WhseOutboundDeliveryOrderHead> TO_WHSE_OUTBOUND_DELIVERY_ORDER_HEAD =
        new WhseOutboundDeliveryOrderItemOneToOneLink<WhseOutboundDeliveryOrderHead>(
            "to_WhseOutboundDeliveryOrderHead");
    /**
     * Use with available fluent helpers to apply the <b>to_SoldToPartyDocumentAddress</b> navigation property to query
     * operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemOneToOneLink<WhseDeliveryDocumentAddress> TO_SOLD_TO_PARTY_DOCUMENT_ADDRESS =
        new WhseOutboundDeliveryOrderItemOneToOneLink<WhseDeliveryDocumentAddress>("to_SoldToPartyDocumentAddress");
    /**
     * Use with available fluent helpers to apply the <b>to_WhseOutbDelivOrdItemSerialNo</b> navigation property to
     * query operations.
     *
     */
    public final static WhseOutboundDeliveryOrderItemLink<WhseOutbDelivOrderItemSerialNo> TO_WHSE_OUTB_DELIV_ORD_ITEM_SERIAL_NO =
        new WhseOutboundDeliveryOrderItemLink<WhseOutbDelivOrderItemSerialNo>("to_WhseOutbDelivOrdItemSerialNo");

    @Nonnull
    @Override
    public Class<WhseOutboundDeliveryOrderItem> getType()
    {
        return WhseOutboundDeliveryOrderItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     */
    public void setOutboundDeliveryOrder( @Nullable final String outboundDeliveryOrder )
    {
        rememberChangedField("OutboundDeliveryOrder", this.outboundDeliveryOrder);
        this.outboundDeliveryOrder = outboundDeliveryOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItem</b>
     * </p>
     *
     * @param outboundDeliveryOrderItem
     *            Item Number
     */
    public void setOutboundDeliveryOrderItem( @Nullable final String outboundDeliveryOrderItem )
    {
        rememberChangedField("OutboundDeliveryOrderItem", this.outboundDeliveryOrderItem);
        this.outboundDeliveryOrderItem = outboundDeliveryOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @param deliveryCategory
     *            Document Category
     */
    public void setDeliveryCategory( @Nullable final String deliveryCategory )
    {
        rememberChangedField("DeliveryCategory", this.deliveryCategory);
        this.deliveryCategory = deliveryCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OutbDeliveryOrderItemCategory</b>
     * </p>
     *
     * @param outbDeliveryOrderItemCategory
     *            Item Category
     */
    public void setOutbDeliveryOrderItemCategory( @Nullable final String outbDeliveryOrderItemCategory )
    {
        rememberChangedField("OutbDeliveryOrderItemCategory", this.outbDeliveryOrderItemCategory);
        this.outbDeliveryOrderItemCategory = outbDeliveryOrderItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OutboundDeliveryOrderItemType</b>
     * </p>
     *
     * @param outboundDeliveryOrderItemType
     *            Item Type
     */
    public void setOutboundDeliveryOrderItemType( @Nullable final String outboundDeliveryOrderItemType )
    {
        rememberChangedField("OutboundDeliveryOrderItemType", this.outboundDeliveryOrderItemType);
        this.outboundDeliveryOrderItemType = outboundDeliveryOrderItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Character field of length 40
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductExternalID</b>
     * </p>
     *
     * @param productExternalID
     *            Character field of length 40
     */
    public void setProductExternalID( @Nullable final String productExternalID )
    {
        rememberChangedField("ProductExternalID", this.productExternalID);
        this.productExternalID = productExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatch</b>
     * </p>
     *
     * @param productBatch
     *            Batch Number
     */
    public void setProductBatch( @Nullable final String productBatch )
    {
        rememberChangedField("ProductBatch", this.productBatch);
        this.productBatch = productBatch;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ProductQuantity</b>
     * </p>
     *
     * @param productQuantity
     *            Quantity
     */
    public void setProductQuantity( @Nullable final BigDecimal productQuantity )
    {
        rememberChangedField("ProductQuantity", this.productQuantity);
        this.productQuantity = productQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Base Unit of Measure
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingArea</b>
     * </p>
     *
     * @param stagingArea
     *            Staging Area
     */
    public void setStagingArea( @Nullable final String stagingArea )
    {
        rememberChangedField("StagingArea", this.stagingArea);
        this.stagingArea = stagingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StagingAreaGroup</b>
     * </p>
     *
     * @param stagingAreaGroup
     *            Staging Area Group
     */
    public void setStagingAreaGroup( @Nullable final String stagingAreaGroup )
    {
        rememberChangedField("StagingAreaGroup", this.stagingAreaGroup);
        this.stagingAreaGroup = stagingAreaGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StagingBay</b>
     * </p>
     *
     * @param stagingBay
     *            Staging Bay
     */
    public void setStagingBay( @Nullable final String stagingBay )
    {
        rememberChangedField("StagingBay", this.stagingBay);
        this.stagingBay = stagingBay;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueStatus</b>
     * </p>
     *
     * @param goodsIssueStatus
     *            Status Value
     */
    public void setGoodsIssueStatus( @Nullable final String goodsIssueStatus )
    {
        rememberChangedField("GoodsIssueStatus", this.goodsIssueStatus);
        this.goodsIssueStatus = goodsIssueStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPickingStatus</b>
     * </p>
     *
     * @param plannedPickingStatus
     *            Status Value
     */
    public void setPlannedPickingStatus( @Nullable final String plannedPickingStatus )
    {
        rememberChangedField("PlannedPickingStatus", this.plannedPickingStatus);
        this.plannedPickingStatus = plannedPickingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingStatus</b>
     * </p>
     *
     * @param pickingStatus
     *            Status Value
     */
    public void setPickingStatus( @Nullable final String pickingStatus )
    {
        rememberChangedField("PickingStatus", this.pickingStatus);
        this.pickingStatus = pickingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CompletionStatus</b>
     * </p>
     *
     * @param completionStatus
     *            Status Value
     */
    public void setCompletionStatus( @Nullable final String completionStatus )
    {
        rememberChangedField("CompletionStatus", this.completionStatus);
        this.completionStatus = completionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @param warehouseProcessType
     *            Warehouse Process Type
     */
    public void setWarehouseProcessType( @Nullable final String warehouseProcessType )
    {
        rememberChangedField("WarehouseProcessType", this.warehouseProcessType);
        this.warehouseProcessType = warehouseProcessType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Condition
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementBin</b>
     * </p>
     *
     * @param goodsMovementBin
     *            Storage Bin of Goods Movement Posting
     */
    public void setGoodsMovementBin( @Nullable final String goodsMovementBin )
    {
        rememberChangedField("GoodsMovementBin", this.goodsMovementBin);
        this.goodsMovementBin = goodsMovementBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area (PSA)
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageSection</b>
     * </p>
     *
     * @param storageSection
     *            Storage Section
     */
    public void setStorageSection( @Nullable final String storageSection )
    {
        rememberChangedField("StorageSection", this.storageSection);
        this.storageSection = storageSection;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndGoodsIssueStartUTCDateTime</b>
     * </p>
     *
     * @param plndGoodsIssueStartUTCDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setPlndGoodsIssueStartUTCDateTime( @Nullable final ZonedDateTime plndGoodsIssueStartUTCDateTime )
    {
        rememberChangedField("PlndGoodsIssueStartUTCDateTime", this.plndGoodsIssueStartUTCDateTime);
        this.plndGoodsIssueStartUTCDateTime = plndGoodsIssueStartUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActlGoodsIssueStartUTCDateTime</b>
     * </p>
     *
     * @param actlGoodsIssueStartUTCDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setActlGoodsIssueStartUTCDateTime( @Nullable final ZonedDateTime actlGoodsIssueStartUTCDateTime )
    {
        rememberChangedField("ActlGoodsIssueStartUTCDateTime", this.actlGoodsIssueStartUTCDateTime);
        this.actlGoodsIssueStartUTCDateTime = actlGoodsIssueStartUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RouteSchedule</b>
     * </p>
     *
     * @param routeSchedule
     *            Departure Calendar/Route Schedule
     */
    public void setRouteSchedule( @Nullable final String routeSchedule )
    {
        rememberChangedField("RouteSchedule", this.routeSchedule);
        this.routeSchedule = routeSchedule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @param entitledToDisposeParty
     *            Party Entitled to Dispose
     */
    public void setEntitledToDisposeParty( @Nullable final String entitledToDisposeParty )
    {
        rememberChangedField("EntitledToDisposeParty", this.entitledToDisposeParty);
        this.entitledToDisposeParty = entitledToDisposeParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @param stockUsage
     *            Stock Usage
     */
    public void setStockUsage( @Nullable final String stockUsage )
    {
        rememberChangedField("StockUsage", this.stockUsage);
        this.stockUsage = stockUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStockCategory</b>
     * </p>
     *
     * @param warehouseStockCategory
     *            Stock Type
     */
    public void setWarehouseStockCategory( @Nullable final String warehouseStockCategory )
    {
        rememberChangedField("WarehouseStockCategory", this.warehouseStockCategory);
        this.warehouseStockCategory = warehouseStockCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @param stockOwner
     *            Character Field with Length 10
     */
    public void setStockOwner( @Nullable final String stockOwner )
    {
        rememberChangedField("StockOwner", this.stockOwner);
        this.stockOwner = stockOwner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItemStockTypeDetnCode</b>
     * </p>
     *
     * @param deliveryItemStockTypeDetnCode
     *            Value Determination Indicator
     */
    public void setDeliveryItemStockTypeDetnCode( @Nullable final String deliveryItemStockTypeDetnCode )
    {
        rememberChangedField("DeliveryItemStockTypeDetnCode", this.deliveryItemStockTypeDetnCode);
        this.deliveryItemStockTypeDetnCode = deliveryItemStockTypeDetnCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @param stockDocumentCategory
     *            Special Reference Stock Type
     */
    public void setStockDocumentCategory( @Nullable final String stockDocumentCategory )
    {
        rememberChangedField("StockDocumentCategory", this.stockDocumentCategory);
        this.stockDocumentCategory = stockDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @param stockDocumentNumber
     *            Reference Document for Special Reference Stock
     */
    public void setStockDocumentNumber( @Nullable final String stockDocumentNumber )
    {
        rememberChangedField("StockDocumentNumber", this.stockDocumentNumber);
        this.stockDocumentNumber = stockDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @param stockItemNumber
     *            Sales Order Item for Sales Order Stock
     */
    public void setStockItemNumber( @Nullable final String stockItemNumber )
    {
        rememberChangedField("StockItemNumber", this.stockItemNumber);
        this.stockItemNumber = stockItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @param countryOfOrigin
     *            Country/Region of Origin
     */
    public void setCountryOfOrigin( @Nullable final String countryOfOrigin )
    {
        rememberChangedField("CountryOfOrigin", this.countryOfOrigin);
        this.countryOfOrigin = countryOfOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrder
     *            Reference Document Number
     */
    public void setSpecialStockIdfgSalesOrder( @Nullable final String specialStockIdfgSalesOrder )
    {
        rememberChangedField("SpecialStockIdfgSalesOrder", this.specialStockIdfgSalesOrder);
        this.specialStockIdfgSalesOrder = specialStockIdfgSalesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrderItem
     *            The specialStockIdfgSalesOrderItem to set.
     */
    public void setSpecialStockIdfgSalesOrderItem( @Nullable final String specialStockIdfgSalesOrderItem )
    {
        rememberChangedField("SpecialStockIdfgSalesOrderItem", this.specialStockIdfgSalesOrderItem);
        this.specialStockIdfgSalesOrderItem = specialStockIdfgSalesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Reference Document Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Reference Item Number
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Reference Document Number
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhseOutboundDeliveryOrderItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        result.put("OutboundDeliveryOrderItem", getOutboundDeliveryOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OutboundDeliveryOrder", getOutboundDeliveryOrder());
        values.put("OutboundDeliveryOrderItem", getOutboundDeliveryOrderItem());
        values.put("Warehouse", getWarehouse());
        values.put("DeliveryCategory", getDeliveryCategory());
        values.put("OutbDeliveryOrderItemCategory", getOutbDeliveryOrderItemCategory());
        values.put("OutboundDeliveryOrderItemType", getOutboundDeliveryOrderItemType());
        values.put("Product", getProduct());
        values.put("ProductExternalID", getProductExternalID());
        values.put("ProductBatch", getProductBatch());
        values.put("ProductQuantity", getProductQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("StagingArea", getStagingArea());
        values.put("StagingAreaGroup", getStagingAreaGroup());
        values.put("StagingBay", getStagingBay());
        values.put("GoodsIssueStatus", getGoodsIssueStatus());
        values.put("PlannedPickingStatus", getPlannedPickingStatus());
        values.put("PickingStatus", getPickingStatus());
        values.put("CompletionStatus", getCompletionStatus());
        values.put("WarehouseProcessType", getWarehouseProcessType());
        values.put("ShippingCondition", getShippingCondition());
        values.put("GoodsMovementBin", getGoodsMovementBin());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("StorageType", getStorageType());
        values.put("StorageSection", getStorageSection());
        values.put("PlndGoodsIssueStartUTCDateTime", getPlndGoodsIssueStartUTCDateTime());
        values.put("ActlGoodsIssueStartUTCDateTime", getActlGoodsIssueStartUTCDateTime());
        values.put("RouteSchedule", getRouteSchedule());
        values.put("EntitledToDisposeParty", getEntitledToDisposeParty());
        values.put("StockUsage", getStockUsage());
        values.put("WarehouseStockCategory", getWarehouseStockCategory());
        values.put("StockOwner", getStockOwner());
        values.put("DeliveryItemStockTypeDetnCode", getDeliveryItemStockTypeDetnCode());
        values.put("StockDocumentCategory", getStockDocumentCategory());
        values.put("StockDocumentNumber", getStockDocumentNumber());
        values.put("StockItemNumber", getStockItemNumber());
        values.put("CountryOfOrigin", getCountryOfOrigin());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("SpecialStockIdfgSalesOrder", getSpecialStockIdfgSalesOrder());
        values.put("SpecialStockIdfgSalesOrderItem", getSpecialStockIdfgSalesOrderItem());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("ManufacturingOrder", getManufacturingOrder());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OutboundDeliveryOrder") ) {
                final Object value = values.remove("OutboundDeliveryOrder");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrder())) ) {
                    setOutboundDeliveryOrder(((String) value));
                }
            }
            if( values.containsKey("OutboundDeliveryOrderItem") ) {
                final Object value = values.remove("OutboundDeliveryOrderItem");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrderItem())) ) {
                    setOutboundDeliveryOrderItem(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("DeliveryCategory") ) {
                final Object value = values.remove("DeliveryCategory");
                if( (value == null) || (!value.equals(getDeliveryCategory())) ) {
                    setDeliveryCategory(((String) value));
                }
            }
            if( values.containsKey("OutbDeliveryOrderItemCategory") ) {
                final Object value = values.remove("OutbDeliveryOrderItemCategory");
                if( (value == null) || (!value.equals(getOutbDeliveryOrderItemCategory())) ) {
                    setOutbDeliveryOrderItemCategory(((String) value));
                }
            }
            if( values.containsKey("OutboundDeliveryOrderItemType") ) {
                final Object value = values.remove("OutboundDeliveryOrderItemType");
                if( (value == null) || (!value.equals(getOutboundDeliveryOrderItemType())) ) {
                    setOutboundDeliveryOrderItemType(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ProductExternalID") ) {
                final Object value = values.remove("ProductExternalID");
                if( (value == null) || (!value.equals(getProductExternalID())) ) {
                    setProductExternalID(((String) value));
                }
            }
            if( values.containsKey("ProductBatch") ) {
                final Object value = values.remove("ProductBatch");
                if( (value == null) || (!value.equals(getProductBatch())) ) {
                    setProductBatch(((String) value));
                }
            }
            if( values.containsKey("ProductQuantity") ) {
                final Object value = values.remove("ProductQuantity");
                if( (value == null) || (!value.equals(getProductQuantity())) ) {
                    setProductQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("StagingArea") ) {
                final Object value = values.remove("StagingArea");
                if( (value == null) || (!value.equals(getStagingArea())) ) {
                    setStagingArea(((String) value));
                }
            }
            if( values.containsKey("StagingAreaGroup") ) {
                final Object value = values.remove("StagingAreaGroup");
                if( (value == null) || (!value.equals(getStagingAreaGroup())) ) {
                    setStagingAreaGroup(((String) value));
                }
            }
            if( values.containsKey("StagingBay") ) {
                final Object value = values.remove("StagingBay");
                if( (value == null) || (!value.equals(getStagingBay())) ) {
                    setStagingBay(((String) value));
                }
            }
            if( values.containsKey("GoodsIssueStatus") ) {
                final Object value = values.remove("GoodsIssueStatus");
                if( (value == null) || (!value.equals(getGoodsIssueStatus())) ) {
                    setGoodsIssueStatus(((String) value));
                }
            }
            if( values.containsKey("PlannedPickingStatus") ) {
                final Object value = values.remove("PlannedPickingStatus");
                if( (value == null) || (!value.equals(getPlannedPickingStatus())) ) {
                    setPlannedPickingStatus(((String) value));
                }
            }
            if( values.containsKey("PickingStatus") ) {
                final Object value = values.remove("PickingStatus");
                if( (value == null) || (!value.equals(getPickingStatus())) ) {
                    setPickingStatus(((String) value));
                }
            }
            if( values.containsKey("CompletionStatus") ) {
                final Object value = values.remove("CompletionStatus");
                if( (value == null) || (!value.equals(getCompletionStatus())) ) {
                    setCompletionStatus(((String) value));
                }
            }
            if( values.containsKey("WarehouseProcessType") ) {
                final Object value = values.remove("WarehouseProcessType");
                if( (value == null) || (!value.equals(getWarehouseProcessType())) ) {
                    setWarehouseProcessType(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementBin") ) {
                final Object value = values.remove("GoodsMovementBin");
                if( (value == null) || (!value.equals(getGoodsMovementBin())) ) {
                    setGoodsMovementBin(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("StorageSection") ) {
                final Object value = values.remove("StorageSection");
                if( (value == null) || (!value.equals(getStorageSection())) ) {
                    setStorageSection(((String) value));
                }
            }
            if( values.containsKey("PlndGoodsIssueStartUTCDateTime") ) {
                final Object value = values.remove("PlndGoodsIssueStartUTCDateTime");
                if( (value == null) || (!value.equals(getPlndGoodsIssueStartUTCDateTime())) ) {
                    setPlndGoodsIssueStartUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ActlGoodsIssueStartUTCDateTime") ) {
                final Object value = values.remove("ActlGoodsIssueStartUTCDateTime");
                if( (value == null) || (!value.equals(getActlGoodsIssueStartUTCDateTime())) ) {
                    setActlGoodsIssueStartUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RouteSchedule") ) {
                final Object value = values.remove("RouteSchedule");
                if( (value == null) || (!value.equals(getRouteSchedule())) ) {
                    setRouteSchedule(((String) value));
                }
            }
            if( values.containsKey("EntitledToDisposeParty") ) {
                final Object value = values.remove("EntitledToDisposeParty");
                if( (value == null) || (!value.equals(getEntitledToDisposeParty())) ) {
                    setEntitledToDisposeParty(((String) value));
                }
            }
            if( values.containsKey("StockUsage") ) {
                final Object value = values.remove("StockUsage");
                if( (value == null) || (!value.equals(getStockUsage())) ) {
                    setStockUsage(((String) value));
                }
            }
            if( values.containsKey("WarehouseStockCategory") ) {
                final Object value = values.remove("WarehouseStockCategory");
                if( (value == null) || (!value.equals(getWarehouseStockCategory())) ) {
                    setWarehouseStockCategory(((String) value));
                }
            }
            if( values.containsKey("StockOwner") ) {
                final Object value = values.remove("StockOwner");
                if( (value == null) || (!value.equals(getStockOwner())) ) {
                    setStockOwner(((String) value));
                }
            }
            if( values.containsKey("DeliveryItemStockTypeDetnCode") ) {
                final Object value = values.remove("DeliveryItemStockTypeDetnCode");
                if( (value == null) || (!value.equals(getDeliveryItemStockTypeDetnCode())) ) {
                    setDeliveryItemStockTypeDetnCode(((String) value));
                }
            }
            if( values.containsKey("StockDocumentCategory") ) {
                final Object value = values.remove("StockDocumentCategory");
                if( (value == null) || (!value.equals(getStockDocumentCategory())) ) {
                    setStockDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("StockDocumentNumber") ) {
                final Object value = values.remove("StockDocumentNumber");
                if( (value == null) || (!value.equals(getStockDocumentNumber())) ) {
                    setStockDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("StockItemNumber") ) {
                final Object value = values.remove("StockItemNumber");
                if( (value == null) || (!value.equals(getStockItemNumber())) ) {
                    setStockItemNumber(((String) value));
                }
            }
            if( values.containsKey("CountryOfOrigin") ) {
                final Object value = values.remove("CountryOfOrigin");
                if( (value == null) || (!value.equals(getCountryOfOrigin())) ) {
                    setCountryOfOrigin(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrder") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrder");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrder())) ) {
                    setSpecialStockIdfgSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrderItem") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrderItem");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrderItem())) ) {
                    setSpecialStockIdfgSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhseOutboundDeliveryOrderHead") ) {
                final Object value = (values).remove("to_WhseOutboundDeliveryOrderHead");
                if( value instanceof Map ) {
                    if( toWhseOutboundDeliveryOrderHead == null ) {
                        toWhseOutboundDeliveryOrderHead = new WhseOutboundDeliveryOrderHead();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWhseOutboundDeliveryOrderHead.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SoldToPartyDocumentAddress") ) {
                final Object value = (values).remove("to_SoldToPartyDocumentAddress");
                if( value instanceof Map ) {
                    if( toSoldToPartyDocumentAddress == null ) {
                        toSoldToPartyDocumentAddress = new WhseDeliveryDocumentAddress();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSoldToPartyDocumentAddress.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_WhseOutbDelivOrdItemSerialNo") ) {
                final Object value = (values).remove("to_WhseOutbDelivOrdItemSerialNo");
                if( value instanceof Iterable ) {
                    if( toWhseOutbDelivOrdItemSerialNo == null ) {
                        toWhseOutbDelivOrdItemSerialNo = Lists.newArrayList();
                    } else {
                        toWhseOutbDelivOrdItemSerialNo = Lists.newArrayList(toWhseOutbDelivOrdItemSerialNo);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WhseOutbDelivOrderItemSerialNo entity;
                        if( toWhseOutbDelivOrdItemSerialNo.size() > i ) {
                            entity = toWhseOutbDelivOrdItemSerialNo.get(i);
                        } else {
                            entity = new WhseOutbDelivOrderItemSerialNo();
                            toWhseOutbDelivOrdItemSerialNo.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WhseOutboundDeliveryOrderItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WhseOutboundDeliveryOrderItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhseOutboundDeliveryOrderItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhseOutboundDeliveryOrderItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhseOutboundDeliveryOrderHead != null ) {
            (values).put("to_WhseOutboundDeliveryOrderHead", toWhseOutboundDeliveryOrderHead);
        }
        if( toSoldToPartyDocumentAddress != null ) {
            (values).put("to_SoldToPartyDocumentAddress", toSoldToPartyDocumentAddress);
        }
        if( toWhseOutbDelivOrdItemSerialNo != null ) {
            (values).put("to_WhseOutbDelivOrdItemSerialNo", toWhseOutbDelivOrdItemSerialNo);
        }
        return values;
    }

    /**
     * Fetches the <b>WhseOutboundDeliveryOrderHead</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhseOutboundDeliveryOrderHead</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhseOutboundDeliveryOrderHead</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderHead fetchWhseOutboundDeliveryOrderHead()
    {
        return fetchFieldAsSingle("to_WhseOutboundDeliveryOrderHead", WhseOutboundDeliveryOrderHead.class);
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderHead</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderHead</b>.
     * <p>
     * If the navigation property <b>to_WhseOutboundDeliveryOrderHead</b> of a queried
     * <b>WhseOutboundDeliveryOrderItem</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseOutboundDeliveryOrderHead</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseOutboundDeliveryOrderHead getWhseOutboundDeliveryOrderHeadOrFetch()
    {
        if( toWhseOutboundDeliveryOrderHead == null ) {
            toWhseOutboundDeliveryOrderHead = fetchWhseOutboundDeliveryOrderHead();
        }
        return toWhseOutboundDeliveryOrderHead;
    }

    /**
     * Retrieval of associated <b>WhseOutboundDeliveryOrderHead</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhseOutboundDeliveryOrderHead</b>.
     * <p>
     * If the navigation property for an entity <b>WhseOutboundDeliveryOrderItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseOutboundDeliveryOrderHead</b> is already loaded, the
     *         result will contain the <b>WhseOutboundDeliveryOrderHead</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhseOutboundDeliveryOrderHead> getWhseOutboundDeliveryOrderHeadIfPresent()
    {
        return Option.of(toWhseOutboundDeliveryOrderHead);
    }

    /**
     * Overwrites the associated <b>WhseOutboundDeliveryOrderHead</b> entity for the loaded navigation property
     * <b>to_WhseOutboundDeliveryOrderHead</b>.
     *
     * @param value
     *            New <b>WhseOutboundDeliveryOrderHead</b> entity.
     */
    public void setWhseOutboundDeliveryOrderHead( final WhseOutboundDeliveryOrderHead value )
    {
        toWhseOutboundDeliveryOrderHead = value;
    }

    /**
     * Fetches the <b>WhseDeliveryDocumentAddress</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SoldToPartyDocumentAddress</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhseDeliveryDocumentAddress</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseDeliveryDocumentAddress fetchSoldToPartyDocumentAddress()
    {
        return fetchFieldAsSingle("to_SoldToPartyDocumentAddress", WhseDeliveryDocumentAddress.class);
    }

    /**
     * Retrieval of associated <b>WhseDeliveryDocumentAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SoldToPartyDocumentAddress</b>.
     * <p>
     * If the navigation property <b>to_SoldToPartyDocumentAddress</b> of a queried <b>WhseOutboundDeliveryOrderItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseDeliveryDocumentAddress</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhseDeliveryDocumentAddress getSoldToPartyDocumentAddressOrFetch()
    {
        if( toSoldToPartyDocumentAddress == null ) {
            toSoldToPartyDocumentAddress = fetchSoldToPartyDocumentAddress();
        }
        return toSoldToPartyDocumentAddress;
    }

    /**
     * Retrieval of associated <b>WhseDeliveryDocumentAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SoldToPartyDocumentAddress</b>.
     * <p>
     * If the navigation property for an entity <b>WhseOutboundDeliveryOrderItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SoldToPartyDocumentAddress</b> is already loaded, the
     *         result will contain the <b>WhseDeliveryDocumentAddress</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhseDeliveryDocumentAddress> getSoldToPartyDocumentAddressIfPresent()
    {
        return Option.of(toSoldToPartyDocumentAddress);
    }

    /**
     * Overwrites the associated <b>WhseDeliveryDocumentAddress</b> entity for the loaded navigation property
     * <b>to_SoldToPartyDocumentAddress</b>.
     *
     * @param value
     *            New <b>WhseDeliveryDocumentAddress</b> entity.
     */
    public void setSoldToPartyDocumentAddress( final WhseDeliveryDocumentAddress value )
    {
        toSoldToPartyDocumentAddress = value;
    }

    /**
     * Fetches the <b>WhseOutbDelivOrderItemSerialNo</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WhseOutbDelivOrderItemSerialNo</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseOutbDelivOrderItemSerialNo> fetchWhseOutbDelivOrdItemSerialNo()
    {
        return fetchFieldAsList("to_WhseOutbDelivOrdItemSerialNo", WhseOutbDelivOrderItemSerialNo.class);
    }

    /**
     * Retrieval of associated <b>WhseOutbDelivOrderItemSerialNo</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b>.
     * <p>
     * If the navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b> of a queried
     * <b>WhseOutboundDeliveryOrderItem</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhseOutbDelivOrderItemSerialNo</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhseOutbDelivOrderItemSerialNo> getWhseOutbDelivOrdItemSerialNoOrFetch()
    {
        if( toWhseOutbDelivOrdItemSerialNo == null ) {
            toWhseOutbDelivOrdItemSerialNo = fetchWhseOutbDelivOrdItemSerialNo();
        }
        return toWhseOutbDelivOrdItemSerialNo;
    }

    /**
     * Retrieval of associated <b>WhseOutbDelivOrderItemSerialNo</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b>.
     * <p>
     * If the navigation property for an entity <b>WhseOutboundDeliveryOrderItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b> is already loaded, the
     *         result will contain the <b>WhseOutbDelivOrderItemSerialNo</b> entities. If not, an <code>Option</code>
     *         with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WhseOutbDelivOrderItemSerialNo>> getWhseOutbDelivOrdItemSerialNoIfPresent()
    {
        return Option.of(toWhseOutbDelivOrdItemSerialNo);
    }

    /**
     * Overwrites the list of associated <b>WhseOutbDelivOrderItemSerialNo</b> entities for the loaded navigation
     * property <b>to_WhseOutbDelivOrdItemSerialNo</b>.
     * <p>
     * If the navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b> of a queried
     * <b>WhseOutboundDeliveryOrderItem</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WhseOutbDelivOrderItemSerialNo</b> entities.
     */
    public void setWhseOutbDelivOrdItemSerialNo( @Nonnull final List<WhseOutbDelivOrderItemSerialNo> value )
    {
        if( toWhseOutbDelivOrdItemSerialNo == null ) {
            toWhseOutbDelivOrdItemSerialNo = Lists.newArrayList();
        }
        toWhseOutbDelivOrdItemSerialNo.clear();
        toWhseOutbDelivOrdItemSerialNo.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WhseOutbDelivOrderItemSerialNo</b> entities. This corresponds to the
     * OData navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b>.
     * <p>
     * If the navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b> of a queried
     * <b>WhseOutboundDeliveryOrderItem</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an
     * OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WhseOutbDelivOrderItemSerialNo</b> entities.
     */
    public void addWhseOutbDelivOrdItemSerialNo( WhseOutbDelivOrderItemSerialNo... entity )
    {
        if( toWhseOutbDelivOrdItemSerialNo == null ) {
            toWhseOutbDelivOrdItemSerialNo = Lists.newArrayList();
        }
        toWhseOutbDelivOrdItemSerialNo.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WhseOutboundDeliveryOrderItem instances.
     *
     */
    public final static class WhseOutboundDeliveryOrderItemBuilder
    {

        private WhseOutboundDeliveryOrderHead toWhseOutboundDeliveryOrderHead;
        private WhseDeliveryDocumentAddress toSoldToPartyDocumentAddress;
        private List<WhseOutbDelivOrderItemSerialNo> toWhseOutbDelivOrdItemSerialNo = Lists.newArrayList();

        private WhseOutboundDeliveryOrderItem.WhseOutboundDeliveryOrderItemBuilder toWhseOutboundDeliveryOrderHead(
            final WhseOutboundDeliveryOrderHead value )
        {
            toWhseOutboundDeliveryOrderHead = value;
            return this;
        }

        /**
         * Navigation property <b>to_WhseOutboundDeliveryOrderHead</b> for <b>WhseOutboundDeliveryOrderItem</b> to
         * single <b>WhseOutboundDeliveryOrderHead</b>.
         *
         * @param value
         *            The WhseOutboundDeliveryOrderHead to build this WhseOutboundDeliveryOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseOutboundDeliveryOrderItem.WhseOutboundDeliveryOrderItemBuilder whseOutboundDeliveryOrderHead(
            final WhseOutboundDeliveryOrderHead value )
        {
            return toWhseOutboundDeliveryOrderHead(value);
        }

        private WhseOutboundDeliveryOrderItem.WhseOutboundDeliveryOrderItemBuilder toSoldToPartyDocumentAddress(
            final WhseDeliveryDocumentAddress value )
        {
            toSoldToPartyDocumentAddress = value;
            return this;
        }

        /**
         * Navigation property <b>to_SoldToPartyDocumentAddress</b> for <b>WhseOutboundDeliveryOrderItem</b> to single
         * <b>WhseDeliveryDocumentAddress</b>.
         *
         * @param value
         *            The WhseDeliveryDocumentAddress to build this WhseOutboundDeliveryOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseOutboundDeliveryOrderItem.WhseOutboundDeliveryOrderItemBuilder soldToPartyDocumentAddress(
            final WhseDeliveryDocumentAddress value )
        {
            return toSoldToPartyDocumentAddress(value);
        }

        private WhseOutboundDeliveryOrderItem.WhseOutboundDeliveryOrderItemBuilder toWhseOutbDelivOrdItemSerialNo(
            final List<WhseOutbDelivOrderItemSerialNo> value )
        {
            toWhseOutbDelivOrdItemSerialNo.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WhseOutbDelivOrdItemSerialNo</b> for <b>WhseOutboundDeliveryOrderItem</b> to
         * multiple <b>WhseOutbDelivOrderItemSerialNo</b>.
         *
         * @param value
         *            The WhseOutbDelivOrderItemSerialNos to build this WhseOutboundDeliveryOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhseOutboundDeliveryOrderItem.WhseOutboundDeliveryOrderItemBuilder whseOutbDelivOrdItemSerialNo(
            WhseOutbDelivOrderItemSerialNo... value )
        {
            return toWhseOutbDelivOrdItemSerialNo(Lists.newArrayList(value));
        }

    }

}
