/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseOutboundDeliveryOrderItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
 * WhseOutboundDeliveryOrderItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class WhseOutboundDeliveryOrderItemByKeyFluentHelper
    extends
    FluentHelperByKey<WhseOutboundDeliveryOrderItemByKeyFluentHelper, WhseOutboundDeliveryOrderItem, WhseOutboundDeliveryOrderItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     * WhseOutboundDeliveryOrderItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WhseOutboundDeliveryOrderItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code WhseOutboundDeliveryOrderItem}
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param outboundDeliveryOrderItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public WhseOutboundDeliveryOrderItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem )
    {
        super(servicePath, entityCollection);
        this.key.put("OutboundDeliveryOrder", outboundDeliveryOrder);
        this.key.put("OutboundDeliveryOrderItem", outboundDeliveryOrderItem);
    }

    @Override
    @Nonnull
    protected Class<WhseOutboundDeliveryOrderItem> getEntityClass()
    {
        return WhseOutboundDeliveryOrderItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
