/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem;

/**
 * Implementation of the {@link WarehouseOutboundDeliveryOrderServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService
 * WarehouseOutboundDeliveryOrderService}.
 *
 */
public class DefaultWarehouseOutboundDeliveryOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WarehouseOutboundDeliveryOrderServiceBatch, WarehouseOutboundDeliveryOrderServiceBatchChangeSet>
    implements
    WarehouseOutboundDeliveryOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultWarehouseOutboundDeliveryOrderServiceBatchChangeSet(
        @Nonnull final DefaultWarehouseOutboundDeliveryOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseOutboundDeliveryOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseOutboundDeliveryOrderServiceBatchChangeSet updateWhseOutboundDeliveryOrderHead(
        @Nonnull final WhseOutboundDeliveryOrderHead whseOutboundDeliveryOrderHead )
    {
        return addRequestUpdate(service::updateWhseOutboundDeliveryOrderHead, whseOutboundDeliveryOrderHead);
    }

    @Nonnull
    @Override
    public WarehouseOutboundDeliveryOrderServiceBatchChangeSet updateWhseOutboundDeliveryOrderItem(
        @Nonnull final WhseOutboundDeliveryOrderItem whseOutboundDeliveryOrderItem )
    {
        return addRequestUpdate(service::updateWhseOutboundDeliveryOrderItem, whseOutboundDeliveryOrderItem);
    }

}
