/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseOutboundDeliveryOrderService
 * WarehouseOutboundDeliveryOrderService}.
 *
 */
public interface WarehouseOutboundDeliveryOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<WarehouseOutboundDeliveryOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<WarehouseOutboundDeliveryOrderServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     * WhseOutboundDeliveryOrderHead} entity and save it to the S/4HANA system.
     *
     * @param whseOutboundDeliveryOrderHead
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     *            WhseOutboundDeliveryOrderHead} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehouseOutboundDeliveryOrderServiceBatchChangeSet updateWhseOutboundDeliveryOrderHead(
        @Nonnull final WhseOutboundDeliveryOrderHead whseOutboundDeliveryOrderHead );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     * WhseOutboundDeliveryOrderItem} entity and save it to the S/4HANA system.
     *
     * @param whseOutboundDeliveryOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     *            WhseOutboundDeliveryOrderItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehouseOutboundDeliveryOrderServiceBatchChangeSet updateWhseOutboundDeliveryOrderItem(
        @Nonnull final WhseOutboundDeliveryOrderItem whseOutboundDeliveryOrderItem );

}
