/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable.WhseOutboundDeliveryOrderItemSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
 * WhseOutboundDeliveryOrderItem} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class WhseOutboundDeliveryOrderItemLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<WhseOutboundDeliveryOrderItemLink<ObjectT>, WhseOutboundDeliveryOrderItem, ObjectT>
    implements
    WhseOutboundDeliveryOrderItemSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public WhseOutboundDeliveryOrderItemLink( final String fieldName )
    {
        super(fieldName);
    }

    private WhseOutboundDeliveryOrderItemLink(
        final EntityLink<WhseOutboundDeliveryOrderItemLink<ObjectT>, WhseOutboundDeliveryOrderItem, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected WhseOutboundDeliveryOrderItemLink<ObjectT> translateLinkType(
        final EntityLink<WhseOutboundDeliveryOrderItemLink<ObjectT>, WhseOutboundDeliveryOrderItem, ObjectT> link )
    {
        return new WhseOutboundDeliveryOrderItemLink<ObjectT>(link);
    }

}
