/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress
 * WhseDeliveryDocumentAddress}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseDeliveryDocumentAddressField
 * WhseDeliveryDocumentAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseDeliveryDocumentAddressLink
 * WhseDeliveryDocumentAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#OUTBOUND_DELIVERY_ORDER
 * OUTBOUND_DELIVERY_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#OUTBOUND_DELIVERY_ORDER_ITEM
 * OUTBOUND_DELIVERY_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#BUSINESS_PARTNER_ROLE
 * BUSINESS_PARTNER_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#BUSINESS_PARTNER_NAME1
 * BUSINESS_PARTNER_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#BUSINESS_PARTNER_NAME2
 * BUSINESS_PARTNER_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#STREET_PREFIX_NAME
 * STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#ADDITIONAL_STREET_PREFIX_NAME
 * ADDITIONAL_STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#STREET_SUFFIX_NAME
 * STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#ADDITIONAL_STREET_SUFFIX_NAME
 * ADDITIONAL_STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#IS_BUSINESS_PURPOSE_COMPLETED
 * IS_BUSINESS_PURPOSE_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#TO_WHSE_OUTBOUND_DELIVERY_ORDER_HEAD
 * TO_WHSE_OUTBOUND_DELIVERY_ORDER_HEAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress#TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM
 * TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface WhseDeliveryDocumentAddressSelectable extends EntitySelectable<WhseDeliveryDocumentAddress>
{

}
