/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo
 * WhseOutbDelivOrderItemSerialNo}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseOutbDelivOrderItemSerialNoField
 * WhseOutbDelivOrderItemSerialNoField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseOutbDelivOrderItemSerialNoLink
 * WhseOutbDelivOrderItemSerialNoLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo#OUTBOUND_DELIVERY_ORDER
 * OUTBOUND_DELIVERY_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo#OUTBOUND_DELIVERY_ORDER_ITEM
 * OUTBOUND_DELIVERY_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo#EWM_SERIAL_NUMBER
 * EWM_SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo#TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM
 * TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface WhseOutbDelivOrderItemSerialNoSelectable extends EntitySelectable<WhseOutbDelivOrderItemSerialNo>
{

}
