/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
 * WhseOutboundDeliveryOrderHead}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseOutboundDeliveryOrderHeadField
 * WhseOutboundDeliveryOrderHeadField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseOutboundDeliveryOrderHeadLink
 * WhseOutboundDeliveryOrderHeadLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#OUTBOUND_DELIVERY_ORDER
 * OUTBOUND_DELIVERY_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#DELIVERY_CATEGORY
 * DELIVERY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#DELIVERY_TYPE
 * DELIVERY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#SHIP_TO_PARTY_NAME
 * SHIP_TO_PARTY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#CARRIER
 * CARRIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#CARRIER_NAME
 * CARRIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#PLANNED_DELIVERY_UTC_DATE_TIME
 * PLANNED_DELIVERY_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#PLANNED_OUT_OF_YARD_UTC_DATE_TIME
 * PLANNED_OUT_OF_YARD_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#INCOTERMS_PART1
 * INCOTERMS_PART1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#INCOTERMS_PART2
 * INCOTERMS_PART2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#ROUTE
 * ROUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#SHIPPING_OFFICE
 * SHIPPING_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#TO_SHIP_TO_PARTY_DOCUMENT_ADDRESS
 * TO_SHIP_TO_PARTY_DOCUMENT_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead#TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM
 * TO_WHSE_OUTBOUND_DELIVERY_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface WhseOutboundDeliveryOrderHeadSelectable extends EntitySelectable<WhseOutboundDeliveryOrderHead>
{

}
