/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
 * WhseOutboundDeliveryOrderItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.field.WhseOutboundDeliveryOrderItemField
 * WhseOutboundDeliveryOrderItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.link.WhseOutboundDeliveryOrderItemLink
 * WhseOutboundDeliveryOrderItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#OUTBOUND_DELIVERY_ORDER
 * OUTBOUND_DELIVERY_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#OUTBOUND_DELIVERY_ORDER_ITEM
 * OUTBOUND_DELIVERY_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#DELIVERY_CATEGORY
 * DELIVERY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#OUTB_DELIVERY_ORDER_ITEM_CATEGORY
 * OUTB_DELIVERY_ORDER_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#OUTBOUND_DELIVERY_ORDER_ITEM_TYPE
 * OUTBOUND_DELIVERY_ORDER_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PRODUCT_EXTERNAL_ID
 * PRODUCT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PRODUCT_BATCH
 * PRODUCT_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PRODUCT_QUANTITY
 * PRODUCT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STAGING_AREA
 * STAGING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STAGING_AREA_GROUP
 * STAGING_AREA_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STAGING_BAY
 * STAGING_BAY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#GOODS_ISSUE_STATUS
 * GOODS_ISSUE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PLANNED_PICKING_STATUS
 * PLANNED_PICKING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PICKING_STATUS
 * PICKING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#COMPLETION_STATUS
 * COMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#WAREHOUSE_PROCESS_TYPE
 * WAREHOUSE_PROCESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#SHIPPING_CONDITION
 * SHIPPING_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#GOODS_MOVEMENT_BIN
 * GOODS_MOVEMENT_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STORAGE_SECTION
 * STORAGE_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#PLND_GOODS_ISSUE_START_UTC_DATE_TIME
 * PLND_GOODS_ISSUE_START_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#ACTL_GOODS_ISSUE_START_UTC_DATE_TIME
 * ACTL_GOODS_ISSUE_START_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#ROUTE_SCHEDULE
 * ROUTE_SCHEDULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#ENTITLED_TO_DISPOSE_PARTY
 * ENTITLED_TO_DISPOSE_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STOCK_USAGE
 * STOCK_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#WAREHOUSE_STOCK_CATEGORY
 * WAREHOUSE_STOCK_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STOCK_OWNER
 * STOCK_OWNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#DELIVERY_ITEM_STOCK_TYPE_DETN_CODE
 * DELIVERY_ITEM_STOCK_TYPE_DETN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STOCK_DOCUMENT_CATEGORY
 * STOCK_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STOCK_DOCUMENT_NUMBER
 * STOCK_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#STOCK_ITEM_NUMBER
 * STOCK_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#SPECIAL_STOCK_IDFG_SALES_ORDER
 * SPECIAL_STOCK_IDFG_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM
 * SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#TO_WHSE_OUTBOUND_DELIVERY_ORDER_HEAD
 * TO_WHSE_OUTBOUND_DELIVERY_ORDER_HEAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#TO_SOLD_TO_PARTY_DOCUMENT_ADDRESS
 * TO_SOLD_TO_PARTY_DOCUMENT_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem#TO_WHSE_OUTB_DELIV_ORD_ITEM_SERIAL_NO
 * TO_WHSE_OUTB_DELIV_ORD_ITEM_SERIAL_NO}</li>
 * </ul>
 *
 */
public interface WhseOutboundDeliveryOrderItemSelectable extends EntitySelectable<WhseOutboundDeliveryOrderItem>
{

}
