/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.field.WhsePhysicalInventoryCountItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.link.WhsePhysicalInventoryCountItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.selectable.WhsePhysicalInventoryCountItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Physical Inventory Count Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhsePhysicalInventoryCountItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhsePhysicalInventoryCountItem extends VdmEntity<WhsePhysicalInventoryCountItem>
{

    /**
     * Selector for all available fields of WhsePhysicalInventoryCountItem.
     *
     */
    public final static WhsePhysicalInventoryCountItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentUUID</b>
     * </p>
     *
     * @return GUID for Physical Inventory Document
     */
    @Key
    @SerializedName( "PhysicalInventoryDocumentUUID" )
    @JsonProperty( "PhysicalInventoryDocumentUUID" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocumentUUID" )
    private UUID physicalInventoryDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocumentUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<UUID> PHYSICAL_INVENTORY_DOCUMENT_UUID =
        new WhsePhysicalInventoryCountItemField<UUID>("PhysicalInventoryDocumentUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemNumber</b>
     * </p>
     *
     * @return Item
     */
    @Key
    @SerializedName( "PhysicalInventoryItemNumber" )
    @JsonProperty( "PhysicalInventoryItemNumber" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryItemNumber" )
    private String physicalInventoryItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryItemNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> PHYSICAL_INVENTORY_ITEM_NUMBER =
        new WhsePhysicalInventoryCountItemField<String>("PhysicalInventoryItemNumber");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LineIndexOfPInvItem</b>
     * </p>
     *
     * @return Row Index of Internal Tables
     */
    @Key
    @SerializedName( "LineIndexOfPInvItem" )
    @JsonProperty( "LineIndexOfPInvItem" )
    @Nullable
    @ODataField( odataName = "LineIndexOfPInvItem" )
    private Integer lineIndexOfPInvItem;
    /**
     * Use with available fluent helpers to apply the <b>LineIndexOfPInvItem</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Integer> LINE_INDEX_OF_P_INV_ITEM =
        new WhsePhysicalInventoryCountItemField<Integer>("LineIndexOfPInvItem");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PInvQuantitySequence</b>
     * </p>
     *
     * @return Row Index of Internal Tables
     */
    @Key
    @SerializedName( "PInvQuantitySequence" )
    @JsonProperty( "PInvQuantitySequence" )
    @Nullable
    @ODataField( odataName = "PInvQuantitySequence" )
    private Integer pInvQuantitySequence;
    /**
     * Use with available fluent helpers to apply the <b>PInvQuantitySequence</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Integer> P_INV_QUANTITY_SEQUENCE =
        new WhsePhysicalInventoryCountItemField<Integer>("PInvQuantitySequence");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemLevel</b>
     * </p>
     *
     * @return Level in Tree Hierarchy Observed from Leaf
     */
    @SerializedName( "PhysicalInventoryItemLevel" )
    @JsonProperty( "PhysicalInventoryItemLevel" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryItemLevel" )
    private Integer physicalInventoryItemLevel;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryItemLevel</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Integer> PHYSICAL_INVENTORY_ITEM_LEVEL =
        new WhsePhysicalInventoryCountItemField<Integer>("PhysicalInventoryItemLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PInvItemParentType</b>
     * </p>
     *
     * @return Parent Item Type
     */
    @SerializedName( "PInvItemParentType" )
    @JsonProperty( "PInvItemParentType" )
    @Nullable
    @ODataField( odataName = "PInvItemParentType" )
    private String pInvItemParentType;
    /**
     * Use with available fluent helpers to apply the <b>PInvItemParentType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> P_INV_ITEM_PARENT_TYPE =
        new WhsePhysicalInventoryCountItemField<String>("PInvItemParentType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STORAGE_BIN =
        new WhsePhysicalInventoryCountItemField<String>("StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STORAGE_TYPE =
        new WhsePhysicalInventoryCountItemField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     *
     * @return Parent Handling Unit
     */
    @SerializedName( "ParentHandlingUnitNumber" )
    @JsonProperty( "ParentHandlingUnitNumber" )
    @Nullable
    @ODataField( odataName = "ParentHandlingUnitNumber" )
    private String parentHandlingUnitNumber;
    /**
     * Use with available fluent helpers to apply the <b>ParentHandlingUnitNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> PARENT_HANDLING_UNIT_NUMBER =
        new WhsePhysicalInventoryCountItemField<String>("ParentHandlingUnitNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemType</b>
     * </p>
     *
     * @return Object Category of Physical Inventory (Item Object)
     */
    @SerializedName( "PhysicalInventoryItemType" )
    @JsonProperty( "PhysicalInventoryItemType" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryItemType" )
    private String physicalInventoryItemType;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryItemType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> PHYSICAL_INVENTORY_ITEM_TYPE =
        new WhsePhysicalInventoryCountItemField<String>("PhysicalInventoryItemType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNumber</b>
     * </p>
     *
     * @return Source Handling Unit
     */
    @SerializedName( "HandlingUnitNumber" )
    @JsonProperty( "HandlingUnitNumber" )
    @Nullable
    @ODataField( odataName = "HandlingUnitNumber" )
    private String handlingUnitNumber;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> HANDLING_UNIT_NUMBER =
        new WhsePhysicalInventoryCountItemField<String>("HandlingUnitNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> PRODUCT =
        new WhsePhysicalInventoryCountItemField<String>("Product");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductUUID</b>
     * </p>
     *
     * @return Product UUID
     */
    @SerializedName( "ProductUUID" )
    @JsonProperty( "ProductUUID" )
    @Nullable
    @ODataField( odataName = "ProductUUID" )
    private UUID productUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<UUID> PRODUCT_UUID =
        new WhsePhysicalInventoryCountItemField<UUID>("ProductUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchUUID</b>
     * </p>
     *
     * @return Batch
     */
    @SerializedName( "BatchUUID" )
    @JsonProperty( "BatchUUID" )
    @Nullable
    @ODataField( odataName = "BatchUUID" )
    private UUID batchUUID;
    /**
     * Use with available fluent helpers to apply the <b>BatchUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<UUID> BATCH_UUID =
        new WhsePhysicalInventoryCountItemField<UUID>("BatchUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> BATCH =
        new WhsePhysicalInventoryCountItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberRequiredLevel</b>
     * </p>
     *
     * @return The serialNumberRequiredLevel contained in this entity.
     */
    @SerializedName( "SerialNumberRequiredLevel" )
    @JsonProperty( "SerialNumberRequiredLevel" )
    @Nullable
    @ODataField( odataName = "SerialNumberRequiredLevel" )
    private String serialNumberRequiredLevel;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumberRequiredLevel</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> SERIAL_NUMBER_REQUIRED_LEVEL =
        new WhsePhysicalInventoryCountItemField<String>("SerialNumberRequiredLevel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "StockType" )
    @JsonProperty( "StockType" )
    @Nullable
    @ODataField( odataName = "StockType" )
    private String stockType;
    /**
     * Use with available fluent helpers to apply the <b>StockType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_TYPE =
        new WhsePhysicalInventoryCountItemField<String>("StockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @return Owner
     */
    @SerializedName( "StockOwner" )
    @JsonProperty( "StockOwner" )
    @Nullable
    @ODataField( odataName = "StockOwner" )
    private String stockOwner;
    /**
     * Use with available fluent helpers to apply the <b>StockOwner</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_OWNER =
        new WhsePhysicalInventoryCountItemField<String>("StockOwner");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockOwnerPartnerRole</b>
     * </p>
     *
     * @return Partner Role of Owner
     */
    @SerializedName( "StockOwnerPartnerRole" )
    @JsonProperty( "StockOwnerPartnerRole" )
    @Nullable
    @ODataField( odataName = "StockOwnerPartnerRole" )
    private String stockOwnerPartnerRole;
    /**
     * Use with available fluent helpers to apply the <b>StockOwnerPartnerRole</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_OWNER_PARTNER_ROLE =
        new WhsePhysicalInventoryCountItemField<String>("StockOwnerPartnerRole");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @return Stock Usage
     */
    @SerializedName( "StockUsage" )
    @JsonProperty( "StockUsage" )
    @Nullable
    @ODataField( odataName = "StockUsage" )
    private String stockUsage;
    /**
     * Use with available fluent helpers to apply the <b>StockUsage</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_USAGE =
        new WhsePhysicalInventoryCountItemField<String>("StockUsage");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @return Party Entitled to Dispose
     */
    @SerializedName( "EntitledToDisposeParty" )
    @JsonProperty( "EntitledToDisposeParty" )
    @Nullable
    @ODataField( odataName = "EntitledToDisposeParty" )
    private String entitledToDisposeParty;
    /**
     * Use with available fluent helpers to apply the <b>EntitledToDisposeParty</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> ENTITLED_TO_DISPOSE_PARTY =
        new WhsePhysicalInventoryCountItemField<String>("EntitledToDisposeParty");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposePartnerRole</b>
     * </p>
     *
     * @return Partner Role of Party Entitled to Dispose
     */
    @SerializedName( "EntitledToDisposePartnerRole" )
    @JsonProperty( "EntitledToDisposePartnerRole" )
    @Nullable
    @ODataField( odataName = "EntitledToDisposePartnerRole" )
    private String entitledToDisposePartnerRole;
    /**
     * Use with available fluent helpers to apply the <b>EntitledToDisposePartnerRole</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> ENTITLED_TO_DISPOSE_PARTNER_ROLE =
        new WhsePhysicalInventoryCountItemField<String>("EntitledToDisposePartnerRole");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @return Special Reference Stock Type
     */
    @SerializedName( "StockDocumentCategory" )
    @JsonProperty( "StockDocumentCategory" )
    @Nullable
    @ODataField( odataName = "StockDocumentCategory" )
    private String stockDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentCategory</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_DOCUMENT_CATEGORY =
        new WhsePhysicalInventoryCountItemField<String>("StockDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @return Reference Document for Special Reference Stock
     */
    @SerializedName( "StockDocumentNumber" )
    @JsonProperty( "StockDocumentNumber" )
    @Nullable
    @ODataField( odataName = "StockDocumentNumber" )
    private String stockDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_DOCUMENT_NUMBER =
        new WhsePhysicalInventoryCountItemField<String>("StockDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @return Sales Order Item for Sales Order Stock
     */
    @SerializedName( "StockItemNumber" )
    @JsonProperty( "StockItemNumber" )
    @Nullable
    @ODataField( odataName = "StockItemNumber" )
    private String stockItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockItemNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_ITEM_NUMBER =
        new WhsePhysicalInventoryCountItemField<String>("StockItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new WhsePhysicalInventoryCountItemField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReltdStockDocCat</b>
     * </p>
     *
     * @return Doc. Category for Doc. Reference and Doc.-Related Stock
     */
    @SerializedName( "DocumentReltdStockDocCat" )
    @JsonProperty( "DocumentReltdStockDocCat" )
    @Nullable
    @ODataField( odataName = "DocumentReltdStockDocCat" )
    private String documentReltdStockDocCat;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReltdStockDocCat</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> DOCUMENT_RELTD_STOCK_DOC_CAT =
        new WhsePhysicalInventoryCountItemField<String>("DocumentReltdStockDocCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WhseQualityInspectionType</b>
     * </p>
     *
     * @return Inspection ID Type
     */
    @SerializedName( "WhseQualityInspectionType" )
    @JsonProperty( "WhseQualityInspectionType" )
    @Nullable
    @ODataField( odataName = "WhseQualityInspectionType" )
    private String whseQualityInspectionType;
    /**
     * Use with available fluent helpers to apply the <b>WhseQualityInspectionType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> WHSE_QUALITY_INSPECTION_TYPE =
        new WhsePhysicalInventoryCountItemField<String>("WhseQualityInspectionType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QualityInspectionDocUUID</b>
     * </p>
     *
     * @return Identification of a Quality Object
     */
    @SerializedName( "QualityInspectionDocUUID" )
    @JsonProperty( "QualityInspectionDocUUID" )
    @Nullable
    @ODataField( odataName = "QualityInspectionDocUUID" )
    private UUID qualityInspectionDocUUID;
    /**
     * Use with available fluent helpers to apply the <b>QualityInspectionDocUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<UUID> QUALITY_INSPECTION_DOC_UUID =
        new WhsePhysicalInventoryCountItemField<UUID>("QualityInspectionDocUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StockIdentificationNumber</b>
     * </p>
     *
     * @return Identification Number of Stock
     */
    @SerializedName( "StockIdentificationNumber" )
    @JsonProperty( "StockIdentificationNumber" )
    @Nullable
    @ODataField( odataName = "StockIdentificationNumber" )
    private String stockIdentificationNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockIdentificationNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> STOCK_IDENTIFICATION_NUMBER =
        new WhsePhysicalInventoryCountItemField<String>("StockIdentificationNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReltdStockDocUUID</b>
     * </p>
     *
     * @return Doc. Identification for Document-Related Stocks
     */
    @SerializedName( "DocumentReltdStockDocUUID" )
    @JsonProperty( "DocumentReltdStockDocUUID" )
    @Nullable
    @ODataField( odataName = "DocumentReltdStockDocUUID" )
    private UUID documentReltdStockDocUUID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReltdStockDocUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<UUID> DOCUMENT_RELTD_STOCK_DOC_UUID =
        new WhsePhysicalInventoryCountItemField<UUID>("DocumentReltdStockDocUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReltdStockDocItemUUID</b>
     * </p>
     *
     * @return Document Item for Document-Related Stocks
     */
    @SerializedName( "DocumentReltdStockDocItemUUID" )
    @JsonProperty( "DocumentReltdStockDocItemUUID" )
    @Nullable
    @ODataField( odataName = "DocumentReltdStockDocItemUUID" )
    private UUID documentReltdStockDocItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReltdStockDocItemUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<UUID> DOCUMENT_RELTD_STOCK_DOC_ITEM_UUID =
        new WhsePhysicalInventoryCountItemField<UUID>("DocumentReltdStockDocItemUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskGoodsReceiptDateTime</b>
     * </p>
     *
     * @return Date and Time of Goods Receipt
     */
    @SerializedName( "WhseTaskGoodsReceiptDateTime" )
    @JsonProperty( "WhseTaskGoodsReceiptDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WhseTaskGoodsReceiptDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime whseTaskGoodsReceiptDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WhseTaskGoodsReceiptDateTime</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<ZonedDateTime> WHSE_TASK_GOODS_RECEIPT_DATE_TIME =
        new WhsePhysicalInventoryCountItemField<ZonedDateTime>("WhseTaskGoodsReceiptDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @return Shelf Life Expiration Date
     */
    @SerializedName( "ShelfLifeExpirationDate" )
    @JsonProperty( "ShelfLifeExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShelfLifeExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shelfLifeExpirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDate</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<LocalDateTime> SHELF_LIFE_EXPIRATION_DATE =
        new WhsePhysicalInventoryCountItemField<LocalDateTime>("ShelfLifeExpirationDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @return Country or Region of Origin
     */
    @SerializedName( "CountryOfOrigin" )
    @JsonProperty( "CountryOfOrigin" )
    @Nullable
    @ODataField( odataName = "CountryOfOrigin" )
    private String countryOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CountryOfOrigin</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> COUNTRY_OF_ORIGIN =
        new WhsePhysicalInventoryCountItemField<String>("CountryOfOrigin");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlBatchIsInRstrcdUseStock</b>
     * </p>
     *
     * @return Batch in Restricted-Use Stock
     */
    @SerializedName( "MatlBatchIsInRstrcdUseStock" )
    @JsonProperty( "MatlBatchIsInRstrcdUseStock" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlBatchIsInRstrcdUseStock" )
    private Boolean matlBatchIsInRstrcdUseStock;
    /**
     * Use with available fluent helpers to apply the <b>MatlBatchIsInRstrcdUseStock</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Boolean> MATL_BATCH_IS_IN_RSTRCD_USE_STOCK =
        new WhsePhysicalInventoryCountItemField<Boolean>("MatlBatchIsInRstrcdUseStock");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HndlgUnitItemCountedIsComplete</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "HndlgUnitItemCountedIsComplete" )
    @JsonProperty( "HndlgUnitItemCountedIsComplete" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HndlgUnitItemCountedIsComplete" )
    private Boolean hndlgUnitItemCountedIsComplete;
    /**
     * Use with available fluent helpers to apply the <b>HndlgUnitItemCountedIsComplete</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Boolean> HNDLG_UNIT_ITEM_COUNTED_IS_COMPLETE =
        new WhsePhysicalInventoryCountItemField<Boolean>("HndlgUnitItemCountedIsComplete");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HndlgUnitItemCountedIsEmpty</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "HndlgUnitItemCountedIsEmpty" )
    @JsonProperty( "HndlgUnitItemCountedIsEmpty" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HndlgUnitItemCountedIsEmpty" )
    private Boolean hndlgUnitItemCountedIsEmpty;
    /**
     * Use with available fluent helpers to apply the <b>HndlgUnitItemCountedIsEmpty</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Boolean> HNDLG_UNIT_ITEM_COUNTED_IS_EMPTY =
        new WhsePhysicalInventoryCountItemField<Boolean>("HndlgUnitItemCountedIsEmpty");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HndlgUnitItemCountedIsNotExist</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "HndlgUnitItemCountedIsNotExist" )
    @JsonProperty( "HndlgUnitItemCountedIsNotExist" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HndlgUnitItemCountedIsNotExist" )
    private Boolean hndlgUnitItemCountedIsNotExist;
    /**
     * Use with available fluent helpers to apply the <b>HndlgUnitItemCountedIsNotExist</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Boolean> HNDLG_UNIT_ITEM_COUNTED_IS_NOT_EXIST =
        new WhsePhysicalInventoryCountItemField<Boolean>("HndlgUnitItemCountedIsNotExist");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     *
     * @return Packaging Material
     */
    @SerializedName( "PackagingMaterial" )
    @JsonProperty( "PackagingMaterial" )
    @Nullable
    @ODataField( odataName = "PackagingMaterial" )
    private String packagingMaterial;
    /**
     * Use with available fluent helpers to apply the <b>PackagingMaterial</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> PACKAGING_MATERIAL =
        new WhsePhysicalInventoryCountItemField<String>("PackagingMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitType</b>
     * </p>
     *
     * @return Handling Unit Type
     */
    @SerializedName( "HandlingUnitType" )
    @JsonProperty( "HandlingUnitType" )
    @Nullable
    @ODataField( odataName = "HandlingUnitType" )
    private String handlingUnitType;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> HANDLING_UNIT_TYPE =
        new WhsePhysicalInventoryCountItemField<String>("HandlingUnitType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsEmpty</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "StorageBinIsEmpty" )
    @JsonProperty( "StorageBinIsEmpty" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StorageBinIsEmpty" )
    private Boolean storageBinIsEmpty;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinIsEmpty</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Boolean> STORAGE_BIN_IS_EMPTY =
        new WhsePhysicalInventoryCountItemField<Boolean>("StorageBinIsEmpty");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PInvIsZeroCount</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "PInvIsZeroCount" )
    @JsonProperty( "PInvIsZeroCount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PInvIsZeroCount" )
    private Boolean pInvIsZeroCount;
    /**
     * Use with available fluent helpers to apply the <b>PInvIsZeroCount</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<Boolean> P_INV_IS_ZERO_COUNT =
        new WhsePhysicalInventoryCountItemField<Boolean>("PInvIsZeroCount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Inventory-Managed Unit of Measure
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<String> REQUESTED_QUANTITY_UNIT =
        new WhsePhysicalInventoryCountItemField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Quantity Entered in Physical Inventory
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<BigDecimal> REQUESTED_QUANTITY =
        new WhsePhysicalInventoryCountItemField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvItemChgUTCDateTime</b>
     * </p>
     *
     * @return LIME Internal Time Stamp (YYYYMMDDhhmmss,mmmuuun)
     */
    @SerializedName( "PInvItemChgUTCDateTime" )
    @JsonProperty( "PInvItemChgUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PInvItemChgUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime pInvItemChgUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PInvItemChgUTCDateTime</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemField<ZonedDateTime> P_INV_ITEM_CHG_UTC_DATE_TIME =
        new WhsePhysicalInventoryCountItemField<ZonedDateTime>("PInvItemChgUTCDateTime");
    /**
     * Navigation property <b>to_WhsePhysicalInventoryItem</b> for <b>WhsePhysicalInventoryCountItem</b> to single
     * <b>WhsePhysicalInventoryItem</b>.
     *
     */
    @SerializedName( "to_WhsePhysicalInventoryItem" )
    @JsonProperty( "to_WhsePhysicalInventoryItem" )
    @ODataField( odataName = "to_WhsePhysicalInventoryItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WhsePhysicalInventoryItem toWhsePhysicalInventoryItem;
    /**
     * Use with available fluent helpers to apply the <b>to_WhsePhysicalInventoryItem</b> navigation property to query
     * operations.
     *
     */
    public final static WhsePhysicalInventoryCountItemOneToOneLink<WhsePhysicalInventoryItem> TO_WHSE_PHYSICAL_INVENTORY_ITEM =
        new WhsePhysicalInventoryCountItemOneToOneLink<WhsePhysicalInventoryItem>("to_WhsePhysicalInventoryItem");

    @Nonnull
    @Override
    public Class<WhsePhysicalInventoryCountItem> getType()
    {
        return WhsePhysicalInventoryCountItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentUUID</b>
     * </p>
     *
     * @param physicalInventoryDocumentUUID
     *            GUID for Physical Inventory Document
     */
    public void setPhysicalInventoryDocumentUUID( @Nullable final UUID physicalInventoryDocumentUUID )
    {
        rememberChangedField("PhysicalInventoryDocumentUUID", this.physicalInventoryDocumentUUID);
        this.physicalInventoryDocumentUUID = physicalInventoryDocumentUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemNumber</b>
     * </p>
     *
     * @param physicalInventoryItemNumber
     *            Item
     */
    public void setPhysicalInventoryItemNumber( @Nullable final String physicalInventoryItemNumber )
    {
        rememberChangedField("PhysicalInventoryItemNumber", this.physicalInventoryItemNumber);
        this.physicalInventoryItemNumber = physicalInventoryItemNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LineIndexOfPInvItem</b>
     * </p>
     *
     * @param lineIndexOfPInvItem
     *            Row Index of Internal Tables
     */
    public void setLineIndexOfPInvItem( @Nullable final Integer lineIndexOfPInvItem )
    {
        rememberChangedField("LineIndexOfPInvItem", this.lineIndexOfPInvItem);
        this.lineIndexOfPInvItem = lineIndexOfPInvItem;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PInvQuantitySequence</b>
     * </p>
     *
     * @param pInvQuantitySequence
     *            Row Index of Internal Tables
     */
    public void setPInvQuantitySequence( @Nullable final Integer pInvQuantitySequence )
    {
        rememberChangedField("PInvQuantitySequence", this.pInvQuantitySequence);
        this.pInvQuantitySequence = pInvQuantitySequence;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemLevel</b>
     * </p>
     *
     * @param physicalInventoryItemLevel
     *            Level in Tree Hierarchy Observed from Leaf
     */
    public void setPhysicalInventoryItemLevel( @Nullable final Integer physicalInventoryItemLevel )
    {
        rememberChangedField("PhysicalInventoryItemLevel", this.physicalInventoryItemLevel);
        this.physicalInventoryItemLevel = physicalInventoryItemLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PInvItemParentType</b>
     * </p>
     *
     * @param pInvItemParentType
     *            Parent Item Type
     */
    public void setPInvItemParentType( @Nullable final String pInvItemParentType )
    {
        rememberChangedField("PInvItemParentType", this.pInvItemParentType);
        this.pInvItemParentType = pInvItemParentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     *
     * @param parentHandlingUnitNumber
     *            Parent Handling Unit
     */
    public void setParentHandlingUnitNumber( @Nullable final String parentHandlingUnitNumber )
    {
        rememberChangedField("ParentHandlingUnitNumber", this.parentHandlingUnitNumber);
        this.parentHandlingUnitNumber = parentHandlingUnitNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemType</b>
     * </p>
     *
     * @param physicalInventoryItemType
     *            Object Category of Physical Inventory (Item Object)
     */
    public void setPhysicalInventoryItemType( @Nullable final String physicalInventoryItemType )
    {
        rememberChangedField("PhysicalInventoryItemType", this.physicalInventoryItemType);
        this.physicalInventoryItemType = physicalInventoryItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNumber</b>
     * </p>
     *
     * @param handlingUnitNumber
     *            Source Handling Unit
     */
    public void setHandlingUnitNumber( @Nullable final String handlingUnitNumber )
    {
        rememberChangedField("HandlingUnitNumber", this.handlingUnitNumber);
        this.handlingUnitNumber = handlingUnitNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductUUID</b>
     * </p>
     *
     * @param productUUID
     *            Product UUID
     */
    public void setProductUUID( @Nullable final UUID productUUID )
    {
        rememberChangedField("ProductUUID", this.productUUID);
        this.productUUID = productUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchUUID</b>
     * </p>
     *
     * @param batchUUID
     *            Batch
     */
    public void setBatchUUID( @Nullable final UUID batchUUID )
    {
        rememberChangedField("BatchUUID", this.batchUUID);
        this.batchUUID = batchUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberRequiredLevel</b>
     * </p>
     *
     * @param serialNumberRequiredLevel
     *            The serialNumberRequiredLevel to set.
     */
    public void setSerialNumberRequiredLevel( @Nullable final String serialNumberRequiredLevel )
    {
        rememberChangedField("SerialNumberRequiredLevel", this.serialNumberRequiredLevel);
        this.serialNumberRequiredLevel = serialNumberRequiredLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @param stockType
     *            Stock Type
     */
    public void setStockType( @Nullable final String stockType )
    {
        rememberChangedField("StockType", this.stockType);
        this.stockType = stockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @param stockOwner
     *            Owner
     */
    public void setStockOwner( @Nullable final String stockOwner )
    {
        rememberChangedField("StockOwner", this.stockOwner);
        this.stockOwner = stockOwner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockOwnerPartnerRole</b>
     * </p>
     *
     * @param stockOwnerPartnerRole
     *            Partner Role of Owner
     */
    public void setStockOwnerPartnerRole( @Nullable final String stockOwnerPartnerRole )
    {
        rememberChangedField("StockOwnerPartnerRole", this.stockOwnerPartnerRole);
        this.stockOwnerPartnerRole = stockOwnerPartnerRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @param stockUsage
     *            Stock Usage
     */
    public void setStockUsage( @Nullable final String stockUsage )
    {
        rememberChangedField("StockUsage", this.stockUsage);
        this.stockUsage = stockUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @param entitledToDisposeParty
     *            Party Entitled to Dispose
     */
    public void setEntitledToDisposeParty( @Nullable final String entitledToDisposeParty )
    {
        rememberChangedField("EntitledToDisposeParty", this.entitledToDisposeParty);
        this.entitledToDisposeParty = entitledToDisposeParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposePartnerRole</b>
     * </p>
     *
     * @param entitledToDisposePartnerRole
     *            Partner Role of Party Entitled to Dispose
     */
    public void setEntitledToDisposePartnerRole( @Nullable final String entitledToDisposePartnerRole )
    {
        rememberChangedField("EntitledToDisposePartnerRole", this.entitledToDisposePartnerRole);
        this.entitledToDisposePartnerRole = entitledToDisposePartnerRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @param stockDocumentCategory
     *            Special Reference Stock Type
     */
    public void setStockDocumentCategory( @Nullable final String stockDocumentCategory )
    {
        rememberChangedField("StockDocumentCategory", this.stockDocumentCategory);
        this.stockDocumentCategory = stockDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @param stockDocumentNumber
     *            Reference Document for Special Reference Stock
     */
    public void setStockDocumentNumber( @Nullable final String stockDocumentNumber )
    {
        rememberChangedField("StockDocumentNumber", this.stockDocumentNumber);
        this.stockDocumentNumber = stockDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @param stockItemNumber
     *            Sales Order Item for Sales Order Stock
     */
    public void setStockItemNumber( @Nullable final String stockItemNumber )
    {
        rememberChangedField("StockItemNumber", this.stockItemNumber);
        this.stockItemNumber = stockItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReltdStockDocCat</b>
     * </p>
     *
     * @param documentReltdStockDocCat
     *            Doc. Category for Doc. Reference and Doc.-Related Stock
     */
    public void setDocumentReltdStockDocCat( @Nullable final String documentReltdStockDocCat )
    {
        rememberChangedField("DocumentReltdStockDocCat", this.documentReltdStockDocCat);
        this.documentReltdStockDocCat = documentReltdStockDocCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WhseQualityInspectionType</b>
     * </p>
     *
     * @param whseQualityInspectionType
     *            Inspection ID Type
     */
    public void setWhseQualityInspectionType( @Nullable final String whseQualityInspectionType )
    {
        rememberChangedField("WhseQualityInspectionType", this.whseQualityInspectionType);
        this.whseQualityInspectionType = whseQualityInspectionType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QualityInspectionDocUUID</b>
     * </p>
     *
     * @param qualityInspectionDocUUID
     *            Identification of a Quality Object
     */
    public void setQualityInspectionDocUUID( @Nullable final UUID qualityInspectionDocUUID )
    {
        rememberChangedField("QualityInspectionDocUUID", this.qualityInspectionDocUUID);
        this.qualityInspectionDocUUID = qualityInspectionDocUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StockIdentificationNumber</b>
     * </p>
     *
     * @param stockIdentificationNumber
     *            Identification Number of Stock
     */
    public void setStockIdentificationNumber( @Nullable final String stockIdentificationNumber )
    {
        rememberChangedField("StockIdentificationNumber", this.stockIdentificationNumber);
        this.stockIdentificationNumber = stockIdentificationNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReltdStockDocUUID</b>
     * </p>
     *
     * @param documentReltdStockDocUUID
     *            Doc. Identification for Document-Related Stocks
     */
    public void setDocumentReltdStockDocUUID( @Nullable final UUID documentReltdStockDocUUID )
    {
        rememberChangedField("DocumentReltdStockDocUUID", this.documentReltdStockDocUUID);
        this.documentReltdStockDocUUID = documentReltdStockDocUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReltdStockDocItemUUID</b>
     * </p>
     *
     * @param documentReltdStockDocItemUUID
     *            Document Item for Document-Related Stocks
     */
    public void setDocumentReltdStockDocItemUUID( @Nullable final UUID documentReltdStockDocItemUUID )
    {
        rememberChangedField("DocumentReltdStockDocItemUUID", this.documentReltdStockDocItemUUID);
        this.documentReltdStockDocItemUUID = documentReltdStockDocItemUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskGoodsReceiptDateTime</b>
     * </p>
     *
     * @param whseTaskGoodsReceiptDateTime
     *            Date and Time of Goods Receipt
     */
    public void setWhseTaskGoodsReceiptDateTime( @Nullable final ZonedDateTime whseTaskGoodsReceiptDateTime )
    {
        rememberChangedField("WhseTaskGoodsReceiptDateTime", this.whseTaskGoodsReceiptDateTime);
        this.whseTaskGoodsReceiptDateTime = whseTaskGoodsReceiptDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            Shelf Life Expiration Date
     */
    public void setShelfLifeExpirationDate( @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        rememberChangedField("ShelfLifeExpirationDate", this.shelfLifeExpirationDate);
        this.shelfLifeExpirationDate = shelfLifeExpirationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @param countryOfOrigin
     *            Country or Region of Origin
     */
    public void setCountryOfOrigin( @Nullable final String countryOfOrigin )
    {
        rememberChangedField("CountryOfOrigin", this.countryOfOrigin);
        this.countryOfOrigin = countryOfOrigin;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlBatchIsInRstrcdUseStock</b>
     * </p>
     *
     * @param matlBatchIsInRstrcdUseStock
     *            Batch in Restricted-Use Stock
     */
    public void setMatlBatchIsInRstrcdUseStock( @Nullable final Boolean matlBatchIsInRstrcdUseStock )
    {
        rememberChangedField("MatlBatchIsInRstrcdUseStock", this.matlBatchIsInRstrcdUseStock);
        this.matlBatchIsInRstrcdUseStock = matlBatchIsInRstrcdUseStock;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HndlgUnitItemCountedIsComplete</b>
     * </p>
     *
     * @param hndlgUnitItemCountedIsComplete
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setHndlgUnitItemCountedIsComplete( @Nullable final Boolean hndlgUnitItemCountedIsComplete )
    {
        rememberChangedField("HndlgUnitItemCountedIsComplete", this.hndlgUnitItemCountedIsComplete);
        this.hndlgUnitItemCountedIsComplete = hndlgUnitItemCountedIsComplete;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HndlgUnitItemCountedIsEmpty</b>
     * </p>
     *
     * @param hndlgUnitItemCountedIsEmpty
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setHndlgUnitItemCountedIsEmpty( @Nullable final Boolean hndlgUnitItemCountedIsEmpty )
    {
        rememberChangedField("HndlgUnitItemCountedIsEmpty", this.hndlgUnitItemCountedIsEmpty);
        this.hndlgUnitItemCountedIsEmpty = hndlgUnitItemCountedIsEmpty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HndlgUnitItemCountedIsNotExist</b>
     * </p>
     *
     * @param hndlgUnitItemCountedIsNotExist
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setHndlgUnitItemCountedIsNotExist( @Nullable final Boolean hndlgUnitItemCountedIsNotExist )
    {
        rememberChangedField("HndlgUnitItemCountedIsNotExist", this.hndlgUnitItemCountedIsNotExist);
        this.hndlgUnitItemCountedIsNotExist = hndlgUnitItemCountedIsNotExist;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     *
     * @param packagingMaterial
     *            Packaging Material
     */
    public void setPackagingMaterial( @Nullable final String packagingMaterial )
    {
        rememberChangedField("PackagingMaterial", this.packagingMaterial);
        this.packagingMaterial = packagingMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitType</b>
     * </p>
     *
     * @param handlingUnitType
     *            Handling Unit Type
     */
    public void setHandlingUnitType( @Nullable final String handlingUnitType )
    {
        rememberChangedField("HandlingUnitType", this.handlingUnitType);
        this.handlingUnitType = handlingUnitType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsEmpty</b>
     * </p>
     *
     * @param storageBinIsEmpty
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setStorageBinIsEmpty( @Nullable final Boolean storageBinIsEmpty )
    {
        rememberChangedField("StorageBinIsEmpty", this.storageBinIsEmpty);
        this.storageBinIsEmpty = storageBinIsEmpty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PInvIsZeroCount</b>
     * </p>
     *
     * @param pInvIsZeroCount
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setPInvIsZeroCount( @Nullable final Boolean pInvIsZeroCount )
    {
        rememberChangedField("PInvIsZeroCount", this.pInvIsZeroCount);
        this.pInvIsZeroCount = pInvIsZeroCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Inventory-Managed Unit of Measure
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Quantity Entered in Physical Inventory
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvItemChgUTCDateTime</b>
     * </p>
     *
     * @param pInvItemChgUTCDateTime
     *            LIME Internal Time Stamp (YYYYMMDDhhmmss,mmmuuun)
     */
    public void setPInvItemChgUTCDateTime( @Nullable final ZonedDateTime pInvItemChgUTCDateTime )
    {
        rememberChangedField("PInvItemChgUTCDateTime", this.pInvItemChgUTCDateTime);
        this.pInvItemChgUTCDateTime = pInvItemChgUTCDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhsePhysicalInventoryCountItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PhysicalInventoryDocumentUUID", getPhysicalInventoryDocumentUUID());
        result.put("PhysicalInventoryItemNumber", getPhysicalInventoryItemNumber());
        result.put("LineIndexOfPInvItem", getLineIndexOfPInvItem());
        result.put("PInvQuantitySequence", getPInvQuantitySequence());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PhysicalInventoryDocumentUUID", getPhysicalInventoryDocumentUUID());
        values.put("PhysicalInventoryItemNumber", getPhysicalInventoryItemNumber());
        values.put("LineIndexOfPInvItem", getLineIndexOfPInvItem());
        values.put("PInvQuantitySequence", getPInvQuantitySequence());
        values.put("PhysicalInventoryItemLevel", getPhysicalInventoryItemLevel());
        values.put("PInvItemParentType", getPInvItemParentType());
        values.put("StorageBin", getStorageBin());
        values.put("StorageType", getStorageType());
        values.put("ParentHandlingUnitNumber", getParentHandlingUnitNumber());
        values.put("PhysicalInventoryItemType", getPhysicalInventoryItemType());
        values.put("HandlingUnitNumber", getHandlingUnitNumber());
        values.put("Product", getProduct());
        values.put("ProductUUID", getProductUUID());
        values.put("BatchUUID", getBatchUUID());
        values.put("Batch", getBatch());
        values.put("SerialNumberRequiredLevel", getSerialNumberRequiredLevel());
        values.put("StockType", getStockType());
        values.put("StockOwner", getStockOwner());
        values.put("StockOwnerPartnerRole", getStockOwnerPartnerRole());
        values.put("StockUsage", getStockUsage());
        values.put("EntitledToDisposeParty", getEntitledToDisposeParty());
        values.put("EntitledToDisposePartnerRole", getEntitledToDisposePartnerRole());
        values.put("StockDocumentCategory", getStockDocumentCategory());
        values.put("StockDocumentNumber", getStockDocumentNumber());
        values.put("StockItemNumber", getStockItemNumber());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("DocumentReltdStockDocCat", getDocumentReltdStockDocCat());
        values.put("WhseQualityInspectionType", getWhseQualityInspectionType());
        values.put("QualityInspectionDocUUID", getQualityInspectionDocUUID());
        values.put("StockIdentificationNumber", getStockIdentificationNumber());
        values.put("DocumentReltdStockDocUUID", getDocumentReltdStockDocUUID());
        values.put("DocumentReltdStockDocItemUUID", getDocumentReltdStockDocItemUUID());
        values.put("WhseTaskGoodsReceiptDateTime", getWhseTaskGoodsReceiptDateTime());
        values.put("ShelfLifeExpirationDate", getShelfLifeExpirationDate());
        values.put("CountryOfOrigin", getCountryOfOrigin());
        values.put("MatlBatchIsInRstrcdUseStock", getMatlBatchIsInRstrcdUseStock());
        values.put("HndlgUnitItemCountedIsComplete", getHndlgUnitItemCountedIsComplete());
        values.put("HndlgUnitItemCountedIsEmpty", getHndlgUnitItemCountedIsEmpty());
        values.put("HndlgUnitItemCountedIsNotExist", getHndlgUnitItemCountedIsNotExist());
        values.put("PackagingMaterial", getPackagingMaterial());
        values.put("HandlingUnitType", getHandlingUnitType());
        values.put("StorageBinIsEmpty", getStorageBinIsEmpty());
        values.put("PInvIsZeroCount", getPInvIsZeroCount());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("PInvItemChgUTCDateTime", getPInvItemChgUTCDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PhysicalInventoryDocumentUUID") ) {
                final Object value = values.remove("PhysicalInventoryDocumentUUID");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocumentUUID())) ) {
                    setPhysicalInventoryDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("PhysicalInventoryItemNumber") ) {
                final Object value = values.remove("PhysicalInventoryItemNumber");
                if( (value == null) || (!value.equals(getPhysicalInventoryItemNumber())) ) {
                    setPhysicalInventoryItemNumber(((String) value));
                }
            }
            if( values.containsKey("LineIndexOfPInvItem") ) {
                final Object value = values.remove("LineIndexOfPInvItem");
                if( (value == null) || (!value.equals(getLineIndexOfPInvItem())) ) {
                    setLineIndexOfPInvItem(((Integer) value));
                }
            }
            if( values.containsKey("PInvQuantitySequence") ) {
                final Object value = values.remove("PInvQuantitySequence");
                if( (value == null) || (!value.equals(getPInvQuantitySequence())) ) {
                    setPInvQuantitySequence(((Integer) value));
                }
            }
            if( values.containsKey("PhysicalInventoryItemLevel") ) {
                final Object value = values.remove("PhysicalInventoryItemLevel");
                if( (value == null) || (!value.equals(getPhysicalInventoryItemLevel())) ) {
                    setPhysicalInventoryItemLevel(((Integer) value));
                }
            }
            if( values.containsKey("PInvItemParentType") ) {
                final Object value = values.remove("PInvItemParentType");
                if( (value == null) || (!value.equals(getPInvItemParentType())) ) {
                    setPInvItemParentType(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("ParentHandlingUnitNumber") ) {
                final Object value = values.remove("ParentHandlingUnitNumber");
                if( (value == null) || (!value.equals(getParentHandlingUnitNumber())) ) {
                    setParentHandlingUnitNumber(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryItemType") ) {
                final Object value = values.remove("PhysicalInventoryItemType");
                if( (value == null) || (!value.equals(getPhysicalInventoryItemType())) ) {
                    setPhysicalInventoryItemType(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitNumber") ) {
                final Object value = values.remove("HandlingUnitNumber");
                if( (value == null) || (!value.equals(getHandlingUnitNumber())) ) {
                    setHandlingUnitNumber(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ProductUUID") ) {
                final Object value = values.remove("ProductUUID");
                if( (value == null) || (!value.equals(getProductUUID())) ) {
                    setProductUUID(((UUID) value));
                }
            }
            if( values.containsKey("BatchUUID") ) {
                final Object value = values.remove("BatchUUID");
                if( (value == null) || (!value.equals(getBatchUUID())) ) {
                    setBatchUUID(((UUID) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("SerialNumberRequiredLevel") ) {
                final Object value = values.remove("SerialNumberRequiredLevel");
                if( (value == null) || (!value.equals(getSerialNumberRequiredLevel())) ) {
                    setSerialNumberRequiredLevel(((String) value));
                }
            }
            if( values.containsKey("StockType") ) {
                final Object value = values.remove("StockType");
                if( (value == null) || (!value.equals(getStockType())) ) {
                    setStockType(((String) value));
                }
            }
            if( values.containsKey("StockOwner") ) {
                final Object value = values.remove("StockOwner");
                if( (value == null) || (!value.equals(getStockOwner())) ) {
                    setStockOwner(((String) value));
                }
            }
            if( values.containsKey("StockOwnerPartnerRole") ) {
                final Object value = values.remove("StockOwnerPartnerRole");
                if( (value == null) || (!value.equals(getStockOwnerPartnerRole())) ) {
                    setStockOwnerPartnerRole(((String) value));
                }
            }
            if( values.containsKey("StockUsage") ) {
                final Object value = values.remove("StockUsage");
                if( (value == null) || (!value.equals(getStockUsage())) ) {
                    setStockUsage(((String) value));
                }
            }
            if( values.containsKey("EntitledToDisposeParty") ) {
                final Object value = values.remove("EntitledToDisposeParty");
                if( (value == null) || (!value.equals(getEntitledToDisposeParty())) ) {
                    setEntitledToDisposeParty(((String) value));
                }
            }
            if( values.containsKey("EntitledToDisposePartnerRole") ) {
                final Object value = values.remove("EntitledToDisposePartnerRole");
                if( (value == null) || (!value.equals(getEntitledToDisposePartnerRole())) ) {
                    setEntitledToDisposePartnerRole(((String) value));
                }
            }
            if( values.containsKey("StockDocumentCategory") ) {
                final Object value = values.remove("StockDocumentCategory");
                if( (value == null) || (!value.equals(getStockDocumentCategory())) ) {
                    setStockDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("StockDocumentNumber") ) {
                final Object value = values.remove("StockDocumentNumber");
                if( (value == null) || (!value.equals(getStockDocumentNumber())) ) {
                    setStockDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("StockItemNumber") ) {
                final Object value = values.remove("StockItemNumber");
                if( (value == null) || (!value.equals(getStockItemNumber())) ) {
                    setStockItemNumber(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("DocumentReltdStockDocCat") ) {
                final Object value = values.remove("DocumentReltdStockDocCat");
                if( (value == null) || (!value.equals(getDocumentReltdStockDocCat())) ) {
                    setDocumentReltdStockDocCat(((String) value));
                }
            }
            if( values.containsKey("WhseQualityInspectionType") ) {
                final Object value = values.remove("WhseQualityInspectionType");
                if( (value == null) || (!value.equals(getWhseQualityInspectionType())) ) {
                    setWhseQualityInspectionType(((String) value));
                }
            }
            if( values.containsKey("QualityInspectionDocUUID") ) {
                final Object value = values.remove("QualityInspectionDocUUID");
                if( (value == null) || (!value.equals(getQualityInspectionDocUUID())) ) {
                    setQualityInspectionDocUUID(((UUID) value));
                }
            }
            if( values.containsKey("StockIdentificationNumber") ) {
                final Object value = values.remove("StockIdentificationNumber");
                if( (value == null) || (!value.equals(getStockIdentificationNumber())) ) {
                    setStockIdentificationNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentReltdStockDocUUID") ) {
                final Object value = values.remove("DocumentReltdStockDocUUID");
                if( (value == null) || (!value.equals(getDocumentReltdStockDocUUID())) ) {
                    setDocumentReltdStockDocUUID(((UUID) value));
                }
            }
            if( values.containsKey("DocumentReltdStockDocItemUUID") ) {
                final Object value = values.remove("DocumentReltdStockDocItemUUID");
                if( (value == null) || (!value.equals(getDocumentReltdStockDocItemUUID())) ) {
                    setDocumentReltdStockDocItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("WhseTaskGoodsReceiptDateTime") ) {
                final Object value = values.remove("WhseTaskGoodsReceiptDateTime");
                if( (value == null) || (!value.equals(getWhseTaskGoodsReceiptDateTime())) ) {
                    setWhseTaskGoodsReceiptDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDate") ) {
                final Object value = values.remove("ShelfLifeExpirationDate");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDate())) ) {
                    setShelfLifeExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CountryOfOrigin") ) {
                final Object value = values.remove("CountryOfOrigin");
                if( (value == null) || (!value.equals(getCountryOfOrigin())) ) {
                    setCountryOfOrigin(((String) value));
                }
            }
            if( values.containsKey("MatlBatchIsInRstrcdUseStock") ) {
                final Object value = values.remove("MatlBatchIsInRstrcdUseStock");
                if( (value == null) || (!value.equals(getMatlBatchIsInRstrcdUseStock())) ) {
                    setMatlBatchIsInRstrcdUseStock(((Boolean) value));
                }
            }
            if( values.containsKey("HndlgUnitItemCountedIsComplete") ) {
                final Object value = values.remove("HndlgUnitItemCountedIsComplete");
                if( (value == null) || (!value.equals(getHndlgUnitItemCountedIsComplete())) ) {
                    setHndlgUnitItemCountedIsComplete(((Boolean) value));
                }
            }
            if( values.containsKey("HndlgUnitItemCountedIsEmpty") ) {
                final Object value = values.remove("HndlgUnitItemCountedIsEmpty");
                if( (value == null) || (!value.equals(getHndlgUnitItemCountedIsEmpty())) ) {
                    setHndlgUnitItemCountedIsEmpty(((Boolean) value));
                }
            }
            if( values.containsKey("HndlgUnitItemCountedIsNotExist") ) {
                final Object value = values.remove("HndlgUnitItemCountedIsNotExist");
                if( (value == null) || (!value.equals(getHndlgUnitItemCountedIsNotExist())) ) {
                    setHndlgUnitItemCountedIsNotExist(((Boolean) value));
                }
            }
            if( values.containsKey("PackagingMaterial") ) {
                final Object value = values.remove("PackagingMaterial");
                if( (value == null) || (!value.equals(getPackagingMaterial())) ) {
                    setPackagingMaterial(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitType") ) {
                final Object value = values.remove("HandlingUnitType");
                if( (value == null) || (!value.equals(getHandlingUnitType())) ) {
                    setHandlingUnitType(((String) value));
                }
            }
            if( values.containsKey("StorageBinIsEmpty") ) {
                final Object value = values.remove("StorageBinIsEmpty");
                if( (value == null) || (!value.equals(getStorageBinIsEmpty())) ) {
                    setStorageBinIsEmpty(((Boolean) value));
                }
            }
            if( values.containsKey("PInvIsZeroCount") ) {
                final Object value = values.remove("PInvIsZeroCount");
                if( (value == null) || (!value.equals(getPInvIsZeroCount())) ) {
                    setPInvIsZeroCount(((Boolean) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PInvItemChgUTCDateTime") ) {
                final Object value = values.remove("PInvItemChgUTCDateTime");
                if( (value == null) || (!value.equals(getPInvItemChgUTCDateTime())) ) {
                    setPInvItemChgUTCDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhsePhysicalInventoryItem") ) {
                final Object value = (values).remove("to_WhsePhysicalInventoryItem");
                if( value instanceof Map ) {
                    if( toWhsePhysicalInventoryItem == null ) {
                        toWhsePhysicalInventoryItem = new WhsePhysicalInventoryItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWhsePhysicalInventoryItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WhsePhysicalInventoryCountItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WhsePhysicalInventoryCountItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhsePhysicalInventoryCountItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhsePhysicalInventoryCountItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhsePhysicalInventoryItem != null ) {
            (values).put("to_WhsePhysicalInventoryItem", toWhsePhysicalInventoryItem);
        }
        return values;
    }

    /**
     * Fetches the <b>WhsePhysicalInventoryItem</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WhsePhysicalInventoryItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WhsePhysicalInventoryItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhsePhysicalInventoryItem fetchWhsePhysicalInventoryItem()
    {
        return fetchFieldAsSingle("to_WhsePhysicalInventoryItem", WhsePhysicalInventoryItem.class);
    }

    /**
     * Retrieval of associated <b>WhsePhysicalInventoryItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhsePhysicalInventoryItem</b>.
     * <p>
     * If the navigation property <b>to_WhsePhysicalInventoryItem</b> of a queried <b>WhsePhysicalInventoryCountItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhsePhysicalInventoryItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WhsePhysicalInventoryItem getWhsePhysicalInventoryItemOrFetch()
    {
        if( toWhsePhysicalInventoryItem == null ) {
            toWhsePhysicalInventoryItem = fetchWhsePhysicalInventoryItem();
        }
        return toWhsePhysicalInventoryItem;
    }

    /**
     * Retrieval of associated <b>WhsePhysicalInventoryItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_WhsePhysicalInventoryItem</b>.
     * <p>
     * If the navigation property for an entity <b>WhsePhysicalInventoryCountItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhsePhysicalInventoryItem</b> is already loaded, the
     *         result will contain the <b>WhsePhysicalInventoryItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WhsePhysicalInventoryItem> getWhsePhysicalInventoryItemIfPresent()
    {
        return Option.of(toWhsePhysicalInventoryItem);
    }

    /**
     * Overwrites the associated <b>WhsePhysicalInventoryItem</b> entity for the loaded navigation property
     * <b>to_WhsePhysicalInventoryItem</b>.
     *
     * @param value
     *            New <b>WhsePhysicalInventoryItem</b> entity.
     */
    public void setWhsePhysicalInventoryItem( final WhsePhysicalInventoryItem value )
    {
        toWhsePhysicalInventoryItem = value;
    }

    /**
     * Helper class to allow for fluent creation of WhsePhysicalInventoryCountItem instances.
     *
     */
    public final static class WhsePhysicalInventoryCountItemBuilder
    {

        private WhsePhysicalInventoryItem toWhsePhysicalInventoryItem;

        private WhsePhysicalInventoryCountItem.WhsePhysicalInventoryCountItemBuilder toWhsePhysicalInventoryItem(
            final WhsePhysicalInventoryItem value )
        {
            toWhsePhysicalInventoryItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_WhsePhysicalInventoryItem</b> for <b>WhsePhysicalInventoryCountItem</b> to single
         * <b>WhsePhysicalInventoryItem</b>.
         *
         * @param value
         *            The WhsePhysicalInventoryItem to build this WhsePhysicalInventoryCountItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhsePhysicalInventoryCountItem.WhsePhysicalInventoryCountItemBuilder whsePhysicalInventoryItem(
            final WhsePhysicalInventoryItem value )
        {
            return toWhsePhysicalInventoryItem(value);
        }

    }

}
