/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.selectable.WhsePhysicalInventoryCountItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
 * WhsePhysicalInventoryCountItem} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class WhsePhysicalInventoryCountItemByKeyFluentHelper
    extends
    FluentHelperByKey<WhsePhysicalInventoryCountItemByKeyFluentHelper, WhsePhysicalInventoryCountItem, WhsePhysicalInventoryCountItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     * WhsePhysicalInventoryCountItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WhsePhysicalInventoryCountItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code WhsePhysicalInventoryCountItem}
     * @param pInvQuantitySequence
     *            Row Index of Internal Tables
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param lineIndexOfPInvItem
     *            Row Index of Internal Tables
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param physicalInventoryItemNumber
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param physicalInventoryDocumentUUID
     *            GUID for Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public WhsePhysicalInventoryCountItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID physicalInventoryDocumentUUID,
        final String physicalInventoryItemNumber,
        final Integer lineIndexOfPInvItem,
        final Integer pInvQuantitySequence )
    {
        super(servicePath, entityCollection);
        this.key.put("PhysicalInventoryDocumentUUID", physicalInventoryDocumentUUID);
        this.key.put("PhysicalInventoryItemNumber", physicalInventoryItemNumber);
        this.key.put("LineIndexOfPInvItem", lineIndexOfPInvItem);
        this.key.put("PInvQuantitySequence", pInvQuantitySequence);
    }

    @Override
    @Nonnull
    protected Class<WhsePhysicalInventoryCountItem> getEntityClass()
    {
        return WhsePhysicalInventoryCountItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
