/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.field.WhsePhysicalInventoryItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.link.WhsePhysicalInventoryItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.selectable.WhsePhysicalInventoryItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Physical Inventory Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WhsePhysicalInventoryItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WhsePhysicalInventoryItem extends VdmEntity<WhsePhysicalInventoryItem>
{

    /**
     * Selector for all available fields of WhsePhysicalInventoryItem.
     *
     */
    public final static WhsePhysicalInventoryItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentUUID</b>
     * </p>
     *
     * @return GUID for Physical Inventory Document
     */
    @Key
    @SerializedName( "PhysicalInventoryDocumentUUID" )
    @JsonProperty( "PhysicalInventoryDocumentUUID" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocumentUUID" )
    private UUID physicalInventoryDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocumentUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<UUID> PHYSICAL_INVENTORY_DOCUMENT_UUID =
        new WhsePhysicalInventoryItemField<UUID>("PhysicalInventoryDocumentUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemNumber</b>
     * </p>
     *
     * @return Item
     */
    @Key
    @SerializedName( "PhysicalInventoryItemNumber" )
    @JsonProperty( "PhysicalInventoryItemNumber" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryItemNumber" )
    private String physicalInventoryItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryItemNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_ITEM_NUMBER =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocNumber</b>
     * </p>
     *
     * @return Physical Inventory Document Number
     */
    @SerializedName( "PhysicalInventoryDocNumber" )
    @JsonProperty( "PhysicalInventoryDocNumber" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocNumber" )
    private String physicalInventoryDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_DOC_NUMBER =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryDocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocYear</b>
     * </p>
     *
     * @return Document Year of Physical Inventory Document
     */
    @SerializedName( "PhysicalInventoryDocYear" )
    @JsonProperty( "PhysicalInventoryDocYear" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocYear" )
    private String physicalInventoryDocYear;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocYear</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_DOC_YEAR =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryDocYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentType</b>
     * </p>
     *
     * @return Physical Inventory Procedure (Document Type of Phys. Inv.)
     */
    @SerializedName( "PhysicalInventoryDocumentType" )
    @JsonProperty( "PhysicalInventoryDocumentType" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocumentType" )
    private String physicalInventoryDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocumentType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_DOCUMENT_TYPE =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReasonForPhysInvtryDifference</b>
     * </p>
     *
     * @return Reason for Physical Inventory/Inventory Difference
     */
    @SerializedName( "ReasonForPhysInvtryDifference" )
    @JsonProperty( "ReasonForPhysInvtryDifference" )
    @Nullable
    @ODataField( odataName = "ReasonForPhysInvtryDifference" )
    private String reasonForPhysInvtryDifference;
    /**
     * Use with available fluent helpers to apply the <b>ReasonForPhysInvtryDifference</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> REASON_FOR_PHYS_INVTRY_DIFFERENCE =
        new WhsePhysicalInventoryItemField<String>("ReasonForPhysInvtryDifference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @return Priority of Physical Inventory
     */
    @SerializedName( "PriorityCode" )
    @JsonProperty( "PriorityCode" )
    @Nullable
    @ODataField( odataName = "PriorityCode" )
    private String priorityCode;
    /**
     * Use with available fluent helpers to apply the <b>PriorityCode</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PRIORITY_CODE =
        new WhsePhysicalInventoryItemField<String>("PriorityCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryStatusText</b>
     * </p>
     *
     * @return Physical Inventory Status
     */
    @SerializedName( "PhysicalInventoryStatusText" )
    @JsonProperty( "PhysicalInventoryStatusText" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryStatusText" )
    private String physicalInventoryStatusText;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryStatusText</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_STATUS_TEXT =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryStatusText");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryCrtnUTCDateTime</b>
     * </p>
     *
     * @return Creation Date of Physical Inventory Doc. Item (Time Stamp)
     */
    @SerializedName( "PhysInventoryCrtnUTCDateTime" )
    @JsonProperty( "PhysInventoryCrtnUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PhysInventoryCrtnUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime physInventoryCrtnUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PhysInventoryCrtnUTCDateTime</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<ZonedDateTime> PHYS_INVENTORY_CRTN_UTC_DATE_TIME =
        new WhsePhysicalInventoryItemField<ZonedDateTime>("PhysInventoryCrtnUTCDateTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvCountedUTCDateTime</b>
     * </p>
     *
     * @return Entered Date of Physical Inventory Count (Time Stamp)
     */
    @SerializedName( "PInvCountedUTCDateTime" )
    @JsonProperty( "PInvCountedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PInvCountedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime pInvCountedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PInvCountedUTCDateTime</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<ZonedDateTime> P_INV_COUNTED_UTC_DATE_TIME =
        new WhsePhysicalInventoryItemField<ZonedDateTime>("PInvCountedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryCountUserName</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "PhysicalInventoryCountUserName" )
    @JsonProperty( "PhysicalInventoryCountUserName" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryCountUserName" )
    private String physicalInventoryCountUserName;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryCountUserName</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_COUNT_USER_NAME =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryCountUserName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrder</b>
     * </p>
     *
     * @return Warehouse Order Number
     */
    @SerializedName( "WarehouseOrder" )
    @JsonProperty( "WarehouseOrder" )
    @Nullable
    @ODataField( odataName = "WarehouseOrder" )
    private String warehouseOrder;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseOrder</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> WAREHOUSE_ORDER =
        new WhsePhysicalInventoryItemField<String>("WarehouseOrder");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PInvDocumentItemIsPrinted</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "PInvDocumentItemIsPrinted" )
    @JsonProperty( "PInvDocumentItemIsPrinted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PInvDocumentItemIsPrinted" )
    private Boolean pInvDocumentItemIsPrinted;
    /**
     * Use with available fluent helpers to apply the <b>PInvDocumentItemIsPrinted</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<Boolean> P_INV_DOCUMENT_ITEM_IS_PRINTED =
        new WhsePhysicalInventoryItemField<Boolean>("PInvDocumentItemIsPrinted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryIsBlock</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "PhysicalInventoryIsBlock" )
    @JsonProperty( "PhysicalInventoryIsBlock" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PhysicalInventoryIsBlock" )
    private Boolean physicalInventoryIsBlock;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryIsBlock</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<Boolean> PHYSICAL_INVENTORY_IS_BLOCK =
        new WhsePhysicalInventoryItemField<Boolean>("PhysicalInventoryIsBlock");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PInvBookQuantityIsFreeze</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "PInvBookQuantityIsFreeze" )
    @JsonProperty( "PInvBookQuantityIsFreeze" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PInvBookQuantityIsFreeze" )
    private Boolean pInvBookQuantityIsFreeze;
    /**
     * Use with available fluent helpers to apply the <b>PInvBookQuantityIsFreeze</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<Boolean> P_INV_BOOK_QUANTITY_IS_FREEZE =
        new WhsePhysicalInventoryItemField<Boolean>("PInvBookQuantityIsFreeze");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> WAREHOUSE =
        new WhsePhysicalInventoryItemField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STORAGE_TYPE =
        new WhsePhysicalInventoryItemField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STORAGE_BIN =
        new WhsePhysicalInventoryItemField<String>("StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryArea</b>
     * </p>
     *
     * @return Physical Inventory Area
     */
    @SerializedName( "PhysicalInventoryArea" )
    @JsonProperty( "PhysicalInventoryArea" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryArea" )
    private String physicalInventoryArea;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryArea</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_AREA =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ActivityArea</b>
     * </p>
     *
     * @return Activity Area
     */
    @SerializedName( "ActivityArea" )
    @JsonProperty( "ActivityArea" )
    @Nullable
    @ODataField( odataName = "ActivityArea" )
    private String activityArea;
    /**
     * Use with available fluent helpers to apply the <b>ActivityArea</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> ACTIVITY_AREA =
        new WhsePhysicalInventoryItemField<String>("ActivityArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductUUID</b>
     * </p>
     *
     * @return Product UUID
     */
    @SerializedName( "ProductUUID" )
    @JsonProperty( "ProductUUID" )
    @Nullable
    @ODataField( odataName = "ProductUUID" )
    private UUID productUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<UUID> PRODUCT_UUID =
        new WhsePhysicalInventoryItemField<UUID>("ProductUUID");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PRODUCT =
        new WhsePhysicalInventoryItemField<String>("Product");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchUUID</b>
     * </p>
     *
     * @return Batch
     */
    @SerializedName( "BatchUUID" )
    @JsonProperty( "BatchUUID" )
    @Nullable
    @ODataField( odataName = "BatchUUID" )
    private UUID batchUUID;
    /**
     * Use with available fluent helpers to apply the <b>BatchUUID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<UUID> BATCH_UUID =
        new WhsePhysicalInventoryItemField<UUID>("BatchUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> BATCH =
        new WhsePhysicalInventoryItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "StockType" )
    @JsonProperty( "StockType" )
    @Nullable
    @ODataField( odataName = "StockType" )
    private String stockType;
    /**
     * Use with available fluent helpers to apply the <b>StockType</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STOCK_TYPE =
        new WhsePhysicalInventoryItemField<String>("StockType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @return Stock Usage
     */
    @SerializedName( "StockUsage" )
    @JsonProperty( "StockUsage" )
    @Nullable
    @ODataField( odataName = "StockUsage" )
    private String stockUsage;
    /**
     * Use with available fluent helpers to apply the <b>StockUsage</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STOCK_USAGE =
        new WhsePhysicalInventoryItemField<String>("StockUsage");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @return Owner
     */
    @SerializedName( "StockOwner" )
    @JsonProperty( "StockOwner" )
    @Nullable
    @ODataField( odataName = "StockOwner" )
    private String stockOwner;
    /**
     * Use with available fluent helpers to apply the <b>StockOwner</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STOCK_OWNER =
        new WhsePhysicalInventoryItemField<String>("StockOwner");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockOwnerName</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "StockOwnerName" )
    @JsonProperty( "StockOwnerName" )
    @Nullable
    @ODataField( odataName = "StockOwnerName" )
    private String stockOwnerName;
    /**
     * Use with available fluent helpers to apply the <b>StockOwnerName</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STOCK_OWNER_NAME =
        new WhsePhysicalInventoryItemField<String>("StockOwnerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @return Party Entitled to Dispose
     */
    @SerializedName( "EntitledToDisposeParty" )
    @JsonProperty( "EntitledToDisposeParty" )
    @Nullable
    @ODataField( odataName = "EntitledToDisposeParty" )
    private String entitledToDisposeParty;
    /**
     * Use with available fluent helpers to apply the <b>EntitledToDisposeParty</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> ENTITLED_TO_DISPOSE_PARTY =
        new WhsePhysicalInventoryItemField<String>("EntitledToDisposeParty");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NameOfEntitledToDisposeParty</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "NameOfEntitledToDisposeParty" )
    @JsonProperty( "NameOfEntitledToDisposeParty" )
    @Nullable
    @ODataField( odataName = "NameOfEntitledToDisposeParty" )
    private String nameOfEntitledToDisposeParty;
    /**
     * Use with available fluent helpers to apply the <b>NameOfEntitledToDisposeParty</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> NAME_OF_ENTITLED_TO_DISPOSE_PARTY =
        new WhsePhysicalInventoryItemField<String>("NameOfEntitledToDisposeParty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @return Special Reference Stock Type
     */
    @SerializedName( "StockDocumentCategory" )
    @JsonProperty( "StockDocumentCategory" )
    @Nullable
    @ODataField( odataName = "StockDocumentCategory" )
    private String stockDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentCategory</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STOCK_DOCUMENT_CATEGORY =
        new WhsePhysicalInventoryItemField<String>("StockDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @return Reference Document for Special Reference Stock
     */
    @SerializedName( "StockDocumentNumber" )
    @JsonProperty( "StockDocumentNumber" )
    @Nullable
    @ODataField( odataName = "StockDocumentNumber" )
    private String stockDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STOCK_DOCUMENT_NUMBER =
        new WhsePhysicalInventoryItemField<String>("StockDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @return Sales Order Item for Sales Order Stock
     */
    @SerializedName( "StockItemNumber" )
    @JsonProperty( "StockItemNumber" )
    @Nullable
    @ODataField( odataName = "StockItemNumber" )
    private String stockItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockItemNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> STOCK_ITEM_NUMBER =
        new WhsePhysicalInventoryItemField<String>("StockItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new WhsePhysicalInventoryItemField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryRefDocYear</b>
     * </p>
     *
     * @return Document Year of Physical Inventory Document
     */
    @SerializedName( "PhysicalInventoryRefDocYear" )
    @JsonProperty( "PhysicalInventoryRefDocYear" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryRefDocYear" )
    private String physicalInventoryRefDocYear;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryRefDocYear</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_REF_DOC_YEAR =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryRefDocYear");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryRefDocNumber</b>
     * </p>
     *
     * @return Physical Inventory Document Number
     */
    @SerializedName( "PhysicalInventoryRefDocNumber" )
    @JsonProperty( "PhysicalInventoryRefDocNumber" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryRefDocNumber" )
    private String physicalInventoryRefDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryRefDocNumber</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_REF_DOC_NUMBER =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryRefDocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryRefDocItem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "PhysicalInventoryRefDocItem" )
    @JsonProperty( "PhysicalInventoryRefDocItem" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryRefDocItem" )
    private String physicalInventoryRefDocItem;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryRefDocItem</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> PHYSICAL_INVENTORY_REF_DOC_ITEM =
        new WhsePhysicalInventoryItemField<String>("PhysicalInventoryRefDocItem");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>PInvFreeDefinedRefText</b>
     * </p>
     *
     * @return Document ID of Reference Document
     */
    @SerializedName( "PInvFreeDefinedRefText" )
    @JsonProperty( "PInvFreeDefinedRefText" )
    @Nullable
    @ODataField( odataName = "PInvFreeDefinedRefText" )
    private String pInvFreeDefinedRefText;
    /**
     * Use with available fluent helpers to apply the <b>PInvFreeDefinedRefText</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<String> P_INV_FREE_DEFINED_REF_TEXT =
        new WhsePhysicalInventoryItemField<String>("PInvFreeDefinedRefText");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvItemChgUTCDateTime</b>
     * </p>
     *
     * @return LIME Internal Time Stamp (YYYYMMDDhhmmss,mmmuuun)
     */
    @SerializedName( "PInvItemChgUTCDateTime" )
    @JsonProperty( "PInvItemChgUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PInvItemChgUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime pInvItemChgUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PInvItemChgUTCDateTime</b> field to query operations.
     *
     */
    public final static WhsePhysicalInventoryItemField<ZonedDateTime> P_INV_ITEM_CHG_UTC_DATE_TIME =
        new WhsePhysicalInventoryItemField<ZonedDateTime>("PInvItemChgUTCDateTime");
    /**
     * Navigation property <b>to_WhsePhysicalInventoryCntItem</b> for <b>WhsePhysicalInventoryItem</b> to multiple
     * <b>WhsePhysicalInventoryCountItem</b>.
     *
     */
    @SerializedName( "to_WhsePhysicalInventoryCntItem" )
    @JsonProperty( "to_WhsePhysicalInventoryCntItem" )
    @ODataField( odataName = "to_WhsePhysicalInventoryCntItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WhsePhysicalInventoryCountItem> toWhsePhysicalInventoryCntItem;
    /**
     * Use with available fluent helpers to apply the <b>to_WhsePhysicalInventoryCntItem</b> navigation property to
     * query operations.
     *
     */
    public final static WhsePhysicalInventoryItemLink<WhsePhysicalInventoryCountItem> TO_WHSE_PHYSICAL_INVENTORY_CNT_ITEM =
        new WhsePhysicalInventoryItemLink<WhsePhysicalInventoryCountItem>("to_WhsePhysicalInventoryCntItem");

    @Nonnull
    @Override
    public Class<WhsePhysicalInventoryItem> getType()
    {
        return WhsePhysicalInventoryItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentUUID</b>
     * </p>
     *
     * @param physicalInventoryDocumentUUID
     *            GUID for Physical Inventory Document
     */
    public void setPhysicalInventoryDocumentUUID( @Nullable final UUID physicalInventoryDocumentUUID )
    {
        rememberChangedField("PhysicalInventoryDocumentUUID", this.physicalInventoryDocumentUUID);
        this.physicalInventoryDocumentUUID = physicalInventoryDocumentUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemNumber</b>
     * </p>
     *
     * @param physicalInventoryItemNumber
     *            Item
     */
    public void setPhysicalInventoryItemNumber( @Nullable final String physicalInventoryItemNumber )
    {
        rememberChangedField("PhysicalInventoryItemNumber", this.physicalInventoryItemNumber);
        this.physicalInventoryItemNumber = physicalInventoryItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocNumber</b>
     * </p>
     *
     * @param physicalInventoryDocNumber
     *            Physical Inventory Document Number
     */
    public void setPhysicalInventoryDocNumber( @Nullable final String physicalInventoryDocNumber )
    {
        rememberChangedField("PhysicalInventoryDocNumber", this.physicalInventoryDocNumber);
        this.physicalInventoryDocNumber = physicalInventoryDocNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocYear</b>
     * </p>
     *
     * @param physicalInventoryDocYear
     *            Document Year of Physical Inventory Document
     */
    public void setPhysicalInventoryDocYear( @Nullable final String physicalInventoryDocYear )
    {
        rememberChangedField("PhysicalInventoryDocYear", this.physicalInventoryDocYear);
        this.physicalInventoryDocYear = physicalInventoryDocYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentType</b>
     * </p>
     *
     * @param physicalInventoryDocumentType
     *            Physical Inventory Procedure (Document Type of Phys. Inv.)
     */
    public void setPhysicalInventoryDocumentType( @Nullable final String physicalInventoryDocumentType )
    {
        rememberChangedField("PhysicalInventoryDocumentType", this.physicalInventoryDocumentType);
        this.physicalInventoryDocumentType = physicalInventoryDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReasonForPhysInvtryDifference</b>
     * </p>
     *
     * @param reasonForPhysInvtryDifference
     *            Reason for Physical Inventory/Inventory Difference
     */
    public void setReasonForPhysInvtryDifference( @Nullable final String reasonForPhysInvtryDifference )
    {
        rememberChangedField("ReasonForPhysInvtryDifference", this.reasonForPhysInvtryDifference);
        this.reasonForPhysInvtryDifference = reasonForPhysInvtryDifference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @param priorityCode
     *            Priority of Physical Inventory
     */
    public void setPriorityCode( @Nullable final String priorityCode )
    {
        rememberChangedField("PriorityCode", this.priorityCode);
        this.priorityCode = priorityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryStatusText</b>
     * </p>
     *
     * @param physicalInventoryStatusText
     *            Physical Inventory Status
     */
    public void setPhysicalInventoryStatusText( @Nullable final String physicalInventoryStatusText )
    {
        rememberChangedField("PhysicalInventoryStatusText", this.physicalInventoryStatusText);
        this.physicalInventoryStatusText = physicalInventoryStatusText;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryCrtnUTCDateTime</b>
     * </p>
     *
     * @param physInventoryCrtnUTCDateTime
     *            Creation Date of Physical Inventory Doc. Item (Time Stamp)
     */
    public void setPhysInventoryCrtnUTCDateTime( @Nullable final ZonedDateTime physInventoryCrtnUTCDateTime )
    {
        rememberChangedField("PhysInventoryCrtnUTCDateTime", this.physInventoryCrtnUTCDateTime);
        this.physInventoryCrtnUTCDateTime = physInventoryCrtnUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvCountedUTCDateTime</b>
     * </p>
     *
     * @param pInvCountedUTCDateTime
     *            Entered Date of Physical Inventory Count (Time Stamp)
     */
    public void setPInvCountedUTCDateTime( @Nullable final ZonedDateTime pInvCountedUTCDateTime )
    {
        rememberChangedField("PInvCountedUTCDateTime", this.pInvCountedUTCDateTime);
        this.pInvCountedUTCDateTime = pInvCountedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryCountUserName</b>
     * </p>
     *
     * @param physicalInventoryCountUserName
     *            User Name
     */
    public void setPhysicalInventoryCountUserName( @Nullable final String physicalInventoryCountUserName )
    {
        rememberChangedField("PhysicalInventoryCountUserName", this.physicalInventoryCountUserName);
        this.physicalInventoryCountUserName = physicalInventoryCountUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrder</b>
     * </p>
     *
     * @param warehouseOrder
     *            Warehouse Order Number
     */
    public void setWarehouseOrder( @Nullable final String warehouseOrder )
    {
        rememberChangedField("WarehouseOrder", this.warehouseOrder);
        this.warehouseOrder = warehouseOrder;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PInvDocumentItemIsPrinted</b>
     * </p>
     *
     * @param pInvDocumentItemIsPrinted
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setPInvDocumentItemIsPrinted( @Nullable final Boolean pInvDocumentItemIsPrinted )
    {
        rememberChangedField("PInvDocumentItemIsPrinted", this.pInvDocumentItemIsPrinted);
        this.pInvDocumentItemIsPrinted = pInvDocumentItemIsPrinted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryIsBlock</b>
     * </p>
     *
     * @param physicalInventoryIsBlock
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setPhysicalInventoryIsBlock( @Nullable final Boolean physicalInventoryIsBlock )
    {
        rememberChangedField("PhysicalInventoryIsBlock", this.physicalInventoryIsBlock);
        this.physicalInventoryIsBlock = physicalInventoryIsBlock;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PInvBookQuantityIsFreeze</b>
     * </p>
     *
     * @param pInvBookQuantityIsFreeze
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setPInvBookQuantityIsFreeze( @Nullable final Boolean pInvBookQuantityIsFreeze )
    {
        rememberChangedField("PInvBookQuantityIsFreeze", this.pInvBookQuantityIsFreeze);
        this.pInvBookQuantityIsFreeze = pInvBookQuantityIsFreeze;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryArea</b>
     * </p>
     *
     * @param physicalInventoryArea
     *            Physical Inventory Area
     */
    public void setPhysicalInventoryArea( @Nullable final String physicalInventoryArea )
    {
        rememberChangedField("PhysicalInventoryArea", this.physicalInventoryArea);
        this.physicalInventoryArea = physicalInventoryArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ActivityArea</b>
     * </p>
     *
     * @param activityArea
     *            Activity Area
     */
    public void setActivityArea( @Nullable final String activityArea )
    {
        rememberChangedField("ActivityArea", this.activityArea);
        this.activityArea = activityArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductUUID</b>
     * </p>
     *
     * @param productUUID
     *            Product UUID
     */
    public void setProductUUID( @Nullable final UUID productUUID )
    {
        rememberChangedField("ProductUUID", this.productUUID);
        this.productUUID = productUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchUUID</b>
     * </p>
     *
     * @param batchUUID
     *            Batch
     */
    public void setBatchUUID( @Nullable final UUID batchUUID )
    {
        rememberChangedField("BatchUUID", this.batchUUID);
        this.batchUUID = batchUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @param stockType
     *            Stock Type
     */
    public void setStockType( @Nullable final String stockType )
    {
        rememberChangedField("StockType", this.stockType);
        this.stockType = stockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockUsage</b>
     * </p>
     *
     * @param stockUsage
     *            Stock Usage
     */
    public void setStockUsage( @Nullable final String stockUsage )
    {
        rememberChangedField("StockUsage", this.stockUsage);
        this.stockUsage = stockUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @param stockOwner
     *            Owner
     */
    public void setStockOwner( @Nullable final String stockOwner )
    {
        rememberChangedField("StockOwner", this.stockOwner);
        this.stockOwner = stockOwner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockOwnerName</b>
     * </p>
     *
     * @param stockOwnerName
     *            Name 1 of organization
     */
    public void setStockOwnerName( @Nullable final String stockOwnerName )
    {
        rememberChangedField("StockOwnerName", this.stockOwnerName);
        this.stockOwnerName = stockOwnerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @param entitledToDisposeParty
     *            Party Entitled to Dispose
     */
    public void setEntitledToDisposeParty( @Nullable final String entitledToDisposeParty )
    {
        rememberChangedField("EntitledToDisposeParty", this.entitledToDisposeParty);
        this.entitledToDisposeParty = entitledToDisposeParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NameOfEntitledToDisposeParty</b>
     * </p>
     *
     * @param nameOfEntitledToDisposeParty
     *            Name 1 of organization
     */
    public void setNameOfEntitledToDisposeParty( @Nullable final String nameOfEntitledToDisposeParty )
    {
        rememberChangedField("NameOfEntitledToDisposeParty", this.nameOfEntitledToDisposeParty);
        this.nameOfEntitledToDisposeParty = nameOfEntitledToDisposeParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @param stockDocumentCategory
     *            Special Reference Stock Type
     */
    public void setStockDocumentCategory( @Nullable final String stockDocumentCategory )
    {
        rememberChangedField("StockDocumentCategory", this.stockDocumentCategory);
        this.stockDocumentCategory = stockDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @param stockDocumentNumber
     *            Reference Document for Special Reference Stock
     */
    public void setStockDocumentNumber( @Nullable final String stockDocumentNumber )
    {
        rememberChangedField("StockDocumentNumber", this.stockDocumentNumber);
        this.stockDocumentNumber = stockDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @param stockItemNumber
     *            Sales Order Item for Sales Order Stock
     */
    public void setStockItemNumber( @Nullable final String stockItemNumber )
    {
        rememberChangedField("StockItemNumber", this.stockItemNumber);
        this.stockItemNumber = stockItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryRefDocYear</b>
     * </p>
     *
     * @param physicalInventoryRefDocYear
     *            Document Year of Physical Inventory Document
     */
    public void setPhysicalInventoryRefDocYear( @Nullable final String physicalInventoryRefDocYear )
    {
        rememberChangedField("PhysicalInventoryRefDocYear", this.physicalInventoryRefDocYear);
        this.physicalInventoryRefDocYear = physicalInventoryRefDocYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryRefDocNumber</b>
     * </p>
     *
     * @param physicalInventoryRefDocNumber
     *            Physical Inventory Document Number
     */
    public void setPhysicalInventoryRefDocNumber( @Nullable final String physicalInventoryRefDocNumber )
    {
        rememberChangedField("PhysicalInventoryRefDocNumber", this.physicalInventoryRefDocNumber);
        this.physicalInventoryRefDocNumber = physicalInventoryRefDocNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryRefDocItem</b>
     * </p>
     *
     * @param physicalInventoryRefDocItem
     *            Item
     */
    public void setPhysicalInventoryRefDocItem( @Nullable final String physicalInventoryRefDocItem )
    {
        rememberChangedField("PhysicalInventoryRefDocItem", this.physicalInventoryRefDocItem);
        this.physicalInventoryRefDocItem = physicalInventoryRefDocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>PInvFreeDefinedRefText</b>
     * </p>
     *
     * @param pInvFreeDefinedRefText
     *            Document ID of Reference Document
     */
    public void setPInvFreeDefinedRefText( @Nullable final String pInvFreeDefinedRefText )
    {
        rememberChangedField("PInvFreeDefinedRefText", this.pInvFreeDefinedRefText);
        this.pInvFreeDefinedRefText = pInvFreeDefinedRefText;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvItemChgUTCDateTime</b>
     * </p>
     *
     * @param pInvItemChgUTCDateTime
     *            LIME Internal Time Stamp (YYYYMMDDhhmmss,mmmuuun)
     */
    public void setPInvItemChgUTCDateTime( @Nullable final ZonedDateTime pInvItemChgUTCDateTime )
    {
        rememberChangedField("PInvItemChgUTCDateTime", this.pInvItemChgUTCDateTime);
        this.pInvItemChgUTCDateTime = pInvItemChgUTCDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WhsePhysicalInventoryItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PhysicalInventoryDocumentUUID", getPhysicalInventoryDocumentUUID());
        result.put("PhysicalInventoryItemNumber", getPhysicalInventoryItemNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PhysicalInventoryDocumentUUID", getPhysicalInventoryDocumentUUID());
        values.put("PhysicalInventoryItemNumber", getPhysicalInventoryItemNumber());
        values.put("PhysicalInventoryDocNumber", getPhysicalInventoryDocNumber());
        values.put("PhysicalInventoryDocYear", getPhysicalInventoryDocYear());
        values.put("PhysicalInventoryDocumentType", getPhysicalInventoryDocumentType());
        values.put("ReasonForPhysInvtryDifference", getReasonForPhysInvtryDifference());
        values.put("PriorityCode", getPriorityCode());
        values.put("PhysicalInventoryStatusText", getPhysicalInventoryStatusText());
        values.put("PhysInventoryCrtnUTCDateTime", getPhysInventoryCrtnUTCDateTime());
        values.put("PInvCountedUTCDateTime", getPInvCountedUTCDateTime());
        values.put("PhysicalInventoryCountUserName", getPhysicalInventoryCountUserName());
        values.put("WarehouseOrder", getWarehouseOrder());
        values.put("PInvDocumentItemIsPrinted", getPInvDocumentItemIsPrinted());
        values.put("PhysicalInventoryIsBlock", getPhysicalInventoryIsBlock());
        values.put("PInvBookQuantityIsFreeze", getPInvBookQuantityIsFreeze());
        values.put("Warehouse", getWarehouse());
        values.put("StorageType", getStorageType());
        values.put("StorageBin", getStorageBin());
        values.put("PhysicalInventoryArea", getPhysicalInventoryArea());
        values.put("ActivityArea", getActivityArea());
        values.put("ProductUUID", getProductUUID());
        values.put("Product", getProduct());
        values.put("BatchUUID", getBatchUUID());
        values.put("Batch", getBatch());
        values.put("StockType", getStockType());
        values.put("StockUsage", getStockUsage());
        values.put("StockOwner", getStockOwner());
        values.put("StockOwnerName", getStockOwnerName());
        values.put("EntitledToDisposeParty", getEntitledToDisposeParty());
        values.put("NameOfEntitledToDisposeParty", getNameOfEntitledToDisposeParty());
        values.put("StockDocumentCategory", getStockDocumentCategory());
        values.put("StockDocumentNumber", getStockDocumentNumber());
        values.put("StockItemNumber", getStockItemNumber());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("PhysicalInventoryRefDocYear", getPhysicalInventoryRefDocYear());
        values.put("PhysicalInventoryRefDocNumber", getPhysicalInventoryRefDocNumber());
        values.put("PhysicalInventoryRefDocItem", getPhysicalInventoryRefDocItem());
        values.put("PInvFreeDefinedRefText", getPInvFreeDefinedRefText());
        values.put("PInvItemChgUTCDateTime", getPInvItemChgUTCDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PhysicalInventoryDocumentUUID") ) {
                final Object value = values.remove("PhysicalInventoryDocumentUUID");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocumentUUID())) ) {
                    setPhysicalInventoryDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("PhysicalInventoryItemNumber") ) {
                final Object value = values.remove("PhysicalInventoryItemNumber");
                if( (value == null) || (!value.equals(getPhysicalInventoryItemNumber())) ) {
                    setPhysicalInventoryItemNumber(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocNumber") ) {
                final Object value = values.remove("PhysicalInventoryDocNumber");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocNumber())) ) {
                    setPhysicalInventoryDocNumber(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocYear") ) {
                final Object value = values.remove("PhysicalInventoryDocYear");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocYear())) ) {
                    setPhysicalInventoryDocYear(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocumentType") ) {
                final Object value = values.remove("PhysicalInventoryDocumentType");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocumentType())) ) {
                    setPhysicalInventoryDocumentType(((String) value));
                }
            }
            if( values.containsKey("ReasonForPhysInvtryDifference") ) {
                final Object value = values.remove("ReasonForPhysInvtryDifference");
                if( (value == null) || (!value.equals(getReasonForPhysInvtryDifference())) ) {
                    setReasonForPhysInvtryDifference(((String) value));
                }
            }
            if( values.containsKey("PriorityCode") ) {
                final Object value = values.remove("PriorityCode");
                if( (value == null) || (!value.equals(getPriorityCode())) ) {
                    setPriorityCode(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryStatusText") ) {
                final Object value = values.remove("PhysicalInventoryStatusText");
                if( (value == null) || (!value.equals(getPhysicalInventoryStatusText())) ) {
                    setPhysicalInventoryStatusText(((String) value));
                }
            }
            if( values.containsKey("PhysInventoryCrtnUTCDateTime") ) {
                final Object value = values.remove("PhysInventoryCrtnUTCDateTime");
                if( (value == null) || (!value.equals(getPhysInventoryCrtnUTCDateTime())) ) {
                    setPhysInventoryCrtnUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PInvCountedUTCDateTime") ) {
                final Object value = values.remove("PInvCountedUTCDateTime");
                if( (value == null) || (!value.equals(getPInvCountedUTCDateTime())) ) {
                    setPInvCountedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PhysicalInventoryCountUserName") ) {
                final Object value = values.remove("PhysicalInventoryCountUserName");
                if( (value == null) || (!value.equals(getPhysicalInventoryCountUserName())) ) {
                    setPhysicalInventoryCountUserName(((String) value));
                }
            }
            if( values.containsKey("WarehouseOrder") ) {
                final Object value = values.remove("WarehouseOrder");
                if( (value == null) || (!value.equals(getWarehouseOrder())) ) {
                    setWarehouseOrder(((String) value));
                }
            }
            if( values.containsKey("PInvDocumentItemIsPrinted") ) {
                final Object value = values.remove("PInvDocumentItemIsPrinted");
                if( (value == null) || (!value.equals(getPInvDocumentItemIsPrinted())) ) {
                    setPInvDocumentItemIsPrinted(((Boolean) value));
                }
            }
            if( values.containsKey("PhysicalInventoryIsBlock") ) {
                final Object value = values.remove("PhysicalInventoryIsBlock");
                if( (value == null) || (!value.equals(getPhysicalInventoryIsBlock())) ) {
                    setPhysicalInventoryIsBlock(((Boolean) value));
                }
            }
            if( values.containsKey("PInvBookQuantityIsFreeze") ) {
                final Object value = values.remove("PInvBookQuantityIsFreeze");
                if( (value == null) || (!value.equals(getPInvBookQuantityIsFreeze())) ) {
                    setPInvBookQuantityIsFreeze(((Boolean) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryArea") ) {
                final Object value = values.remove("PhysicalInventoryArea");
                if( (value == null) || (!value.equals(getPhysicalInventoryArea())) ) {
                    setPhysicalInventoryArea(((String) value));
                }
            }
            if( values.containsKey("ActivityArea") ) {
                final Object value = values.remove("ActivityArea");
                if( (value == null) || (!value.equals(getActivityArea())) ) {
                    setActivityArea(((String) value));
                }
            }
            if( values.containsKey("ProductUUID") ) {
                final Object value = values.remove("ProductUUID");
                if( (value == null) || (!value.equals(getProductUUID())) ) {
                    setProductUUID(((UUID) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("BatchUUID") ) {
                final Object value = values.remove("BatchUUID");
                if( (value == null) || (!value.equals(getBatchUUID())) ) {
                    setBatchUUID(((UUID) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("StockType") ) {
                final Object value = values.remove("StockType");
                if( (value == null) || (!value.equals(getStockType())) ) {
                    setStockType(((String) value));
                }
            }
            if( values.containsKey("StockUsage") ) {
                final Object value = values.remove("StockUsage");
                if( (value == null) || (!value.equals(getStockUsage())) ) {
                    setStockUsage(((String) value));
                }
            }
            if( values.containsKey("StockOwner") ) {
                final Object value = values.remove("StockOwner");
                if( (value == null) || (!value.equals(getStockOwner())) ) {
                    setStockOwner(((String) value));
                }
            }
            if( values.containsKey("StockOwnerName") ) {
                final Object value = values.remove("StockOwnerName");
                if( (value == null) || (!value.equals(getStockOwnerName())) ) {
                    setStockOwnerName(((String) value));
                }
            }
            if( values.containsKey("EntitledToDisposeParty") ) {
                final Object value = values.remove("EntitledToDisposeParty");
                if( (value == null) || (!value.equals(getEntitledToDisposeParty())) ) {
                    setEntitledToDisposeParty(((String) value));
                }
            }
            if( values.containsKey("NameOfEntitledToDisposeParty") ) {
                final Object value = values.remove("NameOfEntitledToDisposeParty");
                if( (value == null) || (!value.equals(getNameOfEntitledToDisposeParty())) ) {
                    setNameOfEntitledToDisposeParty(((String) value));
                }
            }
            if( values.containsKey("StockDocumentCategory") ) {
                final Object value = values.remove("StockDocumentCategory");
                if( (value == null) || (!value.equals(getStockDocumentCategory())) ) {
                    setStockDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("StockDocumentNumber") ) {
                final Object value = values.remove("StockDocumentNumber");
                if( (value == null) || (!value.equals(getStockDocumentNumber())) ) {
                    setStockDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("StockItemNumber") ) {
                final Object value = values.remove("StockItemNumber");
                if( (value == null) || (!value.equals(getStockItemNumber())) ) {
                    setStockItemNumber(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryRefDocYear") ) {
                final Object value = values.remove("PhysicalInventoryRefDocYear");
                if( (value == null) || (!value.equals(getPhysicalInventoryRefDocYear())) ) {
                    setPhysicalInventoryRefDocYear(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryRefDocNumber") ) {
                final Object value = values.remove("PhysicalInventoryRefDocNumber");
                if( (value == null) || (!value.equals(getPhysicalInventoryRefDocNumber())) ) {
                    setPhysicalInventoryRefDocNumber(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryRefDocItem") ) {
                final Object value = values.remove("PhysicalInventoryRefDocItem");
                if( (value == null) || (!value.equals(getPhysicalInventoryRefDocItem())) ) {
                    setPhysicalInventoryRefDocItem(((String) value));
                }
            }
            if( values.containsKey("PInvFreeDefinedRefText") ) {
                final Object value = values.remove("PInvFreeDefinedRefText");
                if( (value == null) || (!value.equals(getPInvFreeDefinedRefText())) ) {
                    setPInvFreeDefinedRefText(((String) value));
                }
            }
            if( values.containsKey("PInvItemChgUTCDateTime") ) {
                final Object value = values.remove("PInvItemChgUTCDateTime");
                if( (value == null) || (!value.equals(getPInvItemChgUTCDateTime())) ) {
                    setPInvItemChgUTCDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WhsePhysicalInventoryCntItem") ) {
                final Object value = (values).remove("to_WhsePhysicalInventoryCntItem");
                if( value instanceof Iterable ) {
                    if( toWhsePhysicalInventoryCntItem == null ) {
                        toWhsePhysicalInventoryCntItem = Lists.newArrayList();
                    } else {
                        toWhsePhysicalInventoryCntItem = Lists.newArrayList(toWhsePhysicalInventoryCntItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WhsePhysicalInventoryCountItem entity;
                        if( toWhsePhysicalInventoryCntItem.size() > i ) {
                            entity = toWhsePhysicalInventoryCntItem.get(i);
                        } else {
                            entity = new WhsePhysicalInventoryCountItem();
                            toWhsePhysicalInventoryCntItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WhsePhysicalInventoryItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WhsePhysicalInventoryItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WhsePhysicalInventoryItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WhsePhysicalInventoryItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWhsePhysicalInventoryCntItem != null ) {
            (values).put("to_WhsePhysicalInventoryCntItem", toWhsePhysicalInventoryCntItem);
        }
        return values;
    }

    /**
     * Fetches the <b>WhsePhysicalInventoryCountItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WhsePhysicalInventoryCntItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WhsePhysicalInventoryCountItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhsePhysicalInventoryCountItem> fetchWhsePhysicalInventoryCntItem()
    {
        return fetchFieldAsList("to_WhsePhysicalInventoryCntItem", WhsePhysicalInventoryCountItem.class);
    }

    /**
     * Retrieval of associated <b>WhsePhysicalInventoryCountItem</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_WhsePhysicalInventoryCntItem</b>.
     * <p>
     * If the navigation property <b>to_WhsePhysicalInventoryCntItem</b> of a queried <b>WhsePhysicalInventoryItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WhsePhysicalInventoryCountItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WhsePhysicalInventoryCountItem> getWhsePhysicalInventoryCntItemOrFetch()
    {
        if( toWhsePhysicalInventoryCntItem == null ) {
            toWhsePhysicalInventoryCntItem = fetchWhsePhysicalInventoryCntItem();
        }
        return toWhsePhysicalInventoryCntItem;
    }

    /**
     * Retrieval of associated <b>WhsePhysicalInventoryCountItem</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_WhsePhysicalInventoryCntItem</b>.
     * <p>
     * If the navigation property for an entity <b>WhsePhysicalInventoryItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WhsePhysicalInventoryCntItem</b> is already loaded, the
     *         result will contain the <b>WhsePhysicalInventoryCountItem</b> entities. If not, an <code>Option</code>
     *         with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WhsePhysicalInventoryCountItem>> getWhsePhysicalInventoryCntItemIfPresent()
    {
        return Option.of(toWhsePhysicalInventoryCntItem);
    }

    /**
     * Overwrites the list of associated <b>WhsePhysicalInventoryCountItem</b> entities for the loaded navigation
     * property <b>to_WhsePhysicalInventoryCntItem</b>.
     * <p>
     * If the navigation property <b>to_WhsePhysicalInventoryCntItem</b> of a queried <b>WhsePhysicalInventoryItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WhsePhysicalInventoryCountItem</b> entities.
     */
    public void setWhsePhysicalInventoryCntItem( @Nonnull final List<WhsePhysicalInventoryCountItem> value )
    {
        if( toWhsePhysicalInventoryCntItem == null ) {
            toWhsePhysicalInventoryCntItem = Lists.newArrayList();
        }
        toWhsePhysicalInventoryCntItem.clear();
        toWhsePhysicalInventoryCntItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WhsePhysicalInventoryCountItem</b> entities. This corresponds to the
     * OData navigation property <b>to_WhsePhysicalInventoryCntItem</b>.
     * <p>
     * If the navigation property <b>to_WhsePhysicalInventoryCntItem</b> of a queried <b>WhsePhysicalInventoryItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WhsePhysicalInventoryCountItem</b> entities.
     */
    public void addWhsePhysicalInventoryCntItem( WhsePhysicalInventoryCountItem... entity )
    {
        if( toWhsePhysicalInventoryCntItem == null ) {
            toWhsePhysicalInventoryCntItem = Lists.newArrayList();
        }
        toWhsePhysicalInventoryCntItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WhsePhysicalInventoryItem instances.
     *
     */
    public final static class WhsePhysicalInventoryItemBuilder
    {

        private List<WhsePhysicalInventoryCountItem> toWhsePhysicalInventoryCntItem = Lists.newArrayList();

        private WhsePhysicalInventoryItem.WhsePhysicalInventoryItemBuilder toWhsePhysicalInventoryCntItem(
            final List<WhsePhysicalInventoryCountItem> value )
        {
            toWhsePhysicalInventoryCntItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WhsePhysicalInventoryCntItem</b> for <b>WhsePhysicalInventoryItem</b> to multiple
         * <b>WhsePhysicalInventoryCountItem</b>.
         *
         * @param value
         *            The WhsePhysicalInventoryCountItems to build this WhsePhysicalInventoryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WhsePhysicalInventoryItem.WhsePhysicalInventoryItemBuilder whsePhysicalInventoryCntItem(
            WhsePhysicalInventoryCountItem... value )
        {
            return toWhsePhysicalInventoryCntItem(Lists.newArrayList(value));
        }

    }

}
