/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.selectable.WhsePhysicalInventoryItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
 * WhsePhysicalInventoryItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class WhsePhysicalInventoryItemByKeyFluentHelper
    extends
    FluentHelperByKey<WhsePhysicalInventoryItemByKeyFluentHelper, WhsePhysicalInventoryItem, WhsePhysicalInventoryItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     * WhsePhysicalInventoryItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WhsePhysicalInventoryItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code WhsePhysicalInventoryItem}
     * @param physicalInventoryItemNumber
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param physicalInventoryDocumentUUID
     *            GUID for Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public WhsePhysicalInventoryItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID physicalInventoryDocumentUUID,
        final String physicalInventoryItemNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("PhysicalInventoryDocumentUUID", physicalInventoryDocumentUUID);
        this.key.put("PhysicalInventoryItemNumber", physicalInventoryItemNumber);
    }

    @Override
    @Nonnull
    protected Class<WhsePhysicalInventoryItem> getEntityClass()
    {
        return WhsePhysicalInventoryItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
