/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WarehousePhysicalInventoryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService
 * WarehousePhysicalInventoryService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWarehousePhysicalInventoryServiceBatch
    extends
    BatchFluentHelperBasic<WarehousePhysicalInventoryServiceBatch, WarehousePhysicalInventoryServiceBatchChangeSet>
    implements
    WarehousePhysicalInventoryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWarehousePhysicalInventoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehousePhysicalInventoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWarehousePhysicalInventoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehousePhysicalInventoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWarehousePhysicalInventoryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehousePhysicalInventoryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWarehousePhysicalInventoryServiceBatchChangeSet(this, service);
    }

}
