/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem;

/**
 * Implementation of the {@link WarehousePhysicalInventoryServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService
 * WarehousePhysicalInventoryService}.
 *
 */
public class DefaultWarehousePhysicalInventoryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WarehousePhysicalInventoryServiceBatch, WarehousePhysicalInventoryServiceBatchChangeSet>
    implements
    WarehousePhysicalInventoryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService service;

    @SuppressWarnings( "deprecation" )
    DefaultWarehousePhysicalInventoryServiceBatchChangeSet(
        @Nonnull final DefaultWarehousePhysicalInventoryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWarehousePhysicalInventoryServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehousePhysicalInventoryServiceBatchChangeSet createWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem )
    {
        return addRequestCreate(service::createWhsePhysicalInventoryCountItem, whsePhysicalInventoryCountItem);
    }

    @Nonnull
    @Override
    public WarehousePhysicalInventoryServiceBatchChangeSet updateWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem )
    {
        return addRequestUpdate(service::updateWhsePhysicalInventoryCountItem, whsePhysicalInventoryCountItem);
    }

    @Nonnull
    @Override
    public WarehousePhysicalInventoryServiceBatchChangeSet createWhsePhysicalInventoryItem(
        @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem )
    {
        return addRequestCreate(service::createWhsePhysicalInventoryItem, whsePhysicalInventoryItem);
    }

    @Nonnull
    @Override
    public WarehousePhysicalInventoryServiceBatchChangeSet updateWhsePhysicalInventoryItem(
        @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem )
    {
        return addRequestUpdate(service::updateWhsePhysicalInventoryItem, whsePhysicalInventoryItem);
    }

}
