/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehousePhysicalInventoryService
 * WarehousePhysicalInventoryService}.
 *
 */
public interface WarehousePhysicalInventoryServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<WarehousePhysicalInventoryServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<WarehousePhysicalInventoryServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     * WhsePhysicalInventoryCountItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryCountItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *            WhsePhysicalInventoryCountItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehousePhysicalInventoryServiceBatchChangeSet createWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     * WhsePhysicalInventoryCountItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryCountItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *            WhsePhysicalInventoryCountItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehousePhysicalInventoryServiceBatchChangeSet updateWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     * WhsePhysicalInventoryItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *            WhsePhysicalInventoryItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehousePhysicalInventoryServiceBatchChangeSet
        createWhsePhysicalInventoryItem( @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     * WhsePhysicalInventoryItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *            WhsePhysicalInventoryItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehousePhysicalInventoryServiceBatchChangeSet
        updateWhsePhysicalInventoryItem( @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem );

}
