/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
 * WhsePhysicalInventoryCountItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.field.WhsePhysicalInventoryCountItemField
 * WhsePhysicalInventoryCountItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.link.WhsePhysicalInventoryCountItemLink
 * WhsePhysicalInventoryCountItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PHYSICAL_INVENTORY_DOCUMENT_UUID
 * PHYSICAL_INVENTORY_DOCUMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PHYSICAL_INVENTORY_ITEM_NUMBER
 * PHYSICAL_INVENTORY_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#LINE_INDEX_OF_P_INV_ITEM
 * LINE_INDEX_OF_P_INV_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#P_INV_QUANTITY_SEQUENCE
 * P_INV_QUANTITY_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PHYSICAL_INVENTORY_ITEM_LEVEL
 * PHYSICAL_INVENTORY_ITEM_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#P_INV_ITEM_PARENT_TYPE
 * P_INV_ITEM_PARENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STORAGE_BIN
 * STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PARENT_HANDLING_UNIT_NUMBER
 * PARENT_HANDLING_UNIT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PHYSICAL_INVENTORY_ITEM_TYPE
 * PHYSICAL_INVENTORY_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#HANDLING_UNIT_NUMBER
 * HANDLING_UNIT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PRODUCT_UUID
 * PRODUCT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#BATCH_UUID
 * BATCH_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#SERIAL_NUMBER_REQUIRED_LEVEL
 * SERIAL_NUMBER_REQUIRED_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_TYPE
 * STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_OWNER
 * STOCK_OWNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_OWNER_PARTNER_ROLE
 * STOCK_OWNER_PARTNER_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_USAGE
 * STOCK_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#ENTITLED_TO_DISPOSE_PARTY
 * ENTITLED_TO_DISPOSE_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#ENTITLED_TO_DISPOSE_PARTNER_ROLE
 * ENTITLED_TO_DISPOSE_PARTNER_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_DOCUMENT_CATEGORY
 * STOCK_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_DOCUMENT_NUMBER
 * STOCK_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_ITEM_NUMBER
 * STOCK_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#DOCUMENT_RELTD_STOCK_DOC_CAT
 * DOCUMENT_RELTD_STOCK_DOC_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#WHSE_QUALITY_INSPECTION_TYPE
 * WHSE_QUALITY_INSPECTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#QUALITY_INSPECTION_DOC_UUID
 * QUALITY_INSPECTION_DOC_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STOCK_IDENTIFICATION_NUMBER
 * STOCK_IDENTIFICATION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#DOCUMENT_RELTD_STOCK_DOC_UUID
 * DOCUMENT_RELTD_STOCK_DOC_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#DOCUMENT_RELTD_STOCK_DOC_ITEM_UUID
 * DOCUMENT_RELTD_STOCK_DOC_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#WHSE_TASK_GOODS_RECEIPT_DATE_TIME
 * WHSE_TASK_GOODS_RECEIPT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#SHELF_LIFE_EXPIRATION_DATE
 * SHELF_LIFE_EXPIRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#MATL_BATCH_IS_IN_RSTRCD_USE_STOCK
 * MATL_BATCH_IS_IN_RSTRCD_USE_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#HNDLG_UNIT_ITEM_COUNTED_IS_COMPLETE
 * HNDLG_UNIT_ITEM_COUNTED_IS_COMPLETE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#HNDLG_UNIT_ITEM_COUNTED_IS_EMPTY
 * HNDLG_UNIT_ITEM_COUNTED_IS_EMPTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#HNDLG_UNIT_ITEM_COUNTED_IS_NOT_EXIST
 * HNDLG_UNIT_ITEM_COUNTED_IS_NOT_EXIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#PACKAGING_MATERIAL
 * PACKAGING_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#HANDLING_UNIT_TYPE
 * HANDLING_UNIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#STORAGE_BIN_IS_EMPTY
 * STORAGE_BIN_IS_EMPTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#P_INV_IS_ZERO_COUNT
 * P_INV_IS_ZERO_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#REQUESTED_QUANTITY_UNIT
 * REQUESTED_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#REQUESTED_QUANTITY
 * REQUESTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#P_INV_ITEM_CHG_UTC_DATE_TIME
 * P_INV_ITEM_CHG_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem#TO_WHSE_PHYSICAL_INVENTORY_ITEM
 * TO_WHSE_PHYSICAL_INVENTORY_ITEM}</li>
 * </ul>
 *
 */
public interface WhsePhysicalInventoryCountItemSelectable extends EntitySelectable<WhsePhysicalInventoryCountItem>
{

}
